/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.blocks;

import android.content.Context;
import android.text.Spanned;
import android.text.method.MovementMethod;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import io.intercom.android.sdk.Injector;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.blocks.BlockAlignment;
import io.intercom.android.sdk.blocks.StyleType;
import io.intercom.android.sdk.blocks.blockInterfaces.HeadingBlock;
import io.intercom.android.sdk.utilities.BlockUtils;
import io.intercom.android.sdk.utilities.ColorUtils;
import io.intercom.android.sdk.utilities.FontUtils;
import io.intercom.android.sdk.utilities.TrackingLinkMovementMethod;

public class Heading
implements HeadingBlock {
    private final LayoutInflater inflater;
    private final StyleType style;
    private final Context context;

    public Heading(Context context, LayoutInflater inflater, StyleType style) {
        this.style = style;
        this.context = context;
        this.inflater = inflater;
    }

    public View addHeading(Spanned text, BlockAlignment alignment, boolean isFirstObject, boolean isLastObject, ViewGroup parent) {
        TextView textview;
        int color2 = Injector.get().getIdentityStore().getAppConfig().getBaseColor();
        switch (this.style) {
            case ADMIN: {
                textview = (TextView)this.inflater.inflate(R.layout.intercom_blocks_admin_heading, parent, false);
                break;
            }
            case POST: {
                textview = (TextView)this.inflater.inflate(R.layout.intercom_blocks_post_heading, parent, false);
                color2 = ColorUtils.lightenColor(color2);
                textview.setTextColor(color2);
                textview.setLinkTextColor(color2);
                FontUtils.setTypeface(this.context, textview, "intercom_roboto_light.ttf");
                break;
            }
            case NOTE: 
            case CONTAINER_CARD: {
                textview = (TextView)this.inflater.inflate(R.layout.intercom_blocks_container_card_heading, parent, false);
                textview.setTextColor(color2);
                textview.setLinkTextColor(color2);
                FontUtils.setTypeface(this.context, textview, "intercom_roboto_light.ttf");
                break;
            }
            default: {
                textview = (TextView)this.inflater.inflate(R.layout.intercom_blocks_user_heading, parent, false);
            }
        }
        textview.setClickable(true);
        textview.setMovementMethod((MovementMethod)new TrackingLinkMovementMethod());
        textview.setText((CharSequence)text);
        textview.setGravity(alignment.getGravity());
        BlockUtils.setLayoutMarginsAndGravity((View)textview, alignment.getGravity(), isLastObject);
        return textview;
    }
}

