/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.api;

import io.intercom.android.sdk.identity.IdentityStore;
import io.intercom.android.sdk.logger.IntercomLogger;
import io.intercom.okhttp3.Interceptor;
import io.intercom.okhttp3.Response;
import java.io.IOException;

public class IdentityInterceptor
implements Interceptor {
    private static final String USER_IDENTITY_CHANGED = "registered user changed while this request was in flight";
    private static final String NO_USER_IDENTITY = "no user currently registered";
    private static final String NO_APP_IDENTITY = "the apiKey or appId used to initialise Intercom are invalid";
    private final IdentityStore identityStore;

    public IdentityInterceptor(IdentityStore identityStore) {
        this.identityStore = identityStore;
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        if (this.identityStore.userIdentityExists() && this.identityStore.appIdentityExists()) {
            String fingerprint = this.identityStore.getUserIdentityFingerprint();
            Response response = chain.proceed(chain.request());
            if (fingerprint.equals(this.identityStore.getUserIdentityFingerprint())) {
                IntercomLogger.internal("interceptor", "proceeding");
                return response;
            }
            IntercomLogger.internal("interceptor", "halting: user identity changed");
            if (response != null) {
                response.body().close();
            }
            throw new IOException(USER_IDENTITY_CHANGED);
        }
        if (!this.identityStore.appIdentityExists()) {
            throw new IOException(NO_APP_IDENTITY);
        }
        throw new IOException(NO_USER_IDENTITY);
    }
}

