/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.api;

import io.intercom.android.sdk.Injector;
import io.intercom.android.sdk.api.BaseCallback;
import io.intercom.android.sdk.api.ErrorObject;
import io.intercom.android.sdk.logger.IntercomLogger;
import io.intercom.android.sdk.metrics.MetricFactory;
import io.intercom.android.sdk.models.BaseResponse;
import io.intercom.android.sdk.models.Config;
import io.intercom.android.sdk.models.Conversation;
import io.intercom.android.sdk.models.ConversationsResponse;
import io.intercom.android.sdk.models.Part;
import io.intercom.android.sdk.models.ReadResponse;
import io.intercom.android.sdk.models.TeamPresence;
import io.intercom.android.sdk.models.UpdateUserResponse;
import io.intercom.android.sdk.models.User;
import io.intercom.android.sdk.models.UsersResponse;
import io.intercom.android.sdk.models.events.ConversationEvent;
import io.intercom.android.sdk.models.events.InboxEvent;
import io.intercom.android.sdk.models.events.NewConversationEvent;
import io.intercom.android.sdk.models.events.ReplyEvent;
import io.intercom.android.sdk.models.events.TeamPresenceUpdateEvent;
import io.intercom.android.sdk.models.events.UnreadConversationsEvent;
import io.intercom.android.sdk.models.events.failure.ConversationFailedEvent;
import io.intercom.android.sdk.models.events.failure.InboxFailedEvent;
import io.intercom.android.sdk.models.events.failure.NewConversationFailedEvent;
import io.intercom.android.sdk.models.events.failure.ReplyFailedEvent;
import io.intercom.retrofit2.Call;
import io.intercom.retrofit2.Callback;
import io.intercom.retrofit2.Response;

public class CallbackHolder {
    public BaseCallback<ReadResponse.Builder> readCallback() {
        return new BaseCallback<ReadResponse.Builder>(){

            @Override
            public void onSuccess(ReadResponse.Builder builder) {
                ReadResponse response = builder.build();
                CallbackHolder.this.updateBaseResponseObjects(response);
            }
        };
    }

    public BaseCallback<UsersResponse.Builder> unreadCallback() {
        return new BaseCallback<UsersResponse.Builder>(){

            @Override
            public void onSuccess(UsersResponse.Builder responseBuilder) {
                UsersResponse response = responseBuilder.build();
                CallbackHolder.this.updateBaseResponseObjects(response);
                Injector.get().getUnreadCountTracker().updateCount(response.getUnreadConversations().getTotalUnreadCount());
                Injector.get().getBus().post((Object)new UnreadConversationsEvent(response.getUnreadConversations()));
            }
        };
    }

    public BaseCallback<UpdateUserResponse.Builder> teamPresenceCallback() {
        return new BaseCallback<UpdateUserResponse.Builder>(){

            @Override
            void onSuccess(UpdateUserResponse.Builder builder) {
                TeamPresence teamPresence = builder.build().getTeamPresence();
                Injector.get().getTeamPresenceProvider().setTeamPresence(teamPresence);
                Injector.get().getBus().post((Object)new TeamPresenceUpdateEvent(teamPresence));
            }
        };
    }

    public Callback<ConversationsResponse.Builder> inboxCallback() {
        return new BaseCallback<ConversationsResponse.Builder>(){

            @Override
            public void onSuccess(ConversationsResponse.Builder builder) {
                ConversationsResponse response = builder.build();
                CallbackHolder.this.updateBaseResponseObjects(response);
                Injector.get().getUnreadCountTracker().updateCount(response.getConversationPage().getTotalUnreadCount());
                Injector.get().getBus().post((Object)new InboxEvent(response.getConversationPage()));
            }

            @Override
            public void onError(ErrorObject errorObject) {
                Injector.get().getBus().post((Object)new InboxFailedEvent());
            }
        };
    }

    public Callback<Part.Builder> replyCallback(final int position, final boolean isUpload, final String partId, final String conversationId) {
        return new BaseCallback<Part.Builder>(){

            @Override
            public void onSuccess(Part.Builder builder) {
                Injector.get().getBus().post((Object)new ReplyEvent(builder.build(), position, partId, conversationId));
            }

            @Override
            public void onError(ErrorObject errorObject) {
                Injector.get().getBus().post((Object)new ReplyFailedEvent(position, isUpload, partId));
            }
        };
    }

    public Callback<Conversation.Builder> conversationCallback() {
        return new BaseCallback<Conversation.Builder>(){

            @Override
            public void onSuccess(Conversation.Builder builder) {
                Injector.get().getBus().post((Object)new ConversationEvent(builder.build()));
            }

            @Override
            public void onError(ErrorObject errorObject) {
                Injector.get().getBus().post((Object)new ConversationFailedEvent());
            }
        };
    }

    public Callback<Conversation.Builder> newConversationCallback(final int position, final String partId) {
        return new BaseCallback<Conversation.Builder>(){

            @Override
            public void onSuccess(Conversation.Builder builder) {
                Conversation conversation = builder.build();
                Injector.get().getBus().post((Object)new NewConversationEvent(conversation, partId));
                Injector.get().getMetricsStore().track(MetricFactory.sentNewMessage(conversation.getId(), "new_conversation"));
            }

            @Override
            void onError(ErrorObject errorObject) {
                Injector.get().getBus().post((Object)new NewConversationFailedEvent(position, partId));
            }
        };
    }

    public Callback<Void> reactCallback() {
        return new Callback<Void>(){

            public void onResponse(Call<Void> call, Response<Void> response) {
                IntercomLogger.internal("Reaction success");
            }

            public void onFailure(Call<Void> call, Throwable t) {
                IntercomLogger.e("Failed to update reaction");
            }
        };
    }

    private void updateBaseResponseObjects(BaseResponse response) {
        this.updateIdentityStore(response.getUser());
        this.updateAppConfig(response.getConfig());
    }

    private void updateIdentityStore(User user) {
        Injector.get().getIdentityStore().setUser(user);
    }

    private void updateAppConfig(Config config) {
        Injector.get().getIdentityStore().setAppConfig(config);
    }
}

