/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.activities;

import android.animation.Animator;
import android.animation.ArgbEvaluator;
import android.animation.TypeEvaluator;
import android.animation.ValueAnimator;
import android.annotation.TargetApi;
import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.annotation.ColorRes;
import android.support.annotation.VisibleForTesting;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.FragmentTransaction;
import android.support.v4.content.ContextCompat;
import android.support.v4.view.MotionEventCompat;
import android.support.v7.app.AppCompatActivity;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.MotionEvent;
import android.view.View;
import android.view.inputmethod.InputMethodManager;
import io.intercom.android.sdk.Injector;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.conversation.ConversationFragment;
import io.intercom.android.sdk.fragments.MaterialDialog;
import io.intercom.android.sdk.inbox.ConversationsListFragment;
import io.intercom.android.sdk.logger.IntercomLogger;
import io.intercom.android.sdk.metrics.MetricFactory;
import io.intercom.android.sdk.models.LastParticipatingAdmin;
import io.intercom.android.sdk.models.events.CloseIAMEvent;
import io.intercom.android.sdk.utilities.BackgroundUtils;
import io.intercom.android.sdk.utilities.SimpleAnimatorListener;
import io.intercom.android.sdk.views.IntercomToolbar;
import io.intercom.android.sdk.views.StatusBarThemer;
import io.intercom.com.facebook.rebound.SimpleSpringListener;
import io.intercom.com.facebook.rebound.Spring;
import io.intercom.com.facebook.rebound.SpringConfig;
import io.intercom.com.facebook.rebound.SpringListener;
import io.intercom.com.facebook.rebound.SpringSystem;
import io.intercom.com.squareup.otto.Subscribe;

@TargetApi(value=15)
public class IamActivity
extends AppCompatActivity
implements ConversationsListFragment.Listener,
ConversationFragment.Listener,
MaterialDialog.Callback,
View.OnTouchListener,
IntercomToolbar.Listener {
    private static final int MESSAGE_FAILED_DIALOG = 1;
    private static final int DRAG_CHANGE_THRESHOLD_DP = 100;
    private static final int SPRING_TENSION = 600;
    private static final int SPRING_FRICTION = 40;
    @VisibleForTesting
    protected static final String PARCEL_CONVERSATION_ID = "parcel_conversation_id";
    @VisibleForTesting
    ValueAnimator colorAnimation;
    public static final String SHOW_INBOX = "showInbox";
    public static final String LAST_PARTICIPANT = "last_participant";
    private final ConversationsListFragment inbox = ConversationsListFragment.getInstance();
    private View containerView;
    private View background;
    private IntercomToolbar intercomToolbar;
    private Spring spring;
    private float startingPosition;
    private float touchStartY = 0.0f;
    private float lastTouchY = 0.0f;
    private int threshold;
    private boolean canDrag = false;
    private boolean isQuitting = false;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.intercom_activity_iam);
        this.setUpSpringSystem();
        this.intercomToolbar = (IntercomToolbar)this.findViewById(R.id.intercom_toolbar);
        this.intercomToolbar.setListener(this);
        this.setUpToolBar();
        this.containerView = this.findViewById(R.id.iam_container);
        this.containerView.setVisibility(8);
        Injector.init(this.getApplication());
        this.getFragmentManager().executePendingTransactions();
        this.showMessenger();
        Injector.get().getBus().register((Object)this);
        this.getSupportFragmentManager().addOnBackStackChangedListener(new FragmentManager.OnBackStackChangedListener(){

            public void onBackStackChanged() {
                ConversationsListFragment conversationsListFragment = (ConversationsListFragment)IamActivity.this.getSupportFragmentManager().findFragmentByTag(ConversationsListFragment.class.getName());
                if (conversationsListFragment != null && conversationsListFragment.isVisible()) {
                    IamActivity.this.switchToConversationListToolbar();
                }
            }
        });
    }

    private int getScreenHeight() {
        return this.findViewById(R.id.iam_root).getMeasuredHeight();
    }

    protected void onDestroy() {
        Injector.get().getBus().unregister((Object)this);
        super.onDestroy();
    }

    private void showMessenger() {
        Bundle data = this.getIntent().getExtras();
        String conversationId = "";
        LastParticipatingAdmin lastParticipatingAdmin = LastParticipatingAdmin.NULL;
        boolean shouldShowInbox = false;
        if (data != null) {
            if (data.containsKey(PARCEL_CONVERSATION_ID)) {
                conversationId = data.getString(PARCEL_CONVERSATION_ID);
            }
            if (data.containsKey(SHOW_INBOX)) {
                shouldShowInbox = data.getBoolean(SHOW_INBOX);
            }
            if (data.containsKey(LAST_PARTICIPANT)) {
                lastParticipatingAdmin = (LastParticipatingAdmin)data.getParcelable(LAST_PARTICIPANT);
            }
        }
        this.intercomToolbar.setOnTouchListener(this);
        this.threshold = (int)TypedValue.applyDimension((int)1, (float)100.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
        this.intercomToolbar.setUpFullToolbar();
        if (shouldShowInbox) {
            this.displayFragment((Fragment)this.inbox, ConversationsListFragment.class.getName(), false);
        } else {
            this.loadConversation(conversationId, lastParticipatingAdmin, false, false);
        }
        this.background = this.getWindow().getDecorView();
        BackgroundUtils.animateBackground(ContextCompat.getColor((Context)this, (int)17170445), ContextCompat.getColor((Context)this, (int)R.color.intercom_transparent_black), 200, this.background, new SimpleAnimatorListener(){

            @Override
            public void onAnimationEnd(Animator animation) {
                IamActivity.this.animateSdkWindowIn();
            }
        });
    }

    private void setUpSpringSystem() {
        SpringSystem springSystem = SpringSystem.create();
        this.spring = springSystem.createSpring();
        SpringConfig springConfig = new SpringConfig(600.0, 40.0);
        this.spring.setSpringConfig(springConfig);
    }

    private void displayFragment(Fragment frag, String tag, boolean addToBackStack) {
        IntercomLogger.internal("frag", "displaying " + frag);
        FragmentTransaction transaction = this.getSupportFragmentManager().beginTransaction();
        transaction.replace(R.id.iam_fragment, frag, tag);
        if (addToBackStack) {
            IntercomLogger.internal("frag", "adding " + frag + " to the back stack");
            transaction.addToBackStack(tag);
        }
        transaction.commit();
    }

    public void onBackPressed() {
        if (this.getSupportFragmentManager().getBackStackEntryCount() == 0) {
            this.closeMessenger();
        } else {
            this.intercomToolbar.setInboxButtonVisibility(8);
            super.onBackPressed();
        }
    }

    @Override
    public void inboxRowSelected() {
        this.intercomToolbar.fadeOutInbox();
    }

    @Override
    public void loadConversation(String conversationId, LastParticipatingAdmin participant, boolean isRead, boolean addToBackStack) {
        this.intercomToolbar.setNavigationItem(addToBackStack);
        this.displayFragment((Fragment)ConversationFragment.newInstance(conversationId, participant, isRead), ConversationFragment.class.getName(), addToBackStack);
    }

    @Override
    public void showErrorMessageDialog() {
        MaterialDialog dialog = MaterialDialog.getInstance(1, R.string.intercom_message_error, R.string.intercom_message_error_message, R.string.intercom_retry, 0);
        dialog.show(this.getSupportFragmentManager(), MaterialDialog.class.getName());
    }

    public boolean onTouch(View v, MotionEvent event) {
        switch (MotionEventCompat.getActionMasked((MotionEvent)event)) {
            case 0: {
                if (!this.canDrag) break;
                this.spring.removeAllListeners();
                this.spring.setAtRest();
                this.showBackgroundColour();
                this.lastTouchY = this.touchStartY = event.getRawY();
                break;
            }
            case 1: {
                ConversationFragment fragment;
                float dy = this.lastTouchY - this.touchStartY;
                float absDy = Math.abs(dy);
                if (absDy < 20.0f && (fragment = (ConversationFragment)this.getSupportFragmentManager().findFragmentByTag(ConversationFragment.class.getName())) != null) {
                    fragment.toggleProfile();
                }
                this.touchStartY = 0.0f;
                if (this.isQuitting || !this.canDrag) break;
                this.animateToOriginalSize();
                break;
            }
            case 2: {
                if (!this.canDrag) break;
                float y = event.getRawY();
                float dy = y - this.lastTouchY;
                this.containerView.getLayoutParams().height = this.containerView.getHeight() - (int)(dy / 2.0f);
                this.containerView.requestLayout();
                if (this.containerView.getY() > this.startingPosition + (float)this.threshold) {
                    this.isQuitting = true;
                    this.canDrag = false;
                    this.spring.removeAllListeners();
                    this.spring.setAtRest();
                    this.containerView.postDelayed(new Runnable(){

                        @Override
                        public void run() {
                            IamActivity.this.closeMessenger();
                        }
                    }, 100L);
                }
                this.lastTouchY = y;
                break;
            }
        }
        return true;
    }

    @Override
    public void setCountVisible() {
        this.intercomToolbar.setInboxButtonVisibility(0);
    }

    private void animateToOriginalSize() {
        this.spring.removeAllListeners();
        this.spring.setCurrentValue((double)this.containerView.getHeight());
        this.spring.setEndValue((double)this.getScreenHeight());
        this.spring.addListener((SpringListener)new SimpleSpringListener(){

            public void onSpringUpdate(Spring spring) {
                ((IamActivity)IamActivity.this).containerView.getLayoutParams().height = (int)spring.getCurrentValue();
                IamActivity.this.containerView.requestLayout();
            }

            public void onSpringAtRest(Spring spring) {
                ((IamActivity)IamActivity.this).containerView.getLayoutParams().height = -1;
                IamActivity.this.hideBackgroundColor();
            }
        });
    }

    private void animateSdkWindowIn() {
        this.spring.removeAllListeners();
        this.spring.setCurrentValue((double)this.getScreenHeight());
        this.spring.setEndValue(0.0);
        this.spring.setRestDisplacementThreshold(2.0);
        this.spring.setRestDisplacementThreshold(2.0);
        this.spring.addListener((SpringListener)new SimpleSpringListener(){

            public void onSpringAtRest(Spring spring) {
                IamActivity.this.startingPosition = IamActivity.this.containerView.getY();
                IamActivity.this.canDrag = true;
                IamActivity.this.hideBackgroundColor();
            }

            public void onSpringActivate(Spring spring) {
                IamActivity.this.containerView.setVisibility(0);
                IamActivity.this.canDrag = false;
            }

            public void onSpringUpdate(Spring spring) {
                float value = (float)spring.getCurrentValue();
                IamActivity.this.containerView.setY(value);
            }
        });
    }

    public void closeMessenger() {
        this.hideKeyboard();
        this.animateSdkWindowOut();
        this.fadeOutBackground();
        Injector.get().getMetricsStore().track(MetricFactory.closedMessenger());
    }

    private void hideKeyboard() {
        View focusedView = this.getCurrentFocus();
        if (focusedView != null) {
            InputMethodManager inputManager = (InputMethodManager)this.getSystemService("input_method");
            inputManager.hideSoftInputFromWindow(focusedView.getWindowToken(), 0);
        }
    }

    private void animateSdkWindowOut() {
        this.showBackgroundColour();
        this.spring.removeAllListeners();
        this.spring.setCurrentValue((double)this.containerView.getY());
        this.spring.setEndValue((double)this.getWindow().getDecorView().getHeight());
        this.spring.addListener((SpringListener)new SimpleSpringListener(){

            public void onSpringUpdate(Spring spring) {
                float value = (float)spring.getCurrentValue();
                IamActivity.this.containerView.setY(value);
            }
        });
    }

    private void fadeOutBackground() {
        int colorTo = ContextCompat.getColor((Context)this, (int)17170445);
        int colorFrom = ContextCompat.getColor((Context)this, (int)R.color.intercom_transparent_black);
        this.colorAnimation = ValueAnimator.ofObject((TypeEvaluator)new ArgbEvaluator(), (Object[])new Object[]{colorFrom, colorTo});
        this.colorAnimation.setDuration(300L);
        this.colorAnimation.setStartDelay(100L);
        this.colorAnimation.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animator2) {
                IamActivity.this.background.setBackgroundColor(((Integer)animator2.getAnimatedValue()).intValue());
            }
        });
        this.colorAnimation.addListener((Animator.AnimatorListener)new SimpleAnimatorListener(){

            @Override
            public void onAnimationEnd(Animator animation) {
                IamActivity.this.finish();
                IamActivity.this.overridePendingTransition(0, 0);
            }
        });
        this.colorAnimation.start();
    }

    private void switchToConversationListToolbar() {
        this.setUpToolBar();
    }

    private void setUpToolBar() {
        this.setToolbarColor();
        String appName = Injector.get().getIdentityStore().getAppConfig().getName();
        if (TextUtils.isEmpty((CharSequence)appName)) {
            this.intercomToolbar.setTitle(this.getString(R.string.intercom_chats));
        } else {
            this.intercomToolbar.setTitle(String.format(this.getString(R.string.intercom_chats_with), appName));
        }
    }

    @Override
    public void setToolbarColor() {
        this.intercomToolbar.setBackgroundColor(Injector.get().getIdentityStore().getAppConfig().getBaseColor());
    }

    private void showBackgroundColour() {
        this.background.setBackgroundResource(R.color.intercom_transparent_black);
    }

    private void hideBackgroundColor() {
        this.background.setBackgroundResource(R.color.intercom_full_transparent_full_black);
    }

    @Override
    public void setStatusBarColor() {
        StatusBarThemer.setStatusBarColor(this.getWindow());
    }

    public static Intent openInbox(Context context) {
        return new Intent(context, IamActivity.class).setFlags(0x10000000).putExtra(SHOW_INBOX, true);
    }

    public static Intent openComposer(Context context) {
        return new Intent(context, IamActivity.class).setFlags(0x10000000).putExtra(SHOW_INBOX, false);
    }

    public static Intent openConversationFull(Context context, String conversationId, LastParticipatingAdmin lastParticipatingAdmin) {
        Intent intent = new Intent(context, IamActivity.class).setFlags(0x10000000).putExtra(SHOW_INBOX, false);
        if (!TextUtils.isEmpty((CharSequence)conversationId)) {
            intent.putExtra(PARCEL_CONVERSATION_ID, conversationId);
        }
        if (!LastParticipatingAdmin.isNull(lastParticipatingAdmin)) {
            intent.putExtra(LAST_PARTICIPANT, (Parcelable)lastParticipatingAdmin);
        }
        return intent;
    }

    @Subscribe
    public void closeSdk(CloseIAMEvent event) {
        this.finish();
    }

    @Override
    public void onPrimaryButtonClicked(int requestCode) {
        ConversationFragment fragment;
        if (requestCode == 1 && (fragment = (ConversationFragment)this.getSupportFragmentManager().findFragmentByTag(ConversationFragment.class.getName())) != null) {
            fragment.retryTapped();
        }
    }

    @Override
    public void onSecondaryButtonClicked(int requestCode) {
    }

    @Override
    public void onCloseClicked() {
        this.closeMessenger();
    }

    @Override
    public void onInboxClicked() {
        this.switchToConversationListToolbar();
        ConversationsListFragment fragment = (ConversationsListFragment)this.getSupportFragmentManager().findFragmentByTag(ConversationsListFragment.class.getName());
        if (fragment != null) {
            this.onBackPressed();
        } else {
            this.displayFragment((Fragment)this.inbox, ConversationsListFragment.class.getName(), false);
        }
    }

    @Override
    public void setToolbarTitle(String title) {
        this.intercomToolbar.setTitle(title);
    }

    @Override
    public void setToolbarBackground(@ColorRes int color2) {
        this.intercomToolbar.setBackgroundColor(ContextCompat.getColor((Context)this, (int)color2));
    }

    public void onConfigurationChanged(Configuration configuration) {
        super.onConfigurationChanged(configuration);
        this.containerView.setY(0.0f);
        this.containerView.getLayoutParams().height = -1;
    }
}

