/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.com.facebook.rebound;

import io.intercom.com.facebook.rebound.ChoreographerCompat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;

public class AnimationQueue {
    private final ChoreographerCompat mChoreographer;
    private final Queue<Double> mPendingQueue = new LinkedList<Double>();
    private final Queue<Double> mAnimationQueue = new LinkedList<Double>();
    private final List<Callback> mCallbacks = new ArrayList<Callback>();
    private final ArrayList<Double> mTempValues = new ArrayList();
    private final ChoreographerCompat.FrameCallback mChoreographerCallback;
    private boolean mRunning;

    public AnimationQueue() {
        this.mChoreographer = ChoreographerCompat.getInstance();
        this.mChoreographerCallback = new ChoreographerCompat.FrameCallback(){

            @Override
            public void doFrame(long frameTimeNanos) {
                AnimationQueue.this.onFrame(frameTimeNanos);
            }
        };
    }

    public void addValue(Double value) {
        this.mPendingQueue.add(value);
        this.runIfIdle();
    }

    public void addAllValues(Collection<Double> values) {
        this.mPendingQueue.addAll(values);
        this.runIfIdle();
    }

    public void clearValues() {
        this.mPendingQueue.clear();
    }

    public void addCallback(Callback callback) {
        this.mCallbacks.add(callback);
    }

    public void removeCallback(Callback callback) {
        this.mCallbacks.remove(callback);
    }

    public void clearCallbacks() {
        this.mCallbacks.clear();
    }

    private void runIfIdle() {
        if (!this.mRunning) {
            this.mRunning = true;
            this.mChoreographer.postFrameCallback(this.mChoreographerCallback);
        }
    }

    private void onFrame(long frameTimeNanos) {
        int drainingOffset;
        Double nextPendingValue = this.mPendingQueue.poll();
        if (nextPendingValue != null) {
            this.mAnimationQueue.offer(nextPendingValue);
            drainingOffset = 0;
        } else {
            drainingOffset = Math.max(this.mCallbacks.size() - this.mAnimationQueue.size(), 0);
        }
        this.mTempValues.addAll(this.mAnimationQueue);
        for (int i = this.mTempValues.size() - 1; i > -1; --i) {
            Double val = this.mTempValues.get(i);
            int cbIdx = this.mTempValues.size() - 1 - i + drainingOffset;
            if (this.mCallbacks.size() <= cbIdx) continue;
            this.mCallbacks.get(cbIdx).onFrame(val);
        }
        this.mTempValues.clear();
        while (this.mAnimationQueue.size() + drainingOffset >= this.mCallbacks.size()) {
            this.mAnimationQueue.poll();
        }
        if (this.mAnimationQueue.isEmpty() && this.mPendingQueue.isEmpty()) {
            this.mRunning = false;
        } else {
            this.mChoreographer.postFrameCallback(this.mChoreographerCallback);
        }
    }

    public static interface Callback {
        public void onFrame(Double var1);
    }
}

