/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.com.bumptech.glide.request;

import android.graphics.drawable.Drawable;
import android.os.Handler;
import io.intercom.com.bumptech.glide.request.FutureTarget;
import io.intercom.com.bumptech.glide.request.Request;
import io.intercom.com.bumptech.glide.request.animation.GlideAnimation;
import io.intercom.com.bumptech.glide.request.target.SizeReadyCallback;
import io.intercom.com.bumptech.glide.util.Util;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class RequestFutureTarget<T, R>
implements FutureTarget<R>,
Runnable {
    private static final Waiter DEFAULT_WAITER = new Waiter();
    private final Handler mainHandler;
    private final int width;
    private final int height;
    private final boolean assertBackgroundThread;
    private final Waiter waiter;
    private R resource;
    private Request request;
    private boolean isCancelled;
    private Exception exception;
    private boolean resultReceived;
    private boolean exceptionReceived;

    public RequestFutureTarget(Handler mainHandler, int width, int height) {
        this(mainHandler, width, height, true, DEFAULT_WAITER);
    }

    RequestFutureTarget(Handler mainHandler, int width, int height, boolean assertBackgroundThread, Waiter waiter) {
        this.mainHandler = mainHandler;
        this.width = width;
        this.height = height;
        this.assertBackgroundThread = assertBackgroundThread;
        this.waiter = waiter;
    }

    @Override
    public synchronized boolean cancel(boolean mayInterruptIfRunning) {
        boolean result;
        if (this.isCancelled) {
            return true;
        }
        boolean bl = result = !this.isDone();
        if (result) {
            this.isCancelled = true;
            if (mayInterruptIfRunning) {
                this.clear();
            }
            this.waiter.notifyAll(this);
        }
        return result;
    }

    @Override
    public synchronized boolean isCancelled() {
        return this.isCancelled;
    }

    @Override
    public synchronized boolean isDone() {
        return this.isCancelled || this.resultReceived;
    }

    @Override
    public R get() throws InterruptedException, ExecutionException {
        try {
            return this.doGet(null);
        }
        catch (TimeoutException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public R get(long time, TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.doGet(timeUnit.toMillis(time));
    }

    @Override
    public void getSize(SizeReadyCallback cb) {
        cb.onSizeReady(this.width, this.height);
    }

    @Override
    public void setRequest(Request request) {
        this.request = request;
    }

    @Override
    public Request getRequest() {
        return this.request;
    }

    @Override
    public void onLoadCleared(Drawable placeholder) {
    }

    @Override
    public void onLoadStarted(Drawable placeholder) {
    }

    @Override
    public synchronized void onLoadFailed(Exception e, Drawable errorDrawable) {
        this.exceptionReceived = true;
        this.exception = e;
        this.waiter.notifyAll(this);
    }

    @Override
    public synchronized void onResourceReady(R resource, GlideAnimation<? super R> glideAnimation) {
        this.resultReceived = true;
        this.resource = resource;
        this.waiter.notifyAll(this);
    }

    private synchronized R doGet(Long timeoutMillis) throws ExecutionException, InterruptedException, TimeoutException {
        if (this.assertBackgroundThread) {
            Util.assertBackgroundThread();
        }
        if (this.isCancelled) {
            throw new CancellationException();
        }
        if (this.exceptionReceived) {
            throw new ExecutionException(this.exception);
        }
        if (this.resultReceived) {
            return this.resource;
        }
        if (timeoutMillis == null) {
            this.waiter.waitForTimeout(this, 0L);
        } else if (timeoutMillis > 0L) {
            this.waiter.waitForTimeout(this, timeoutMillis);
        }
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        if (this.exceptionReceived) {
            throw new ExecutionException(this.exception);
        }
        if (this.isCancelled) {
            throw new CancellationException();
        }
        if (!this.resultReceived) {
            throw new TimeoutException();
        }
        return this.resource;
    }

    @Override
    public void run() {
        if (this.request != null) {
            this.request.clear();
            this.cancel(false);
        }
    }

    @Override
    public void clear() {
        this.mainHandler.post((Runnable)this);
    }

    @Override
    public void onStart() {
    }

    @Override
    public void onStop() {
    }

    @Override
    public void onDestroy() {
    }

    static class Waiter {
        Waiter() {
        }

        public void waitForTimeout(Object toWaitOn, long timeoutMillis) throws InterruptedException {
            toWaitOn.wait(timeoutMillis);
        }

        public void notifyAll(Object toNotify) {
            toNotify.notifyAll();
        }
    }
}

