/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.com.bumptech.glide.load.engine;

import android.util.Log;
import io.intercom.com.bumptech.glide.Priority;
import io.intercom.com.bumptech.glide.load.Encoder;
import io.intercom.com.bumptech.glide.load.Key;
import io.intercom.com.bumptech.glide.load.Transformation;
import io.intercom.com.bumptech.glide.load.data.DataFetcher;
import io.intercom.com.bumptech.glide.load.engine.DiskCacheStrategy;
import io.intercom.com.bumptech.glide.load.engine.EngineKey;
import io.intercom.com.bumptech.glide.load.engine.Resource;
import io.intercom.com.bumptech.glide.load.engine.cache.DiskCache;
import io.intercom.com.bumptech.glide.load.resource.transcode.ResourceTranscoder;
import io.intercom.com.bumptech.glide.provider.DataLoadProvider;
import io.intercom.com.bumptech.glide.util.LogTime;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

class DecodeJob<A, T, Z> {
    private static final String TAG = "DecodeJob";
    private static final FileOpener DEFAULT_FILE_OPENER = new FileOpener();
    private final EngineKey resultKey;
    private final int width;
    private final int height;
    private final DataFetcher<A> fetcher;
    private final DataLoadProvider<A, T> loadProvider;
    private final Transformation<T> transformation;
    private final ResourceTranscoder<T, Z> transcoder;
    private final DiskCacheProvider diskCacheProvider;
    private final DiskCacheStrategy diskCacheStrategy;
    private final Priority priority;
    private final FileOpener fileOpener;
    private volatile boolean isCancelled;

    public DecodeJob(EngineKey resultKey, int width, int height, DataFetcher<A> fetcher, DataLoadProvider<A, T> loadProvider, Transformation<T> transformation, ResourceTranscoder<T, Z> transcoder, DiskCacheProvider diskCacheProvider, DiskCacheStrategy diskCacheStrategy, Priority priority) {
        this(resultKey, width, height, fetcher, loadProvider, transformation, transcoder, diskCacheProvider, diskCacheStrategy, priority, DEFAULT_FILE_OPENER);
    }

    DecodeJob(EngineKey resultKey, int width, int height, DataFetcher<A> fetcher, DataLoadProvider<A, T> loadProvider, Transformation<T> transformation, ResourceTranscoder<T, Z> transcoder, DiskCacheProvider diskCacheProvider, DiskCacheStrategy diskCacheStrategy, Priority priority, FileOpener fileOpener) {
        this.resultKey = resultKey;
        this.width = width;
        this.height = height;
        this.fetcher = fetcher;
        this.loadProvider = loadProvider;
        this.transformation = transformation;
        this.transcoder = transcoder;
        this.diskCacheProvider = diskCacheProvider;
        this.diskCacheStrategy = diskCacheStrategy;
        this.priority = priority;
        this.fileOpener = fileOpener;
    }

    public Resource<Z> decodeResultFromCache() throws Exception {
        if (!this.diskCacheStrategy.cacheResult()) {
            return null;
        }
        long startTime = LogTime.getLogTime();
        Resource<T> transformed = this.loadFromCache(this.resultKey);
        if (Log.isLoggable((String)TAG, (int)2)) {
            this.logWithTimeAndKey("Decoded transformed from cache", startTime);
        }
        startTime = LogTime.getLogTime();
        Resource<Z> result = this.transcode(transformed);
        if (Log.isLoggable((String)TAG, (int)2)) {
            this.logWithTimeAndKey("Transcoded transformed from cache", startTime);
        }
        return result;
    }

    public Resource<Z> decodeSourceFromCache() throws Exception {
        if (!this.diskCacheStrategy.cacheSource()) {
            return null;
        }
        long startTime = LogTime.getLogTime();
        Resource<T> decoded = this.loadFromCache(this.resultKey.getOriginalKey());
        if (Log.isLoggable((String)TAG, (int)2)) {
            this.logWithTimeAndKey("Decoded source from cache", startTime);
        }
        return this.transformEncodeAndTranscode(decoded);
    }

    public Resource<Z> decodeFromSource() throws Exception {
        Resource<T> decoded = this.decodeSource();
        return this.transformEncodeAndTranscode(decoded);
    }

    public void cancel() {
        this.isCancelled = true;
        this.fetcher.cancel();
    }

    private Resource<Z> transformEncodeAndTranscode(Resource<T> decoded) {
        long startTime = LogTime.getLogTime();
        Resource<T> transformed = this.transform(decoded);
        if (Log.isLoggable((String)TAG, (int)2)) {
            this.logWithTimeAndKey("Transformed resource from source", startTime);
        }
        this.writeTransformedToCache(transformed);
        startTime = LogTime.getLogTime();
        Resource<Z> result = this.transcode(transformed);
        if (Log.isLoggable((String)TAG, (int)2)) {
            this.logWithTimeAndKey("Transcoded transformed from source", startTime);
        }
        return result;
    }

    private void writeTransformedToCache(Resource<T> transformed) {
        if (transformed == null || !this.diskCacheStrategy.cacheResult()) {
            return;
        }
        long startTime = LogTime.getLogTime();
        SourceWriter<Resource<T>> writer = new SourceWriter<Resource<T>>(this.loadProvider.getEncoder(), transformed);
        this.diskCacheProvider.getDiskCache().put(this.resultKey, writer);
        if (Log.isLoggable((String)TAG, (int)2)) {
            this.logWithTimeAndKey("Wrote transformed from source to cache", startTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Resource<T> decodeSource() throws Exception {
        Resource<T> decoded = null;
        try {
            long startTime = LogTime.getLogTime();
            A data = this.fetcher.loadData(this.priority);
            if (Log.isLoggable((String)TAG, (int)2)) {
                this.logWithTimeAndKey("Fetched data", startTime);
            }
            if (this.isCancelled) {
                Resource<T> resource = null;
                return resource;
            }
            decoded = this.decodeFromSourceData(data);
        }
        finally {
            this.fetcher.cleanup();
        }
        return decoded;
    }

    private Resource<T> decodeFromSourceData(A data) throws IOException {
        Resource<T> decoded;
        if (this.diskCacheStrategy.cacheSource()) {
            decoded = this.cacheAndDecodeSourceData(data);
        } else {
            long startTime = LogTime.getLogTime();
            decoded = this.loadProvider.getSourceDecoder().decode(data, this.width, this.height);
            if (Log.isLoggable((String)TAG, (int)2)) {
                this.logWithTimeAndKey("Decoded from source", startTime);
            }
        }
        return decoded;
    }

    private Resource<T> cacheAndDecodeSourceData(A data) throws IOException {
        long startTime = LogTime.getLogTime();
        SourceWriter<A> writer = new SourceWriter<A>(this.loadProvider.getSourceEncoder(), data);
        this.diskCacheProvider.getDiskCache().put(this.resultKey.getOriginalKey(), writer);
        if (Log.isLoggable((String)TAG, (int)2)) {
            this.logWithTimeAndKey("Wrote source to cache", startTime);
        }
        startTime = LogTime.getLogTime();
        Resource<T> result = this.loadFromCache(this.resultKey.getOriginalKey());
        if (Log.isLoggable((String)TAG, (int)2) && result != null) {
            this.logWithTimeAndKey("Decoded source from cache", startTime);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Resource<T> loadFromCache(Key key) throws IOException {
        File cacheFile = this.diskCacheProvider.getDiskCache().get(key);
        if (cacheFile == null) {
            return null;
        }
        Resource<T> result = null;
        try {
            result = this.loadProvider.getCacheDecoder().decode(cacheFile, this.width, this.height);
        }
        finally {
            if (result == null) {
                this.diskCacheProvider.getDiskCache().delete(key);
            }
        }
        return result;
    }

    private Resource<T> transform(Resource<T> decoded) {
        if (decoded == null) {
            return null;
        }
        Resource<T> transformed = this.transformation.transform(decoded, this.width, this.height);
        if (!decoded.equals(transformed)) {
            decoded.recycle();
        }
        return transformed;
    }

    private Resource<Z> transcode(Resource<T> transformed) {
        if (transformed == null) {
            return null;
        }
        return this.transcoder.transcode(transformed);
    }

    private void logWithTimeAndKey(String message, long startTime) {
        Log.v((String)TAG, (String)(message + " in " + LogTime.getElapsedMillis(startTime) + ", key: " + this.resultKey));
    }

    static class FileOpener {
        FileOpener() {
        }

        public OutputStream open(File file) throws FileNotFoundException {
            return new BufferedOutputStream(new FileOutputStream(file));
        }
    }

    static interface DiskCacheProvider {
        public DiskCache getDiskCache();
    }

    class SourceWriter<DataType>
    implements DiskCache.Writer {
        private final Encoder<DataType> encoder;
        private final DataType data;

        public SourceWriter(Encoder<DataType> encoder, DataType data) {
            this.encoder = encoder;
            this.data = data;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean write(File file) {
            boolean success = false;
            OutputStream os = null;
            try {
                os = DecodeJob.this.fileOpener.open(file);
                success = this.encoder.encode(this.data, os);
            }
            catch (FileNotFoundException e) {
                if (Log.isLoggable((String)DecodeJob.TAG, (int)3)) {
                    Log.d((String)DecodeJob.TAG, (String)"Failed to find file to write to disk cache", (Throwable)e);
                }
            }
            finally {
                if (os != null) {
                    try {
                        os.close();
                    }
                    catch (IOException e) {}
                }
            }
            return success;
        }
    }
}

