/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.conversation;

import android.content.Context;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.support.annotation.StringRes;
import android.support.v4.content.ContextCompat;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.inputmethod.InputMethodManager;
import android.widget.EditText;
import android.widget.ImageButton;
import android.widget.LinearLayout;
import android.widget.TextView;
import io.intercom.android.sdk.Injector;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.conversation.ComposerTextWatcher;
import io.intercom.android.sdk.conversation.events.SendingEvent;
import io.intercom.android.sdk.identity.AppConfig;
import io.intercom.android.sdk.identity.UserIdentity;
import io.intercom.android.sdk.metrics.MetricsComposerTextWatcher;
import java.lang.reflect.Field;

public class ComposerInputView
extends LinearLayout
implements View.OnClickListener {
    private final EditText messageTextBox;
    private final ImageButton sendButton;
    private final ImageButton attachmentButton;
    private ComposerTextWatcher textWatcher;
    private MetricsComposerTextWatcher metricsTextWatcher;

    public ComposerInputView(Context context, AttributeSet attrs) {
        super(context, attrs);
        ComposerInputView.inflate((Context)this.getContext(), (int)R.layout.intercom_composer_input_layout, (ViewGroup)this);
        this.setGravity(17);
        this.setOrientation(0);
        this.sendButton = (ImageButton)this.findViewById(R.id.send_button);
        GradientDrawable fauxFab = (GradientDrawable)this.sendButton.getBackground();
        this.attachmentButton = (ImageButton)this.findViewById(R.id.attachment_button);
        this.messageTextBox = (EditText)this.findViewById(R.id.input_text);
        this.messageTextBox.setOnFocusChangeListener(new View.OnFocusChangeListener(){

            public void onFocusChange(View v, boolean hasFocus) {
                if (!hasFocus) {
                    ComposerInputView.this.hideKeyboard();
                }
            }
        });
        this.sendButton.setOnClickListener((View.OnClickListener)this);
        this.attachmentButton.setOnClickListener((View.OnClickListener)this);
        if (!this.isInEditMode()) {
            Injector injector = Injector.get();
            AppConfig appConfig = injector.getAppIdentity().getAppConfig();
            this.setCursorDrawableColor(appConfig.getBaseColor());
            fauxFab.setColor(appConfig.getBaseColor());
            UserIdentity userIdentity = injector.getUserIdentity();
            this.textWatcher = new ComposerTextWatcher(this.sendButton, this.attachmentButton, userIdentity.getIntercomId(), injector.getNexusClient());
            this.metricsTextWatcher = new MetricsComposerTextWatcher(injector.getMetricsStore());
            this.messageTextBox.addTextChangedListener((TextWatcher)this.textWatcher);
            this.messageTextBox.addTextChangedListener((TextWatcher)this.metricsTextWatcher);
        }
    }

    private void setCursorDrawableColor(int color2) {
        try {
            Field cursorDrawableRes = TextView.class.getDeclaredField("mCursorDrawableRes");
            cursorDrawableRes.setAccessible(true);
            Field editorField = TextView.class.getDeclaredField("mEditor");
            editorField.setAccessible(true);
            Object editor = editorField.get(this.messageTextBox);
            Class<?> editorClass = editor.getClass();
            Field cursorDrawableField = editorClass.getDeclaredField("mCursorDrawable");
            cursorDrawableField.setAccessible(true);
            Drawable cursorDrawable = ContextCompat.getDrawable((Context)this.getContext(), (int)cursorDrawableRes.getInt(this.messageTextBox));
            cursorDrawable.setColorFilter(color2, PorterDuff.Mode.SRC_IN);
            Drawable[] drawables = new Drawable[]{cursorDrawable, cursorDrawable};
            cursorDrawableField.set(editor, drawables);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void onClick(View v) {
        if (v.getId() == R.id.send_button) {
            Injector.get().getBus().post((Object)new SendingEvent(false));
        } else {
            Injector.get().getBus().post((Object)new SendingEvent(true));
        }
    }

    public void setConversationId(String conversationId) {
        this.textWatcher.setConversationId(conversationId);
        this.metricsTextWatcher.setConversationId(conversationId);
    }

    public String getTrimmedText() {
        return this.messageTextBox.getText().toString().trim();
    }

    public void hideKeyboard() {
        InputMethodManager imm = (InputMethodManager)this.getContext().getSystemService("input_method");
        imm.hideSoftInputFromWindow(this.messageTextBox.getWindowToken(), 0);
    }

    public void setHint(@StringRes int hintRes) {
        this.messageTextBox.setHint(hintRes);
    }

    public void requestInputFocus() {
        this.messageTextBox.requestFocus();
    }

    public void updateMaxLines() {
        this.messageTextBox.setMaxLines(this.getResources().getInteger(R.integer.intercom_max_composer_lines));
    }

    public void clear() {
        this.messageTextBox.setText((CharSequence)"");
        this.metricsTextWatcher.reset();
    }

    public void cleanup() {
        this.messageTextBox.removeTextChangedListener((TextWatcher)this.textWatcher);
        this.messageTextBox.removeTextChangedListener((TextWatcher)this.metricsTextWatcher);
        this.clear();
    }
}

