/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.api;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.intercom.twig.Twig;
import io.intercom.android.sdk.Injector;
import io.intercom.android.sdk.api.ErrorObject;
import io.intercom.android.sdk.logger.LumberMill;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u000e\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u00a8\u0006\u0004"}, d2={"extractErrorString", "", "errorObject", "Lio/intercom/android/sdk/api/ErrorObject;", "intercom-sdk-base_release"})
public final class ErrorStringExtractorKt {
    @NotNull
    public static final String extractErrorString(@NotNull ErrorObject errorObject) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)errorObject, (String)"errorObject");
        Twig twig = LumberMill.getLogger();
        if (errorObject.hasErrorBody() && errorObject.getErrorBody() != null) {
            Object object;
            try {
                JsonObject jsonObject = (JsonObject)Injector.get().getGson().fromJson(errorObject.getErrorBody(), JsonObject.class);
                if (jsonObject == null) {
                    return "Something went wrong";
                }
                object = jsonObject;
            }
            catch (Exception e) {
                twig.e((Throwable)e);
                Object object2 = errorObject.getThrowable();
                if (object2 == null || (object2 = ((Throwable)object2).getMessage()) == null) {
                    object2 = "Something went wrong";
                }
                return object2;
            }
            JsonObject jsonObject = object;
            if (jsonObject.has("error")) {
                object = jsonObject.get("error").getAsString();
                Intrinsics.checkNotNull((Object)object);
                string2 = object;
            } else if (jsonObject.has("errors")) {
                JsonArray jsonArray = jsonObject.getAsJsonArray("errors");
                Intrinsics.checkNotNullExpressionValue((Object)jsonArray, (String)"getAsJsonArray(...)");
                string2 = CollectionsKt.joinToString$default((Iterable)((Iterable)jsonArray), (CharSequence)" - ", null, null, (int)0, null, ErrorStringExtractorKt::extractErrorString$lambda$0, (int)30, null);
            } else {
                string2 = "Something went wrong";
            }
        } else {
            string2 = "Something went wrong";
        }
        return string2;
    }

    private static final CharSequence extractErrorString$lambda$0(JsonElement it) {
        CharSequence charSequence;
        if (it.isJsonObject() && it.getAsJsonObject().has("message")) {
            String string2 = it.getAsJsonObject().get("message").getAsString();
            Intrinsics.checkNotNull((Object)string2);
            charSequence = string2;
        } else {
            charSequence = "Something went wrong";
        }
        return charSequence;
    }
}

