/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import com.intercom.twig.Twig;
import io.intercom.android.sdk.Provider;
import io.intercom.android.sdk.api.Api;
import io.intercom.android.sdk.identity.AppConfig;
import io.intercom.android.sdk.identity.UserIdentity;
import io.intercom.android.sdk.logger.LumberMill;
import io.intercom.android.sdk.m5.data.IntercomDataLayer;
import io.intercom.android.sdk.m5.data.IntercomEvent;
import io.intercom.android.sdk.metrics.UnreadConversationsTracker;
import io.intercom.android.sdk.overlay.OverlayPresenter;
import io.intercom.android.sdk.user.DeviceData;
import io.intercom.android.sdk.utilities.ActivityFinisher;

public class ResetManager {
    private final Provider<Api> apiProvider;
    private final UserIdentity userIdentity;
    private final OverlayPresenter overlayPresenter;
    private final Provider<AppConfig> appConfigProvider;
    private final Context context;
    private final ActivityFinisher activityFinisher;
    private final IntercomDataLayer dataLayer;
    private final UnreadConversationsTracker unreadConversationsTracker;
    private final Handler handler = new Handler(Looper.getMainLooper());
    private final Twig twig = LumberMill.getLogger();
    private final Runnable hardResetTask = new Runnable(){

        @Override
        public void run() {
            ResetManager.this.hardReset();
        }
    };

    public ResetManager(Provider<Api> apiProvider, UserIdentity userIdentity, OverlayPresenter overlayPresenter, Provider<AppConfig> appConfigProvider, Context context, ActivityFinisher activityFinisher, IntercomDataLayer dataLayer, UnreadConversationsTracker unreadConversationsTracker) {
        this.apiProvider = apiProvider;
        this.userIdentity = userIdentity;
        this.overlayPresenter = overlayPresenter;
        this.appConfigProvider = appConfigProvider;
        this.context = context;
        this.activityFinisher = activityFinisher;
        this.dataLayer = dataLayer;
        this.unreadConversationsTracker = unreadConversationsTracker;
    }

    public void softReset() {
        this.activityFinisher.finishActivities();
        this.overlayPresenter.softReset();
        this.handler.postDelayed(this.hardResetTask, this.appConfigProvider.get().getSoftResetTimeoutMs());
        this.dataLayer.emitEvent(IntercomEvent.SoftReset.INSTANCE);
        this.userIdentity.softReset();
        this.twig.i("Successfully reset the user. To resume communicating with Intercom, you can register a user", new Object[0]);
    }

    public void hardReset() {
        this.handler.removeCallbacks(this.hardResetTask);
        this.dataLayer.clearUserData();
        this.unreadConversationsTracker.clear();
        if (this.isSoftReset()) {
            String deviceToken = DeviceData.getDeviceToken(this.context);
            if (TextUtils.isEmpty((CharSequence)deviceToken)) {
                this.twig.internal("There is no device token to remove.");
            } else {
                this.apiProvider.get().removeDeviceToken(deviceToken, this.userIdentity);
            }
            this.dataLayer.hardReset();
            this.userIdentity.hardReset();
        }
    }

    public void clear() {
        this.handler.removeCallbacks(this.hardResetTask);
    }

    boolean isSoftReset() {
        return this.userIdentity.isSoftReset();
    }
}

