/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.api;

import com.intercom.twig.Twig;
import io.intercom.android.sdk.api.ErrorObject;
import io.intercom.android.sdk.logger.LumberMill;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

public abstract class BaseCallback<T>
implements Callback<T> {
    private final Twig twig = LumberMill.getLogger();

    protected abstract void onSuccess(T var1);

    protected void onError(ErrorObject errorDetails) {
    }

    void logFailure(String reason, ErrorObject error) {
        this.twig.e(reason + ": " + BaseCallback.getDetails(error), new Object[0]);
    }

    public final void onResponse(Call<T> call, Response<T> response) {
        if (response == null) {
            this.handleError(new ErrorObject(new IllegalStateException("No body returned from the server"), null));
        } else if (response.body() == null) {
            this.handleError(new ErrorObject(new IllegalStateException("No body returned from the server"), response));
        } else if (!response.isSuccessful()) {
            this.handleError(new ErrorObject(new Exception("Status code outside the 200-300 range"), response));
        } else {
            this.onSuccess(response.body());
        }
    }

    public final void onFailure(Call<T> call, Throwable throwable) {
        this.handleError(new ErrorObject(throwable, null));
    }

    private void handleError(ErrorObject error) {
        this.logFailure("Api call failed", error);
        this.onError(error);
    }

    static String getDetails(ErrorObject error) {
        String reason = error.hasErrorBody() ? error.getErrorBody() : error.getThrowable().getMessage();
        if (reason == null) {
            reason = "unknown error";
        }
        return reason;
    }
}

