/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.models;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.Nullable;
import io.intercom.android.sdk.blocks.lib.models.Block;
import io.intercom.android.sdk.models.AiAnswerInfo;
import io.intercom.android.sdk.models.Attachments;
import io.intercom.android.sdk.models.Conversation;
import io.intercom.android.sdk.models.DeliveryOption;
import io.intercom.android.sdk.models.EventData;
import io.intercom.android.sdk.models.Form;
import io.intercom.android.sdk.models.MessageStyle;
import io.intercom.android.sdk.models.Metadata;
import io.intercom.android.sdk.models.Participant;
import io.intercom.android.sdk.models.ReactionReply;
import io.intercom.android.sdk.models.ReplyOption;
import io.intercom.android.sdk.models.Source;
import io.intercom.android.sdk.utilities.NullSafety;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import kotlin.Deprecated;

public class Part
implements Parcelable {
    private final String id;
    private final List<Attachments> attachments;
    private final String summary;
    private final ReactionReply reactionReply;
    private final boolean isInitialMessage;
    private final long createdAt;
    private final boolean participantIsAdmin;
    private final MessageStyle messageStyle;
    private final DeliveryOption deliveryOption;
    private final List<Block> blocks;
    private final EventData eventData;
    private final List<ReplyOption> replyOptions;
    private final Form form;
    private String clientAssignedUuid;
    private final List<Source> sources;
    private final AiAnswerInfo aiAnswerInfo;
    private String participantId;
    private String seenByAdmin;
    @Nullable
    private final Metadata metadata;
    private Conversation parentConversation;
    private MessageState messageState;
    private Participant participant;
    private boolean fromVoiceDictation;
    public static final Part NULL = new Part(new Builder());
    public static final Parcelable.Creator<Part> CREATOR = new Parcelable.Creator<Part>(){

        public Part createFromParcel(Parcel in) {
            return new Part(in);
        }

        public Part[] newArray(int size) {
            return new Part[size];
        }
    };

    public Part() {
        this(new Builder());
    }

    private Part(Builder builder) {
        this.id = builder.id == null ? UUID.randomUUID().toString() : builder.id;
        this.participantId = NullSafety.valueOrEmpty(builder.participant_id);
        this.participantIsAdmin = builder.participant_is_admin;
        this.summary = NullSafety.valueOrEmpty(builder.summary);
        this.createdAt = builder.created_at;
        this.messageStyle = builder.message_style == null ? MessageStyle.CHAT : builder.message_style;
        this.deliveryOption = builder.delivery_option == null ? DeliveryOption.SUMMARY : builder.delivery_option;
        this.blocks = new ArrayList<Block>();
        if (builder.body != null) {
            for (Block.Builder blockBuilder : builder.body) {
                this.blocks.add(blockBuilder.build());
            }
        }
        this.reactionReply = builder.reactions_reply == null ? ReactionReply.NULL : builder.reactions_reply.build();
        this.seenByAdmin = builder.seen_by_admin == null ? "hide" : builder.seen_by_admin;
        this.attachments = new ArrayList<Attachments>();
        if (builder.attachments != null) {
            for (Attachments.Builder attachmentBuilder : builder.attachments) {
                this.attachments.add(attachmentBuilder.build());
            }
        }
        this.eventData = builder.event_data == null ? EventData.NULL : builder.event_data;
        this.parentConversation = new Conversation();
        this.participant = Participant.NULL;
        this.isInitialMessage = builder.is_initial_message;
        this.messageState = MessageState.NORMAL;
        this.replyOptions = new ArrayList<ReplyOption>();
        if (builder.reply_options != null) {
            this.replyOptions.addAll(builder.reply_options);
        }
        this.form = builder.form == null ? new Form("", Collections.emptyList(), false) : builder.form;
        this.clientAssignedUuid = NullSafety.valueOrEmpty(builder.client_assigned_uuid);
        this.sources = new ArrayList<Source>();
        if (builder.sources != null) {
            this.sources.addAll(builder.sources);
        }
        this.aiAnswerInfo = builder.ai_answer_info == null ? new AiAnswerInfo("") : builder.ai_answer_info;
        this.fromVoiceDictation = builder.fromVoiceDictation;
        this.metadata = builder.metadata;
    }

    public DeliveryOption getDeliveryOption() {
        return this.deliveryOption;
    }

    public String getId() {
        return this.id;
    }

    public String getParticipantId() {
        return this.participantId;
    }

    public boolean isAdmin() {
        return this.participantIsAdmin;
    }

    public boolean isUser() {
        return !this.isAdmin();
    }

    public List<Block> getBlocks() {
        return this.blocks;
    }

    public List<Attachments> getAttachments() {
        return this.attachments;
    }

    public List<ReplyOption> getReplyOptions() {
        return this.replyOptions;
    }

    public Form getForm() {
        return this.form;
    }

    public List<Source> getSources() {
        return this.sources;
    }

    public AiAnswerInfo getAiAnswerInfo() {
        return this.aiAnswerInfo;
    }

    public boolean hasAttachments() {
        return !this.attachments.isEmpty();
    }

    public MessageStyle getMessageStyle() {
        return this.messageStyle;
    }

    public long getCreatedAt() {
        return this.createdAt;
    }

    public String getSummary() {
        return this.summary;
    }

    public ReactionReply getReactionReply() {
        return this.reactionReply;
    }

    public String getSeenByAdmin() {
        return this.participantIsAdmin ? "hide" : this.seenByAdmin;
    }

    public boolean isFromVoiceDictation() {
        return this.fromVoiceDictation;
    }

    public Participant getParticipant() {
        return this.participant;
    }

    public void setParticipant(Participant participant) {
        this.participant = participant;
        this.participantId = participant.getId();
    }

    @Deprecated(message="This was added for use in tickets. With conversation rewrite, we should use {@link ContentRow.MessageRow.PartWrapper )} instead to add in data that we require from the parent conversation object.")
    public Conversation getParentConversation() {
        return this.parentConversation;
    }

    public void setParentConversation(Conversation conversation) {
        this.parentConversation = conversation;
    }

    public MessageState getMessageState() {
        return this.messageState;
    }

    public void setMessageState(MessageState messageState) {
        this.messageState = messageState;
    }

    public boolean isInitialMessage() {
        return this.isInitialMessage;
    }

    public boolean isReply() {
        return !this.isInitialMessage;
    }

    public String getUuid() {
        return this.clientAssignedUuid;
    }

    public EventData getEventData() {
        return this.eventData;
    }

    @Nullable
    public Metadata getMetadata() {
        return this.metadata;
    }

    public Boolean isEvent() {
        return !this.eventData.getEventAsPlainText().isEmpty() || this.eventData.getCustomStateLabel() != null && !this.eventData.getCustomStateLabel().isEmpty() || this.eventData.getMergedConversationId() != null && !this.eventData.getMergedConversationId().isEmpty();
    }

    private Part(Parcel in) {
        this.id = in.readString();
        this.participantId = in.readString();
        this.participantIsAdmin = in.readByte() != 0;
        this.blocks = new ArrayList<Block>();
        in.readList(this.blocks, Block.class.getClassLoader());
        this.attachments = new ArrayList<Attachments>();
        in.readList(this.attachments, Attachments.class.getClassLoader());
        this.replyOptions = new ArrayList<ReplyOption>();
        in.readList(this.replyOptions, ReplyOption.class.getClassLoader());
        this.messageStyle = (MessageStyle)((Object)in.readValue(MessageStyle.class.getClassLoader()));
        this.createdAt = in.readLong();
        this.summary = in.readString();
        boolean isNullReaction = in.readByte() == 0;
        this.reactionReply = isNullReaction ? ReactionReply.NULL : (ReactionReply)in.readValue(ReactionReply.class.getClassLoader());
        this.seenByAdmin = in.readString();
        this.participant = (Participant)in.readValue(Participant.class.getClassLoader());
        this.eventData = (EventData)in.readValue(EventData.class.getClassLoader());
        this.isInitialMessage = in.readByte() != 0;
        this.deliveryOption = (DeliveryOption)((Object)in.readValue(DeliveryOption.class.getClassLoader()));
        this.form = (Form)in.readValue(Form.class.getClassLoader());
        this.sources = new ArrayList<Source>();
        in.readList(this.sources, Source.class.getClassLoader());
        this.aiAnswerInfo = (AiAnswerInfo)in.readValue(AiAnswerInfo.class.getClassLoader());
        this.metadata = (Metadata)in.readValue(Metadata.class.getClassLoader());
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.id);
        dest.writeString(this.participantId);
        dest.writeByte((byte)(this.participantIsAdmin ? 1 : 0));
        dest.writeList(this.blocks);
        dest.writeList(this.attachments);
        dest.writeList(this.replyOptions);
        dest.writeValue((Object)this.messageStyle);
        dest.writeLong(this.createdAt);
        dest.writeString(this.summary);
        if (ReactionReply.isNull(this.reactionReply)) {
            dest.writeByte((byte)0);
        } else {
            dest.writeByte((byte)1);
            dest.writeValue((Object)this.reactionReply);
        }
        dest.writeString(this.seenByAdmin);
        dest.writeValue((Object)this.participant);
        dest.writeValue((Object)this.eventData);
        dest.writeByte((byte)(this.isInitialMessage ? 1 : 0));
        dest.writeValue((Object)this.deliveryOption);
        dest.writeValue((Object)this.form);
        dest.writeList(this.sources);
        dest.writeValue((Object)this.aiAnswerInfo);
        dest.writeValue((Object)this.metadata);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof Part) {
            Part otherPart = (Part)o;
            return (this.id.equals(otherPart.id) && this.form.equals(otherPart.form) || !this.clientAssignedUuid.equals("") && this.clientAssignedUuid.equals(otherPart.clientAssignedUuid)) && this.seenByAdmin.equals(otherPart.seenByAdmin);
        }
        return false;
    }

    public static final class Builder {
        @Nullable
        String id;
        @Nullable
        String participant_id;
        @Nullable
        List<Block.Builder> body;
        @Nullable
        List<Attachments.Builder> attachments;
        @Nullable
        MessageStyle message_style;
        @Nullable
        String summary;
        @Nullable
        ReactionReply.Builder reactions_reply;
        @Nullable
        DeliveryOption delivery_option;
        @Nullable
        String seen_by_admin;
        @Nullable
        EventData event_data;
        @Nullable
        List<ReplyOption> reply_options;
        @Nullable
        Form form;
        @Nullable
        String client_assigned_uuid;
        @Nullable
        List<Source> sources;
        @Nullable
        AiAnswerInfo ai_answer_info;
        @Nullable
        Metadata metadata;
        boolean participant_is_admin;
        long created_at;
        boolean is_initial_message;
        boolean fromVoiceDictation = false;

        public Builder withId(String partId) {
            this.id = partId;
            return this;
        }

        public Builder withIsInitialMessage(Boolean isInitialMessage) {
            this.is_initial_message = isInitialMessage;
            return this;
        }

        public Builder withEventData(EventData eventData) {
            this.event_data = eventData;
            return this;
        }

        public Builder withStyle(MessageStyle style) {
            this.message_style = style;
            return this;
        }

        public Builder withSummary(String summary) {
            this.summary = summary;
            return this;
        }

        public Builder withCreatedAt(long createdAt) {
            this.created_at = createdAt;
            return this;
        }

        public Builder withParticipantIsAdmin(boolean participantIsAdmin) {
            this.participant_is_admin = participantIsAdmin;
            return this;
        }

        public Builder withParticipantId(String participantId) {
            this.participant_id = participantId;
            return this;
        }

        public Builder withBlocks(List<Block.Builder> blocks2) {
            this.body = blocks2;
            return this;
        }

        public Builder withReplyOptions(List<ReplyOption> replyOptions) {
            this.reply_options = replyOptions;
            return this;
        }

        public Builder withForm(Form form) {
            this.form = form;
            return this;
        }

        public Builder withSources(List<Source> sources) {
            this.sources = sources;
            return this;
        }

        public Builder withAiAnswerInfo(AiAnswerInfo aiAnswerInfo) {
            this.ai_answer_info = aiAnswerInfo;
            return this;
        }

        public Builder withClientAssignedUuid(String clientAssignedUuid) {
            this.client_assigned_uuid = clientAssignedUuid;
            return this;
        }

        public Builder withAttachments(List<Attachments.Builder> attachments) {
            this.attachments = attachments;
            return this;
        }

        public Builder withFromVoiceDictation(boolean fromVoiceDictation) {
            this.fromVoiceDictation = fromVoiceDictation;
            return this;
        }

        public Builder withSeenByAdmin(String seenByAdmin) {
            this.seen_by_admin = seenByAdmin;
            return this;
        }

        public Builder withMetadata(Metadata metadata) {
            this.metadata = metadata;
            return this;
        }

        public Builder withDeliveryOptions(DeliveryOption option) {
            this.delivery_option = option;
            return this;
        }

        public Part build() {
            return new Part(this);
        }
    }

    public static enum MessageState {
        SENDING,
        FAILED,
        UPLOAD_FAILED,
        NORMAL;

    }
}

