/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.views;

import android.animation.Animator;
import android.animation.ObjectAnimator;
import android.animation.PropertyValuesHolder;
import android.content.Context;
import android.util.AttributeSet;
import android.util.Property;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import androidx.annotation.Nullable;
import io.intercom.android.sdk.R;
import java.util.concurrent.TimeUnit;

public class AdminIsTypingView
extends LinearLayout {
    private static final int IS_TYPING_DURATION_SECONDS = 10;
    private static final float SMALL_SCALE = 0.4f;
    private static final float FADED_ALPHA = 0.7f;
    private static final int ANIMATION_DELAY_MS = 100;
    private static final int ANIMATION_DURATION_MS = 200;
    final ImageView[] dots = new ImageView[3];
    final Animator[] dotsAnimations = new Animator[3];
    boolean animating = false;
    @Nullable
    private Listener listener;
    final Runnable animateDots = new Runnable(){

        @Override
        public void run() {
            for (int i = 0; i < AdminIsTypingView.this.dots.length; ++i) {
                AdminIsTypingView.this.dotsAnimations[i].start();
            }
            AdminIsTypingView.this.postDelayed(AdminIsTypingView.this.animateDots, TimeUnit.SECONDS.toMillis(1L));
        }
    };
    final Runnable endAnimation = new Runnable(){

        @Override
        public void run() {
            AdminIsTypingView.this.animating = false;
            AdminIsTypingView.this.removeCallbacks(AdminIsTypingView.this.animateDots);
            AdminIsTypingView.this.removeCallbacks(AdminIsTypingView.this.endAnimation);
            if (AdminIsTypingView.this.listener != null) {
                AdminIsTypingView.this.listener.onAdminTypingAnimationEnded(AdminIsTypingView.this);
            }
            for (Animator set : AdminIsTypingView.this.dotsAnimations) {
                set.cancel();
            }
        }
    };

    public AdminIsTypingView(Context context) {
        this(context, null);
    }

    public AdminIsTypingView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        AdminIsTypingView.inflate((Context)this.getContext(), (int)R.layout.intercom_admin_is_typing, (ViewGroup)this);
        this.dots[0] = (ImageView)this.findViewById(R.id.dot1);
        this.dots[1] = (ImageView)this.findViewById(R.id.dot2);
        this.dots[2] = (ImageView)this.findViewById(R.id.dot3);
        PropertyValuesHolder scaleX = PropertyValuesHolder.ofFloat((Property)View.SCALE_X, (float[])new float[]{0.4f, 1.0f});
        PropertyValuesHolder scaleY = PropertyValuesHolder.ofFloat((Property)View.SCALE_Y, (float[])new float[]{0.4f, 1.0f});
        PropertyValuesHolder alpha = PropertyValuesHolder.ofFloat((Property)View.ALPHA, (float[])new float[]{0.7f, 1.0f});
        for (int i = 0; i < this.dotsAnimations.length; ++i) {
            ObjectAnimator anim2 = ObjectAnimator.ofPropertyValuesHolder((Object)this.dots[i], (PropertyValuesHolder[])new PropertyValuesHolder[]{alpha, scaleX, scaleY});
            anim2.setRepeatCount(1);
            anim2.setRepeatMode(2);
            anim2.setDuration(200L);
            anim2.setStartDelay((long)(i * 100));
            this.dotsAnimations[i] = anim2;
        }
        this.setupEndCondition();
    }

    public void beginAnimation() {
        if (!this.animating) {
            this.animating = true;
            this.animateDots.run();
        }
    }

    public void setListener(@Nullable Listener listener2) {
        this.listener = listener2;
    }

    private void setupEndCondition() {
        this.postDelayed(this.endAnimation, TimeUnit.SECONDS.toMillis(10L));
    }

    public void renewTypingAnimation() {
        this.removeCallbacks(this.endAnimation);
        this.setupEndCondition();
    }

    public void cancelTypingAnimation() {
        this.endAnimation.run();
    }

    public static interface Listener {
        public void onAdminTypingAnimationEnded(AdminIsTypingView var1);
    }
}

