/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.errorreporting;

import io.intercom.android.sdk.errorreporting.ErrorReport;
import io.intercom.android.sdk.errorreporting.ExceptionReport;
import io.intercom.android.sdk.utilities.commons.TimeProvider;
import java.util.ArrayList;
import java.util.List;

class ExceptionParser {
    private static final String INTERCOM_SDK_PACKAGE = "io.intercom.android.sdk";
    private static final String[] ALLOWED_PACKAGES = new String[]{"io.intercom.android.sdk", "java.", "android.", "com.android.", "com.google."};
    private static final String REDACTION_LINE = "[Non Intercom/OS method]";

    ExceptionParser() {
    }

    ErrorReport createReportFrom(Throwable exception) {
        return new ErrorReport(this.createExceptionReports(exception), TimeProvider.SYSTEM.currentTimeMillis());
    }

    private List<ExceptionReport> createExceptionReports(Throwable exception) {
        ArrayList<ExceptionReport> reports = new ArrayList<ExceptionReport>();
        for (Throwable currentException = exception; currentException != null; currentException = currentException.getCause()) {
            reports.add(new ExceptionReport(currentException.getClass().getName(), currentException.getLocalizedMessage(), this.getStacktraceString(currentException.getStackTrace())));
        }
        return reports;
    }

    private String getStacktraceString(StackTraceElement[] stackTrace) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < stackTrace.length; ++i) {
            StackTraceElement element = stackTrace[i];
            builder.append(this.isFromAllowedPackage(element) ? element.toString() : REDACTION_LINE);
            if (i >= stackTrace.length - 1) continue;
            builder.append("\n");
        }
        return builder.toString();
    }

    private boolean isFromAllowedPackage(StackTraceElement element) {
        String className = element.getClassName();
        for (String allowedPackage : ALLOWED_PACKAGES) {
            if (!className.startsWith(allowedPackage)) continue;
            return true;
        }
        return false;
    }

    boolean containsIntercomMethod(Throwable exception) {
        for (Throwable currentException = exception; currentException != null; currentException = currentException.getCause()) {
            for (StackTraceElement element : currentException.getStackTrace()) {
                if (!element.getClassName().startsWith(INTERCOM_SDK_PACKAGE)) continue;
                return true;
            }
        }
        return false;
    }
}

