/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.conversation;

import android.webkit.WebView;
import androidx.annotation.VisibleForTesting;
import java.util.ArrayList;
import java.util.Collection;

public class JavascriptRunner {
    private final WebView webView;
    private final Collection<Runnable> actionsAfterLoad;
    private boolean hasLoaded = false;

    public JavascriptRunner(WebView webView) {
        this(webView, new ArrayList<Runnable>());
    }

    @VisibleForTesting
    JavascriptRunner(WebView webView, Collection<Runnable> actionsAfterLoad) {
        this.webView = webView;
        this.actionsAfterLoad = actionsAfterLoad;
    }

    public synchronized void runPendingScripts() {
        this.hasLoaded = true;
        for (Runnable action : this.actionsAfterLoad) {
            action.run();
        }
        this.clearPendingScripts();
    }

    public synchronized void clearPendingScripts() {
        this.actionsAfterLoad.clear();
    }

    public synchronized void run(final String script) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                JavascriptRunner.this.webView.loadUrl("javascript:" + script);
            }
        };
        if (this.hasLoaded) {
            this.webView.post(runnable);
        } else {
            this.actionsAfterLoad.add(runnable);
        }
    }

    public synchronized void reset() {
        this.hasLoaded = false;
        this.clearPendingScripts();
    }
}

