/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.blocks;

import android.content.Context;
import android.graphics.Color;
import android.text.Spanned;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.TextView;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.blocks.NetworkImage;
import io.intercom.android.sdk.blocks.StyleType;
import io.intercom.android.sdk.blocks.UploadingImageCache;
import io.intercom.android.sdk.blocks.lib.BlockAlignment;
import io.intercom.android.sdk.blocks.lib.interfaces.ImageTextBlock;
import io.intercom.android.sdk.blocks.lib.models.BlockMetadata;
import io.intercom.android.sdk.utilities.FontUtils;

public class ImageText
implements ImageTextBlock {
    private final StyleType style;
    private final UploadingImageCache uploadingImageCache;

    ImageText(StyleType style2, UploadingImageCache uploadingImageCache) {
        this.style = style2;
        this.uploadingImageCache = uploadingImageCache;
    }

    @Override
    public View addImageText(Spanned title, Spanned text, String url, String description, int width, int height, BlockMetadata blockMetadata, ViewGroup parent) {
        LayoutInflater layoutInflater = LayoutInflater.from((Context)parent.getContext());
        LinearLayout rootLayout = (LinearLayout)layoutInflater.inflate(R.layout.intercom_image_text_block, parent, false);
        View view = new NetworkImage(this.style, this.uploadingImageCache, null).addImage(url, "", description, width, height, BlockAlignment.LEFT, blockMetadata, (ViewGroup)rootLayout);
        ((LinearLayout.LayoutParams)view.getLayoutParams()).setMargins(0, 0, 0, 0);
        FrameLayout imageHolder = (FrameLayout)rootLayout.findViewById(R.id.image_holder);
        imageHolder.addView(view);
        TextView titleView = (TextView)rootLayout.findViewById(R.id.title);
        TextView textView = (TextView)rootLayout.findViewById(R.id.text);
        titleView.setText((CharSequence)title);
        textView.setText((CharSequence)text);
        FontUtils.setRobotoMediumTypeface(titleView);
        String textColor = blockMetadata.getAppearance().getTextColor();
        if (!TextUtils.isEmpty((CharSequence)textColor)) {
            int parsedColor = Color.parseColor((String)textColor);
            titleView.setTextColor(parsedColor);
            textView.setTextColor(parsedColor);
        }
        return rootLayout;
    }
}

