/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.api;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.intercom.twig.Twig;
import io.intercom.android.sdk.IntercomError;
import io.intercom.android.sdk.IntercomStatusCallback;
import io.intercom.android.sdk.Provider;
import io.intercom.android.sdk.api.BaseCallback;
import io.intercom.android.sdk.api.CallbackHolder;
import io.intercom.android.sdk.api.DeviceIdentifierHolderKt;
import io.intercom.android.sdk.api.ErrorObject;
import io.intercom.android.sdk.api.ErrorStringExtractorKt;
import io.intercom.android.sdk.api.MessengerApi;
import io.intercom.android.sdk.api.MessengerApiHelper;
import io.intercom.android.sdk.api.RateLimiter;
import io.intercom.android.sdk.api.UserUpdateRequest;
import io.intercom.android.sdk.errorreporting.ErrorReport;
import io.intercom.android.sdk.identity.AppConfig;
import io.intercom.android.sdk.identity.AppIdentity;
import io.intercom.android.sdk.identity.UserIdentity;
import io.intercom.android.sdk.logger.LumberMill;
import io.intercom.android.sdk.m5.data.IntercomDataLayer;
import io.intercom.android.sdk.metrics.MetricObject;
import io.intercom.android.sdk.metrics.ops.OpsMetricObject;
import io.intercom.android.sdk.metrics.ops.OpsMetricTracker;
import io.intercom.android.sdk.models.ComposerSuggestions;
import io.intercom.android.sdk.models.LinkResponse;
import io.intercom.android.sdk.models.OpenMessengerResponse;
import io.intercom.android.sdk.models.OverlayState;
import io.intercom.android.sdk.models.Sheet;
import io.intercom.android.sdk.models.UpdateUserResponse;
import io.intercom.android.sdk.models.carousel.Carousel;
import io.intercom.android.sdk.models.carousel.CarouselResponse;
import io.intercom.android.sdk.state.State;
import io.intercom.android.sdk.store.Selectors;
import io.intercom.android.sdk.store.Store;
import io.intercom.android.sdk.survey.model.FetchSurveyRequest;
import io.intercom.android.sdk.user.DeviceData;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Dispatcher;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.json.JSONObject;

public class Api {
    private static final String USER = "user";
    private static final String DEVICE_TOKEN = "device_token";
    private static final String USER_ATTRIBUTES = "user_attributes";
    private static final String DEVICE_DATA = "device_data";
    private static final String NEW_SESSION = "new_session";
    private static final String HMAC = "hmac";
    private static final String SENT_FROM_BACKGROUND = "sent_from_background";
    private static final String CAROUSEL_VISIBLE = "carousel_visible";
    private static final String INSTANCE_ID = "instance_id";
    private static final String SCREEN_ID = "screen_id";
    private static final String CAROUSEL_CREATED_VIA = "created_via";
    private static final String CAROUSEL_PROGRAMMATIC = "triggered_from_code";
    private static final String CAROUSEL_AUTOMATIC = "shown_automatically";
    private static final Twig TWIG = LumberMill.getLogger();
    final CallbackHolder callbacks;
    private final Context context;
    private final AppIdentity appIdentity;
    private final Provider<AppConfig> appConfigProvider;
    final UserIdentity userIdentity;
    final OkHttpClient httpClient = new OkHttpClient();
    private final MessengerApi messengerApi;
    private final OkHttpClient apiHttpClient;
    private final int defaultOkHttpMaxRequests;
    private final RateLimiter rateLimiter;
    private final Store<State> store;
    private OpsMetricTracker opsMetricTracker;
    private final IntercomDataLayer dataLayer;
    private final retrofit2.Callback<Void> emptyCallback = new retrofit2.Callback<Void>(){

        public void onResponse(retrofit2.Call<Void> call, retrofit2.Response<Void> response) {
        }

        public void onFailure(retrofit2.Call<Void> call, Throwable t) {
        }
    };

    public Api(Context context, AppIdentity appIdentity, UserIdentity userIdentity, OkHttpClient httpClient, MessengerApi messengerApi, CallbackHolder callbacks, RateLimiter rateLimiter, Store<State> store, Provider<AppConfig> appConfigProvider2, OpsMetricTracker opsMetricTracker, IntercomDataLayer dataLayer) {
        this.context = context;
        this.appIdentity = appIdentity;
        this.userIdentity = userIdentity;
        this.messengerApi = messengerApi;
        this.callbacks = callbacks;
        this.rateLimiter = rateLimiter;
        this.store = store;
        this.appConfigProvider = appConfigProvider2;
        this.opsMetricTracker = opsMetricTracker;
        this.dataLayer = dataLayer;
        this.apiHttpClient = httpClient;
        this.defaultOkHttpMaxRequests = httpClient.dispatcher().getMaxRequests();
        this.updateMaxRequests();
    }

    public void updateMaxRequests() {
        int maxRequests = this.userIdentity.hasIntercomId() ? this.defaultOkHttpMaxRequests : 1;
        Dispatcher dispatcher = this.apiHttpClient.dispatcher();
        if (dispatcher.getMaxRequests() != maxRequests) {
            dispatcher.setMaxRequests(maxRequests);
        }
    }

    public void setDeviceToken(String deviceToken) {
        Map<String, Object> deviceData = DeviceData.generateDeviceData(this.context);
        deviceData.put(DEVICE_TOKEN, deviceToken);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(USER, this.userIdentity.toMap());
        params.put(DEVICE_DATA, deviceData);
        this.addSecureHash(params);
        this.messengerApi.setDeviceToken(MessengerApiHelper.INSTANCE.optionsMapToRequestBody(params)).enqueue(this.emptyCallback);
    }

    public void removeDeviceToken(String token, UserIdentity previousIdentity) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (previousIdentity.isSoftReset()) {
            params.put(USER, previousIdentity.softUserIdentityToMap());
        } else {
            params.put(USER, previousIdentity.toMap());
        }
        params.put(DEVICE_TOKEN, token);
        this.addSecureHash(params);
        this.messengerApi.deleteDeviceToken(MessengerApiHelper.INSTANCE.optionsMapToRequestBody(params)).enqueue(this.emptyCallback);
    }

    public void updateUser(UserUpdateRequest userUpdateRequest, IntercomStatusCallback intercomStatusCallback) {
        boolean shouldLimitUpdate;
        boolean bl = shouldLimitUpdate = !userUpdateRequest.isInternalUpdate();
        if (shouldLimitUpdate) {
            if (this.rateLimiter.isLimited()) {
                this.rateLimiter.logError();
                intercomStatusCallback.onFailure(new IntercomError(1005, "rate limit reached"));
                return;
            }
            if (this.shouldStopBackgroundRequest(userUpdateRequest.isSentFromBackground())) {
                this.logBackgroundDisabledError();
                intercomStatusCallback.onFailure(new IntercomError(1006, "Background requests are disabled"));
                return;
            }
            this.rateLimiter.recordRequest();
        }
        this.retriableUpdateUser(this.generateUpdateUserParams(userUpdateRequest), intercomStatusCallback);
    }

    @VisibleForTesting
    void retriableUpdateUser(Map<String, Object> params, IntercomStatusCallback intercomStatusCallback) {
        this.retriableUpdateUser(params, this.userIdentity.getFingerprint(), intercomStatusCallback);
    }

    private void retriableUpdateUser(final Map<String, Object> params, final String fingerprint, final IntercomStatusCallback intercomStatusCallback) {
        this.messengerApi.updateUser(MessengerApiHelper.INSTANCE.optionsMapToRequestBody(params)).enqueue((retrofit2.Callback)new BaseCallback<UpdateUserResponse.Builder>(){

            @Override
            public void onSuccess(UpdateUserResponse.Builder builder) {
                new Handler(Looper.getMainLooper()).post(intercomStatusCallback::onSuccess);
                if (fingerprint.equals(Api.this.userIdentity.getFingerprint())) {
                    TWIG.i("Successfully registered or updated user", new Object[0]);
                    Api.this.callbacks.unreadCallback().onSuccess(builder);
                    UpdateUserResponse response = builder.build();
                    Api.this.dataLayer.updateTeamPresence(response.getTeamPresence());
                    Api.this.dataLayer.updateComposerSuggestions(response.getComposerSuggestions());
                    Api.this.dataLayer.updateCarousel(response.getCarousel());
                    Api.this.dataLayer.updateBotIntro(response.getBotIntro());
                    Api.this.dataLayer.updateSurveyData(response.getSurveyData());
                    Api.this.dataLayer.updateBotBehaviourId(response.getBotBehaviourId());
                    Api.this.opsMetricTracker.trackEvent("finish", "time-to-complete-ping-ms");
                }
            }

            @Override
            public void onError(ErrorObject errorObject) {
                Map user = (Map)params.get(Api.USER);
                if (Api.isUserNotFound(errorObject, user)) {
                    user.remove("intercom_id");
                    params.put(Api.USER, user);
                    Api.this.retriableUpdateUser(params, fingerprint, intercomStatusCallback);
                } else {
                    String error = ErrorStringExtractorKt.extractErrorString(errorObject);
                    new Handler(Looper.getMainLooper()).post(() -> intercomStatusCallback.onFailure(new IntercomError(1001, "ERROR - [HTTP " + errorObject.getStatusCode() + "] - " + error)));
                }
            }

            @Override
            void logFailure(String reason, ErrorObject error) {
                super.logFailure("Failed to register or update user", error);
            }
        });
    }

    public void logEvent(String name, Map<String, ?> metaData) {
        if (this.rateLimiter.isLimited()) {
            this.rateLimiter.logError();
            return;
        }
        boolean appBackgrounded = this.store.select(Selectors.APP_IS_BACKGROUNDED);
        if (this.shouldStopBackgroundRequest(appBackgrounded)) {
            this.logBackgroundDisabledError();
            return;
        }
        this.rateLimiter.recordRequest();
        HashMap<String, Object> eventParams = new HashMap<String, Object>();
        eventParams.put("event_name", name);
        if (!metaData.isEmpty()) {
            eventParams.put("metadata", metaData);
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("event", eventParams);
        params.put(SENT_FROM_BACKGROUND, appBackgrounded);
        params.put(USER, this.userIdentity.toMap());
        params.put(CAROUSEL_VISIBLE, this.isCarouselVisible());
        this.addSecureHash(params);
        this.messengerApi.logEvent(MessengerApiHelper.INSTANCE.optionsMapToRequestBody(params)).enqueue(this.callbacks.logEventCallback());
    }

    public void markConversationAsRead(String conversationId2) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("app_id", this.appIdentity.appId());
        params.put(USER, this.userIdentity.toMap());
        this.addSecureHash(params);
        this.messengerApi.markAsRead(conversationId2, MessengerApiHelper.INSTANCE.optionsMapToRequestBody(params)).enqueue(this.emptyCallback);
    }

    public void markConversationAsDismissed(String conversationId2) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(USER, this.userIdentity.toMap());
        params.put("conversation_ids", new String[]{conversationId2});
        this.addSecureHash(params);
        this.messengerApi.markAsDismissed(MessengerApiHelper.INSTANCE.optionsMapToRequestBody(params)).enqueue(this.emptyCallback);
    }

    public void recordInteractions(String conversationId2, String[] interactions) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(USER, this.userIdentity.toMap());
        params.put("interactions", interactions);
        this.addSecureHash(params);
        this.messengerApi.recordInteractions(conversationId2, MessengerApiHelper.INSTANCE.optionsMapToRequestBody(params)).enqueue(this.emptyCallback);
    }

    public void getUnreadConversations() {
        Map<String, Object> params = this.userIdentity.toMap();
        params.put("per_page", "20");
        this.addSecureHash(params);
        this.messengerApi.getUnreadConversations(MessengerApiHelper.INSTANCE.optionsMapToRequestBody(params)).enqueue(this.callbacks.unreadCallback());
    }

    public void openMessenger() {
        Map<String, Object> params = this.userIdentity.toMap();
        this.addSecureHash(params);
        this.messengerApi.openMessenger(MessengerApiHelper.INSTANCE.optionsMapToRequestBody(params)).enqueue((retrofit2.Callback)new BaseCallback<OpenMessengerResponse>(){

            @Override
            protected void onSuccess(OpenMessengerResponse openMessengerResponse) {
                ComposerSuggestions composerSuggestions = openMessengerResponse.getComposerSuggestions();
                Api.this.dataLayer.updateComposerSuggestions(composerSuggestions);
            }

            @Override
            protected void onError(ErrorObject errorDetails) {
                super.onError(errorDetails);
            }
        });
    }

    public void rateConversation(String conversationId2, int ratingIndex) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(USER, this.userIdentity.toMap());
        params.put("rating_index", ratingIndex);
        this.addSecureHash(params);
        this.messengerApi.rateConversation(conversationId2, MessengerApiHelper.INSTANCE.optionsMapToRequestBody(params)).enqueue(this.callbacks.loggingCallback("conversation rating"));
    }

    public void addConversationRatingRemark(String conversationId2, String remark) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(USER, this.userIdentity.toMap());
        params.put("remark", remark);
        this.addSecureHash(params);
        this.messengerApi.addConversationRatingRemark(conversationId2, MessengerApiHelper.INSTANCE.optionsMapToRequestBody(params)).enqueue(this.callbacks.loggingCallback("adding remark to conversation"));
    }

    public Map<String, Object> createBaseReplyParams() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("app_id", this.appIdentity.appId());
        params.put("type", USER);
        params.put("message_type", "comment");
        params.put(USER, this.userIdentity.toMap());
        this.addSecureHash(params);
        return params;
    }

    public void reactToConversation(String conversationId2, int reactionIndex) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(USER, this.userIdentity.toMap());
        params.put("reaction_index", reactionIndex);
        this.addSecureHash(params);
        this.messengerApi.reactToConversation(conversationId2, MessengerApiHelper.INSTANCE.optionsMapToRequestBody(params)).enqueue(this.callbacks.loggingCallback("add reaction to conversation"));
    }

    public Map<String, Object> baseNewConversationParams() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("app_id", this.appIdentity.appId());
        params.put(USER, this.userIdentity.toMap());
        this.addSecureHash(params);
        return params;
    }

    public void getLink(String linkId, retrofit2.Callback<LinkResponse.Builder> callback) {
        Map<String, Object> params = this.userIdentity.toMap();
        this.addSecureHash(params);
        this.messengerApi.getLink(linkId, MessengerApiHelper.INSTANCE.optionsMapToRequestBody(params)).enqueue(callback);
    }

    public void reactToLink(String linkId, @Nullable String articleContentId, int reactionIndex, boolean allowAutoResponse) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(USER, this.userIdentity.toMap());
        params.put("article_content_id", articleContentId);
        params.put("reaction_index", reactionIndex);
        params.put("allow_auto_responses", allowAutoResponse);
        this.addSecureHash(params);
        this.messengerApi.reactToLink(linkId, MessengerApiHelper.INSTANCE.optionsMapToRequestBody(params)).enqueue(this.callbacks.loggingCallback("add reaction to link"));
    }

    public void sendMetrics(List<MetricObject> metrics, List<OpsMetricObject> opsMetrics, retrofit2.Callback<Void> callback) {
        HashMap<String, List<Object>> params = new HashMap<String, List<Object>>();
        params.put("metrics", metrics);
        params.put("op_metrics", opsMetrics);
        this.messengerApi.sendMetrics(MessengerApiHelper.INSTANCE.optionsMapToRequestBody(params)).enqueue(callback);
    }

    public void sendErrorReport(ErrorReport report) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(USER, this.userIdentity.toMap());
        params.put("error_report", report);
        this.addSecureHash(params);
        this.messengerApi.reportError(MessengerApiHelper.INSTANCE.optionsMapToRequestBody(params)).enqueue(this.callbacks.loggingCallback("report error"));
    }

    public void getVideo(String url, Callback callback) {
        this.httpClient.newCall(new Request.Builder().url(url).build()).enqueue(callback);
    }

    public void hitTrackingUrl(String url) {
        this.httpClient.newCall(new Request.Builder().url(url).build()).enqueue(new Callback(){

            public void onFailure(Call call, IOException e) {
                TWIG.internal("Tracking Url", "Failed tracking url request");
            }

            public void onResponse(Call call, Response response) {
                TWIG.internal("Tracking Url", "success");
                response.body().close();
            }
        });
    }

    public void fetchSheet(HashMap<String, Object> sheetParams, retrofit2.Callback<Sheet.Builder> callback) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(USER, this.userIdentity.toMap());
        this.addSecureHash(params);
        params.putAll(sheetParams);
        this.messengerApi.getSheet(MessengerApiHelper.INSTANCE.optionsMapToRequestBody(params)).enqueue(callback);
    }

    public void submitSheet(String uri, Map<String, Object> sheetValues, retrofit2.Callback<Void> callback) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(USER, this.userIdentity.toMap());
        this.addSecureHash(params);
        params.put("uri", uri);
        params.put("sheet_values", sheetValues);
        this.messengerApi.submitSheet(MessengerApiHelper.INSTANCE.optionsMapToRequestBody(params)).enqueue(callback);
    }

    public void markPushAsOpened(String instanceId) {
        Map<String, Object> params = this.statsSystemParams(instanceId);
        this.messengerApi.markPushAsOpened(MessengerApiHelper.INSTANCE.optionsMapToRequestBody(params)).enqueue(this.emptyCallback);
    }

    public void markCarouselAsDismissed(String instanceId, boolean isProgrammatic) {
        Map<String, Object> params = this.statsSystemParams(instanceId);
        this.addCarouselCreatedViaParam(params, isProgrammatic);
        this.messengerApi.markCarouselAsDismissed(MessengerApiHelper.INSTANCE.optionsMapToRequestBody(params)).enqueue(this.emptyCallback);
    }

    public void markCarouselAsCompleted(String instanceId, boolean isProgrammatic) {
        Map<String, Object> params = this.statsSystemParams(instanceId);
        this.addCarouselCreatedViaParam(params, isProgrammatic);
        this.messengerApi.markCarouselAsCompleted(MessengerApiHelper.INSTANCE.optionsMapToRequestBody(params)).enqueue(this.emptyCallback);
    }

    public void markCarouselScreenViewed(String instanceId, String screenId, boolean isProgrammatic) {
        Map<String, Object> params = this.statsSystemParams(instanceId, screenId);
        this.addCarouselCreatedViaParam(params, isProgrammatic);
        this.messengerApi.markCarouselScreenViewed(MessengerApiHelper.INSTANCE.optionsMapToRequestBody(params)).enqueue(this.emptyCallback);
    }

    public void markPermissionGranted(String instanceId, String screenId, boolean isProgrammatic) {
        Map<String, Object> params = this.statsSystemParams(instanceId, screenId);
        this.addCarouselCreatedViaParam(params, isProgrammatic);
        this.messengerApi.markPermissionGranted(MessengerApiHelper.INSTANCE.optionsMapToRequestBody(params)).enqueue(this.emptyCallback);
    }

    public void markCarouselActionButtonTapped(String instanceId, String screenId, boolean isProgrammatic) {
        Map<String, Object> params = this.statsSystemParams(instanceId, screenId);
        this.addCarouselCreatedViaParam(params, isProgrammatic);
        this.messengerApi.markCarouselActionButtonTapped(MessengerApiHelper.INSTANCE.optionsMapToRequestBody(params)).enqueue(this.emptyCallback);
    }

    public void fetchProgrammaticCarousel(String carouselId) {
        Map<String, Object> params = this.userIdentity.toMap();
        this.addSecureHash(params);
        this.messengerApi.getProgrammaticCarousel(carouselId, MessengerApiHelper.INSTANCE.optionsMapToRequestBody(params)).enqueue(this.callbacks.getCarouselCallback(carouselId));
    }

    public void fetchCarouselByEntityId(String carouselId) {
        Map<String, Object> params = this.userIdentity.toMap();
        params.put("entity_id", carouselId);
        params.put("entity_type", 44);
        this.addSecureHash(params);
        this.messengerApi.getCarousel(MessengerApiHelper.INSTANCE.optionsMapToRequestBody(params)).enqueue((retrofit2.Callback)new BaseCallback<CarouselResponse.Builder>(){

            @Override
            protected void onSuccess(CarouselResponse.Builder response) {
                Api.this.dataLayer.updateCarousel(response.build().carousel().build());
            }
        });
    }

    public void fetchSurveyByEntityId(String surveyId) {
        Map<String, Object> params = this.userIdentity.toMap();
        params.put("entity_id", surveyId);
        params.put("entity_type", 85);
        this.addSecureHash(params);
        this.messengerApi.getSurvey(MessengerApiHelper.INSTANCE.optionsMapToRequestBody(params)).enqueue((retrofit2.Callback)new BaseCallback<FetchSurveyRequest>(){

            @Override
            protected void onSuccess(FetchSurveyRequest response) {
                Api.this.dataLayer.updateSurveyData(response.getSurvey());
            }
        });
    }

    protected static boolean isUserNotFound(ErrorObject error, Map userParams) {
        if (error.hasErrorBody() && error.getStatusCode() == 404 && userParams != null && userParams.get("intercom_id") != null && userParams.size() > 1) {
            try {
                JSONObject errorObject = new JSONObject(error.getErrorBody());
                if (errorObject.getJSONArray("errors").getJSONObject(0).getString("code").equals("not_found")) {
                    return true;
                }
            }
            catch (Exception ignored) {
                TWIG.internal("Could not parse error response");
            }
        }
        return false;
    }

    public void addSecureHash(Map<String, Object> params) {
        params.put("device_identifier", DeviceIdentifierHolderKt.getDeviceIdentifier(this.context));
        String hmac = this.userIdentity.getHmac();
        if (!TextUtils.isEmpty((CharSequence)hmac)) {
            params.put(HMAC, hmac);
        }
    }

    private Map<String, Object> generateUpdateUserParams(UserUpdateRequest userUpdateRequest) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(USER, this.userIdentity.toMap());
        params.put(DEVICE_DATA, DeviceData.generateDeviceData(this.context));
        params.put(NEW_SESSION, userUpdateRequest.isNewSession());
        params.put(SENT_FROM_BACKGROUND, userUpdateRequest.isSentFromBackground());
        params.put(USER_ATTRIBUTES, userUpdateRequest.getAttributes());
        params.put(CAROUSEL_VISIBLE, this.isCarouselVisible());
        this.addSecureHash(params);
        return params;
    }

    private void addCarouselCreatedViaParam(Map<String, Object> params, boolean isProgrammatic) {
        params.put(CAROUSEL_CREATED_VIA, isProgrammatic ? CAROUSEL_PROGRAMMATIC : CAROUSEL_AUTOMATIC);
    }

    private boolean isCarouselVisible() {
        Carousel carousel = ((OverlayState)this.dataLayer.getOverlayState().getValue()).getCarousel();
        return !Carousel.NULL.equals(carousel);
    }

    private Map<String, Object> statsSystemParams(String instanceId, String screenId) {
        Map<String, Object> params = this.statsSystemParams(instanceId);
        params.put(SCREEN_ID, screenId);
        return params;
    }

    private Map<String, Object> statsSystemParams(String instanceId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(INSTANCE_ID, instanceId);
        params.put(USER, this.userIdentity.toMap());
        this.addSecureHash(params);
        return params;
    }

    private boolean shouldStopBackgroundRequest(boolean background) {
        return background && this.appConfigProvider.get().isBackgroundRequestsDisabled();
    }

    private void logBackgroundDisabledError() {
        TWIG.e("Your request was not sent because the app is in the background. Please contact Intercom to enable background requests.", new Object[0]);
    }

    @VisibleForTesting
    boolean isSynchronous() {
        return this.apiHttpClient.dispatcher().getMaxRequests() == 1;
    }

    @VisibleForTesting
    public void setIdleCallback(Runnable idleCallback) {
        this.apiHttpClient.dispatcher().setIdleCallback(idleCallback);
    }

    @VisibleForTesting
    public boolean isIdle() {
        return this.apiHttpClient.dispatcher().runningCallsCount() == 0;
    }
}

