/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.utilities.connectivity;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.IntentFilter;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import io.intercom.android.sdk.utilities.connectivity.ConnectivityBroadcastReceiver;
import io.intercom.android.sdk.utilities.connectivity.NetworkState;

public class NetworkConnectivityMonitor
implements ConnectivityBroadcastReceiver.ConnectivityUpdateListener {
    private final ConnectivityBroadcastReceiver receiver;
    @Nullable
    private ConnectivityEventListener listener;
    private NetworkState lastState = NetworkState.UNKNOWN;
    private boolean didRegister = false;

    public NetworkConnectivityMonitor() {
        this.receiver = new ConnectivityBroadcastReceiver(this);
    }

    @Override
    public void onUpdate(NetworkState newState) {
        if (newState == this.lastState) {
            return;
        }
        if (this.listener != null) {
            if (newState == NetworkState.NOT_CONNECTED) {
                this.listener.onDisconnect();
            } else if (newState == NetworkState.CONNECTED && this.lastState == NetworkState.NOT_CONNECTED) {
                this.listener.onReconnect();
            }
        }
        this.lastState = newState;
    }

    public synchronized void startListening(Context context) {
        if (!this.didRegister) {
            context.registerReceiver((BroadcastReceiver)this.receiver, new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE"));
            this.didRegister = true;
        }
    }

    public synchronized void stopListening(Context context) {
        if (this.didRegister) {
            context.unregisterReceiver((BroadcastReceiver)this.receiver);
            this.didRegister = false;
        }
    }

    public void setListener(@Nullable ConnectivityEventListener listener2) {
        this.listener = listener2;
    }

    @VisibleForTesting
    @Nullable
    ConnectivityEventListener getListener() {
        return this.listener;
    }

    public static interface ConnectivityEventListener {
        public void onDisconnect();

        public void onReconnect();
    }
}

