/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.models.carousel;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.Nullable;
import com.google.auto.value.AutoValue;
import io.intercom.android.sdk.carousel.PermissionManager;
import io.intercom.android.sdk.models.carousel.AutoValue_ScreenAction;
import io.intercom.android.sdk.utilities.NullSafety;
import io.intercom.android.sdk.utilities.commons.CollectionUtils;
import java.util.ArrayList;
import java.util.List;

@AutoValue
public abstract class ScreenAction
implements Parcelable {
    public static ScreenAction NULL = new Builder().build();
    private static final String PERMISSION_TYPE_SUFFIX = "permission";
    public static final Parcelable.Creator<ScreenAction> CREATOR = new Parcelable.Creator<ScreenAction>(){

        public ScreenAction createFromParcel(Parcel in) {
            ArrayList<String> permissions = new ArrayList<String>();
            in.readList(permissions, String.class.getClassLoader());
            return ScreenAction.create(in.readString(), in.readString(), in.readString(), in.readString(), in.readString(), in.readString(), permissions);
        }

        public ScreenAction[] newArray(int size) {
            return new ScreenAction[size];
        }
    };

    public static ScreenAction create(String id2, String type, String title, String textColor, String backgroundColor, String uri, List<String> permissions) {
        return new AutoValue_ScreenAction(id2, type, title, textColor, backgroundColor, uri, permissions);
    }

    public abstract String getId();

    public abstract String getType();

    public abstract String getTitle();

    public abstract String getTextColor();

    public abstract String getBackgroundColor();

    public abstract String getUri();

    public abstract List<String> getAndroidPermissions();

    public boolean isPermissionAction() {
        return this.getType().contains(PERMISSION_TYPE_SUFFIX);
    }

    public List<String> getValidPermissions(PermissionManager permissionManager) {
        return permissionManager.permissionsExistInManifest(this.getAndroidPermissions());
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeList(this.getAndroidPermissions());
        dest.writeString(this.getId());
        dest.writeString(this.getType());
        dest.writeString(this.getTitle());
        dest.writeString(this.getTextColor());
        dest.writeString(this.getBackgroundColor());
        dest.writeString(this.getUri());
    }

    public static final class Builder {
        @Nullable
        String id;
        @Nullable
        String type;
        @Nullable
        String title;
        @Nullable
        String text_color;
        @Nullable
        String background_color;
        @Nullable
        String uri;
        @Nullable
        List<String> android_permissions;

        public Builder withId(String id2) {
            this.id = id2;
            return this;
        }

        public Builder withType(String type) {
            this.type = type;
            return this;
        }

        public Builder withTitle(String title) {
            this.title = title;
            return this;
        }

        public Builder withTextColor(String textColor) {
            this.text_color = textColor;
            return this;
        }

        public Builder withBackgroundColor(String backgroundColor) {
            this.background_color = backgroundColor;
            return this;
        }

        public Builder withUri(String uri) {
            this.uri = uri;
            return this;
        }

        public Builder withPermissions(List<String> permissions) {
            this.android_permissions = permissions;
            return this;
        }

        public ScreenAction build() {
            ArrayList<String> permissions = new ArrayList<String>(CollectionUtils.capacityFor(this.android_permissions));
            if (this.android_permissions != null) {
                for (String permission2 : this.android_permissions) {
                    if (permission2 == null) continue;
                    permissions.add(permission2);
                }
            }
            return ScreenAction.create(NullSafety.valueOrEmpty(this.id), NullSafety.valueOrEmpty(this.type), NullSafety.valueOrEmpty(this.title), NullSafety.valueOrEmpty(this.text_color), NullSafety.valueOrEmpty(this.background_color), NullSafety.valueOrEmpty(this.uri), permissions);
        }
    }
}

