/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.m5.push;

import android.content.Context;
import android.os.Bundle;
import com.intercom.twig.Twig;
import io.intercom.android.sdk.Provider;
import io.intercom.android.sdk.api.Api;
import io.intercom.android.sdk.identity.AppConfig;
import io.intercom.android.sdk.identity.UserIdentity;
import io.intercom.android.sdk.logger.LumberMill;
import io.intercom.android.sdk.m5.push.IntercomNotificationHandler;
import io.intercom.android.sdk.m5.push.IntercomPushData;
import io.intercom.android.sdk.user.DeviceData;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u000e\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\tJ4\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\f\u001a\u00020\r2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00110\u001aJ\u0016\u0010\u001b\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u0016R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lio/intercom/android/sdk/m5/push/IntercomPushClientHandler;", "", "()V", "twig", "Lcom/intercom/twig/Twig;", "kotlin.jvm.PlatformType", "handlePush", "", "message", "Landroid/os/Bundle;", "localisedContext", "Landroid/content/Context;", "userIdentity", "Lio/intercom/android/sdk/identity/UserIdentity;", "hasUserHashIfNeeded", "", "appConfig", "Lio/intercom/android/sdk/identity/AppConfig;", "isIntercomPush", "sendTokenToIntercom", "context", "token", "", "api", "Lio/intercom/android/sdk/api/Api;", "appConfigProvider", "Lio/intercom/android/sdk/Provider;", "shouldSendDeviceToken", "intercom-sdk-base_release"})
public final class IntercomPushClientHandler {
    private final Twig twig = LumberMill.getLogger();

    public final boolean shouldSendDeviceToken(@NotNull Context context, @NotNull String token) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        return !DeviceData.hasCachedDeviceToken(context, token);
    }

    public final void sendTokenToIntercom(@NotNull Context context, @NotNull String token, @NotNull Api api, @NotNull UserIdentity userIdentity, @NotNull Provider<AppConfig> appConfigProvider2) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        Intrinsics.checkNotNullParameter((Object)api, (String)"api");
        Intrinsics.checkNotNullParameter((Object)userIdentity, (String)"userIdentity");
        Intrinsics.checkNotNullParameter(appConfigProvider2, (String)"appConfigProvider");
        if (userIdentity.identityExists()) {
            AppConfig appConfig = appConfigProvider2.get();
            Intrinsics.checkNotNullExpressionValue((Object)appConfig, (String)"appConfigProvider.get()");
            if (this.hasUserHashIfNeeded(userIdentity, appConfig)) {
                api.setDeviceToken(token);
            }
        }
        DeviceData.cacheDeviceToken(context, token);
    }

    public final void handlePush(@NotNull Bundle message, @NotNull Context localisedContext, @NotNull UserIdentity userIdentity) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)localisedContext, (String)"localisedContext");
        Intrinsics.checkNotNullParameter((Object)userIdentity, (String)"userIdentity");
        IntercomPushData intercomPushData = IntercomPushData.Companion.createFrom(localisedContext, message);
        if (intercomPushData == null) {
            this.twig.i("This is not a Intercom push message", new Object[0]);
            return;
        }
        if (!userIdentity.identityExists()) {
            this.twig.i("Can't create push message as we have no user identity. This can be caused by messages being sent to a logged out user.", new Object[0]);
            IntercomNotificationHandler.INSTANCE.clear(localisedContext);
            return;
        }
        IntercomNotificationHandler.processIntercomPushNotification$intercom_sdk_base_release$default(IntercomNotificationHandler.INSTANCE, localisedContext, intercomPushData, null, 4, null);
    }

    public final boolean isIntercomPush(@NotNull Bundle message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        return IntercomPushData.Companion.isIntercomPush(message);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean hasUserHashIfNeeded(UserIdentity userIdentity, AppConfig appConfig) {
        if (!appConfig.isReceivedFromServer()) return false;
        if (!appConfig.isIdentityVerificationEnabled()) return true;
        if (!appConfig.isIdentityVerificationEnabled()) return false;
        String string2 = userIdentity.getHmac();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"userIdentity.hmac");
        if (StringsKt.isBlank((CharSequence)string2)) return false;
        return true;
    }
}

