/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.activities;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.TimeInterpolator;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.res.Resources;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.LayerDrawable;
import android.graphics.drawable.ScaleDrawable;
import android.net.Uri;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AccelerateInterpolator;
import android.view.inputmethod.InputMethodManager;
import android.webkit.ValueCallback;
import android.webkit.WebChromeClient;
import android.webkit.WebView;
import android.widget.FrameLayout;
import android.widget.ProgressBar;
import androidx.activity.result.ActivityResultLauncher;
import androidx.activity.result.contract.ActivityResultContract;
import androidx.activity.result.contract.ActivityResultContracts;
import androidx.annotation.ColorInt;
import androidx.appcompat.app.AlertDialog;
import androidx.core.content.ContextCompat;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.LifecycleOwnerKt;
import io.intercom.android.sdk.Injector;
import io.intercom.android.sdk.Provider;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.activities.IntercomBaseActivity;
import io.intercom.android.sdk.api.Api;
import io.intercom.android.sdk.conversation.JavascriptRunner;
import io.intercom.android.sdk.identity.AppConfig;
import io.intercom.android.sdk.imageloader.WallpaperLoader;
import io.intercom.android.sdk.m5.data.IntercomEvent;
import io.intercom.android.sdk.metrics.MetricTracker;
import io.intercom.android.sdk.models.Sheet;
import io.intercom.android.sdk.sheets.SheetListener;
import io.intercom.android.sdk.sheets.SheetWebViewPresenter;
import io.intercom.android.sdk.utilities.ColorUtils;
import io.intercom.android.sdk.views.IntercomErrorView;
import io.intercom.android.sdk.views.IntercomToolbar;
import java.util.HashMap;
import java.util.Map;
import kotlinx.coroutines.CoroutineScope;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

public class IntercomSheetActivity
extends IntercomBaseActivity
implements IntercomToolbar.Listener,
SheetListener {
    private static final String PARCEL_SHEET_URL = "parcel_sheet_url";
    private static final String PARCEL_PARAMS = "parcel_params";
    private static final String PARCEL_CARD_URI = "parcel_card_uri";
    private static final String PARCEL_CONVERSATION_ID = "parcel_conversation_id";
    private static final String PARCEL_IS_HOME_SCREEN = "parcel_is_home_screen";
    private static final int WEBVIEW_FADE_IN_TIME_MS = 300;
    private static final int ENTRANCE_ANIMATION_TIME_MS = 250;
    private static final int EXIT_ANIMATION_TIME_MS = 200;
    private IntercomErrorView intercomErrorView;
    ProgressBar loadingBar;
    WebView webView;
    private SheetWebViewPresenter presenter;
    private IntercomToolbar intercomToolbar;
    private View containerView;
    private JavascriptRunner jsRunner;
    private MetricTracker metricTracker;
    private WallpaperLoader wallpaperLoader;
    private String cardUri;
    private String sheetUrl = "";
    private String conversationId = "";
    private HashMap params = new HashMap();
    private boolean isHomeScreen;
    private Provider<AppConfig> appConfigProvider;
    private ActivityResultLauncher<Intent> pickFile;
    public ValueCallback<Uri[]> valueCallback;
    @ColorInt
    private int secondaryColor;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Injector injector2 = Injector.get();
        this.metricTracker = injector2.getMetricTracker();
        this.appConfigProvider = injector2.getAppConfigProvider();
        this.secondaryColor = this.appConfigProvider.get().getSecondaryColor();
        Bundle data = this.getIntent().getExtras();
        if (data != null) {
            this.sheetUrl = data.getString(PARCEL_SHEET_URL, "");
            this.conversationId = data.getString(PARCEL_CONVERSATION_ID, "");
            this.params = (HashMap)data.getSerializable(PARCEL_PARAMS);
            this.cardUri = data.getString(PARCEL_CARD_URI);
            this.isHomeScreen = data.getBoolean(PARCEL_IS_HOME_SCREEN, false);
        }
        this.setContentView(R.layout.intercom_activity_sheet);
        this.setUpToolbar(this.appConfigProvider);
        this.containerView = this.findViewById(R.id.sheet_root);
        if (TextUtils.isEmpty((CharSequence)this.sheetUrl) || this.params == null) {
            this.closeSheet();
        }
        this.containerView.setVisibility(8);
        this.containerView.post(new Runnable(){

            @Override
            public void run() {
                IntercomSheetActivity.this.animateWindowIn();
            }
        });
        this.insertWebView();
        this.jsRunner = new JavascriptRunner(this.webView);
        this.presenter = new SheetWebViewPresenter(this.webView, this.jsRunner, this.sheetUrl, this, injector2);
        this.presenter.setUpWebView();
        this.intercomErrorView = (IntercomErrorView)this.containerView.findViewById(R.id.error_layout_sheet);
        this.intercomErrorView.setActionButtonTextColor(ColorUtils.primaryOrDarkColor((Context)this, this.appConfigProvider.get()));
        this.intercomErrorView.setActionButtonClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                IntercomSheetActivity.this.loadSheet(Injector.get().getApi());
            }
        });
        this.pickFile = this.registerForActivityResult((ActivityResultContract)new ActivityResultContracts.StartActivityForResult(), result2 -> {
            if (result2.getResultCode() == -1 && result2.getData() != null) {
                this.valueCallback.onReceiveValue((Object)new Uri[]{result2.getData().getData()});
            } else {
                this.valueCallback.onReceiveValue(null);
            }
        });
        this.loadSheet(injector2.getApi());
    }

    private void setUpToolbar(Provider<AppConfig> appConfigProvider2) {
        AppConfig appConfig = appConfigProvider2.get();
        this.intercomToolbar = (IntercomToolbar)this.findViewById(R.id.intercom_toolbar);
        this.intercomToolbar.updateToolbarColors(appConfig);
        this.intercomToolbar.setListener(this);
        this.intercomToolbar.setSubtitleVisibility(8);
        this.intercomToolbar.setBackgroundColor(this.secondaryColor);
        this.intercomToolbar.setLeftNavigationItemVisibility(0);
        this.intercomToolbar.setCloseButtonVisibility(8);
        this.intercomToolbar.setLeftNavigationIcon(ContextCompat.getDrawable((Context)this, (int)R.drawable.intercom_close));
        this.intercomToolbar.updateToolbarSize();
        this.wallpaperLoader = WallpaperLoader.create((Context)this, appConfigProvider2);
        this.intercomToolbar.loadWallpaper(this.wallpaperLoader);
        this.loadingBar = (ProgressBar)this.intercomToolbar.findViewById(R.id.toolbar_progress_bar);
        this.loadingBar.setProgressDrawable((Drawable)new LayerDrawable(new Drawable[]{new ColorDrawable(appConfig.getSecondaryColorDark()), new ScaleDrawable((Drawable)new ColorDrawable(-1), 0x800003, 1.0f, -1.0f)}));
    }

    private void loadSheet(Api api) {
        this.loadingBar.setVisibility(0);
        this.intercomErrorView.setVisibility(8);
        api.fetchSheet(this.params, new Callback<Sheet.Builder>(){

            public void onResponse(Call<Sheet.Builder> call, Response<Sheet.Builder> response) {
                if (response.isSuccessful() && response.body() != null) {
                    IntercomSheetActivity.this.intercomErrorView.setVisibility(8);
                    Sheet sheet = ((Sheet.Builder)response.body()).build();
                    IntercomSheetActivity.this.presenter.loadBundle(sheet.getBody());
                    IntercomSheetActivity.this.metricTracker.viewedMessengerSheet(IntercomSheetActivity.this.conversationId, IntercomSheetActivity.this.sheetUrl, IntercomSheetActivity.this.isHomeScreen);
                } else {
                    IntercomSheetActivity.this.showErrorView();
                }
            }

            public void onFailure(Call<Sheet.Builder> call, Throwable t) {
                IntercomSheetActivity.this.showErrorView();
            }
        });
    }

    private void insertWebView() {
        try {
            this.webView = new WebView((Context)this);
        }
        catch (Resources.NotFoundException e) {
            this.webView = new WebView(this.getApplicationContext());
        }
        this.webView.setAlpha(0.0f);
        this.webView.setId(R.id.intercom_sheet_webview);
        this.webView.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        FrameLayout sheetView = (FrameLayout)this.findViewById(R.id.sheet_view);
        sheetView.addView((View)this.webView, 0);
        this.webView.setWebChromeClient(new WebChromeClient(){

            public void onProgressChanged(WebView view, int progress) {
                IntercomSheetActivity.this.loadingBar.setProgress(progress);
            }

            public boolean onShowFileChooser(WebView webView, ValueCallback<Uri[]> filePathCallback, WebChromeClient.FileChooserParams fileChooserParams) {
                IntercomSheetActivity.this.valueCallback = filePathCallback;
                IntercomSheetActivity.this.pickFile.launch((Object)fileChooserParams.createIntent());
                return true;
            }
        });
    }

    private void showErrorView() {
        this.loadingBar.setVisibility(8);
        this.intercomErrorView.setVisibility(0);
    }

    void closeSheet() {
        this.metricTracker.closedMessengerSheet(this.conversationId, this.sheetUrl, this.isHomeScreen);
        this.hideKeyboard();
        this.animateWindowOut();
    }

    @Override
    protected void onDestroy() {
        this.intercomToolbar.closeWallpaperLoader(this.wallpaperLoader);
        super.onDestroy();
    }

    public void onBackPressed() {
        if (this.webView.canGoBack()) {
            this.webView.goBack();
        } else {
            this.closeSheet();
        }
    }

    public static Intent buildIntent(Context context, String sheetUrl, Map<String, Object> params, String card_uri, String conversationId) {
        Intent intent = new Intent(context, IntercomSheetActivity.class);
        intent.putExtra(PARCEL_SHEET_URL, sheetUrl);
        intent.putExtra(PARCEL_PARAMS, new HashMap<String, Object>(params));
        intent.putExtra(PARCEL_CARD_URI, card_uri);
        intent.putExtra(PARCEL_CONVERSATION_ID, conversationId);
        return intent;
    }

    private void hideKeyboard() {
        View focusedView = this.getCurrentFocus();
        if (focusedView != null) {
            InputMethodManager inputManager = (InputMethodManager)this.getSystemService("input_method");
            inputManager.hideSoftInputFromWindow(focusedView.getWindowToken(), 0);
        }
    }

    private void animateWindowIn() {
        this.containerView.setVisibility(0);
        this.containerView.setY((float)this.findViewById(0x1020002).getMeasuredHeight());
        this.containerView.animate().y(0.0f).setInterpolator((TimeInterpolator)new AccelerateInterpolator()).setDuration(250L).start();
    }

    private void animateWindowOut() {
        this.containerView.animate().y((float)this.getWindow().getDecorView().getHeight()).setDuration(200L).setListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                IntercomSheetActivity.this.finish();
                IntercomSheetActivity.this.overridePendingTransition(0, 0);
            }
        }).start();
    }

    @Override
    public void onCloseClicked() {
    }

    @Override
    public void onToolbarClicked() {
    }

    @Override
    public void onInboxClicked() {
        this.closeSheet();
    }

    @Override
    public void onWebViewFinishedLoad() {
        this.jsRunner.runPendingScripts();
        this.webView.animate().alpha(1.0f).setDuration(300L).start();
        this.loadingBar.setVisibility(8);
    }

    @Override
    public void onSheetTitleAction(String title) {
        this.intercomToolbar.setTitle(title);
    }

    @Override
    public void onCloseSheetAction() {
        this.closeSheet();
    }

    @Override
    public void onSubmitSheetAction(final Map<String, Object> payload) {
        Injector.get().getApi().submitSheet(this.cardUri, payload, new Callback<Void>(){

            public void onResponse(Call<Void> call, Response<Void> response) {
                if (response.isSuccessful()) {
                    IntercomSheetActivity.this.cardUpdated();
                    IntercomSheetActivity.this.closeSheet();
                } else {
                    IntercomSheetActivity.this.showSubmitActionError(payload);
                }
            }

            public void onFailure(Call<Void> call, Throwable t) {
                IntercomSheetActivity.this.showSubmitActionError(payload);
            }
        });
    }

    private void cardUpdated() {
        Injector.get().getDataLayer().emitEvent((CoroutineScope)LifecycleOwnerKt.getLifecycleScope((LifecycleOwner)this), IntercomEvent.CardUpdated.INSTANCE);
    }

    private void showSubmitActionError(final Map<String, Object> payload) {
        AlertDialog dialog = new AlertDialog.Builder((Context)this).setTitle(R.string.intercom_couldnt_load_content).setMessage(R.string.intercom_give_it_another_try).setPositiveButton(R.string.intercom_reload, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                IntercomSheetActivity.this.onSubmitSheetAction(payload);
            }
        }).create();
        dialog.show();
        dialog.getButton(-1).setTextColor(ColorUtils.primaryOrDarkColor((Context)this, this.appConfigProvider.get()));
    }
}

