/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.overlay;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.compose.ui.platform.ComposeView;
import io.intercom.android.sdk.Provider;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.identity.AppConfig;
import io.intercom.android.sdk.m5.notification.InAppNotificationCardKt;
import io.intercom.android.sdk.models.Conversation;
import io.intercom.android.sdk.models.Part;
import io.intercom.android.sdk.models.Space;
import io.intercom.android.sdk.models.Ticket;
import io.intercom.android.sdk.overlay.ChatNotification;
import io.intercom.android.sdk.overlay.ComposeCompatibilityUtilKt;
import io.intercom.android.sdk.overlay.InAppNotification;
import io.intercom.android.sdk.tickets.list.reducers.TicketHeaderReducerKt;
import io.intercom.android.sdk.utilities.AvatarUtils;

class ChatSnippet
extends ChatNotification {
    private TextView contentBody;

    public ChatSnippet(Context localisedContext, Conversation conversation, int position, int screenHeight, InAppNotification.Listener listener2, Provider<AppConfig> appConfigProvider2) {
        super(localisedContext, conversation, position, screenHeight, listener2, appConfigProvider2);
    }

    @Override
    protected ViewGroup inflateChatRootView(ViewGroup parent, LayoutInflater inflater) {
        ViewGroup root = (ViewGroup)inflater.inflate(R.layout.intercom_preview_chat_snippet_overlay, parent, false);
        this.contentBody = (TextView)root.findViewById(R.id.chathead_text_body);
        return root;
    }

    @Override
    protected void updateContentContainer(Part part) {
        this.setBodyText(part);
    }

    @Override
    protected View getContentContainer() {
        return this.overlayRoot.findViewById(R.id.chathead_text_body);
    }

    @Override
    public void update(Conversation conversation, Runnable updateEndAction) {
        this.conversation = conversation;
        View text = this.overlayRoot.findViewById(R.id.chathead_text_body);
        View textContainer = this.overlayRoot.findViewById(R.id.chathead_text_container);
        textContainer.setPivotX(0.0f);
        this.performReplyPulse(textContainer, text, updateEndAction);
    }

    @Override
    protected void updateViewDataDuringReplyPulse(int bottomPadding) {
        ImageView avatarView = (ImageView)this.overlayRoot.findViewById(R.id.chathead_avatar);
        AvatarUtils.loadAvatarIntoView(this.conversation.getLastAdmin().getAvatar(), avatarView, (AppConfig)this.appConfigProvider.get());
        TextView headerTextView = (TextView)this.overlayRoot.findViewById(R.id.chathead_text_header);
        headerTextView.setText(this.getHeaderText());
        Part lastPart = this.conversation.getLastPart();
        this.setBodyText(lastPart);
        ComposeView ticketHeader = (ComposeView)this.overlayRoot.findViewById(R.id.ticket_header_compose_view);
        if (ComposeCompatibilityUtilKt.isLegacyActivity(ticketHeader)) {
            return;
        }
        InAppNotificationCardKt.addTicketHeaderToCompose(ticketHeader, this.conversation, TicketHeaderReducerKt.reduceTicketHeaderType(((AppConfig)this.appConfigProvider.get()).isSpaceEnabled(Space.Type.TICKETS)));
        if (this.conversation.getTicket() != Ticket.Companion.getNULL()) {
            headerTextView.setVisibility(8);
            ticketHeader.setVisibility(0);
        } else {
            headerTextView.setVisibility(0);
            ticketHeader.setVisibility(8);
        }
    }

    private void setBodyText(Part part) {
        if (part.getSummary().isEmpty()) {
            this.contentBody.setText((CharSequence)this.localisedContext.getString(R.string.intercom_image_attached));
        } else {
            this.contentBody.setText((CharSequence)part.getSummary());
        }
    }
}

