/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.utilities;

import android.animation.Animator;
import android.animation.ArgbEvaluator;
import android.animation.TypeEvaluator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.graphics.drawable.RippleDrawable;
import android.view.View;
import android.widget.TextView;
import androidx.annotation.ColorInt;
import androidx.annotation.IdRes;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.utilities.ColorUtils;

public class BackgroundUtils {
    public static void setBackground(View background, Drawable drawable2) {
        background.setBackground(drawable2);
    }

    public static void animateBackground(int colorFrom, int colorTo, int duration, View view, Animator.AnimatorListener animationListener) {
        ValueAnimator colorAnimation = ValueAnimator.ofObject((TypeEvaluator)new ArgbEvaluator(), (Object[])new Object[]{colorFrom, colorTo});
        colorAnimation.setDuration((long)duration);
        colorAnimation.addUpdateListener(animator -> view.setBackgroundColor(((Integer)animator.getAnimatedValue()).intValue()));
        if (animationListener != null) {
            colorAnimation.addListener(animationListener);
        }
        colorAnimation.start();
    }

    public static void setRippleButtonStroke(Context context, Drawable buttonBackground, @IdRes int layerId, @ColorInt int strokeColor) {
        RippleDrawable rippleDrawable = (RippleDrawable)buttonBackground;
        GradientDrawable background = (GradientDrawable)rippleDrawable.findDrawableByLayerId(layerId);
        BackgroundUtils.updateStroke(background, context, strokeColor);
    }

    public static void setRippleButtonBackgroundColor(Drawable buttonBackground, @IdRes int layerId, @ColorInt int color2) {
        RippleDrawable rippleDrawable = (RippleDrawable)buttonBackground;
        GradientDrawable background = (GradientDrawable)rippleDrawable.findDrawableByLayerId(layerId);
        background.setColor(color2);
    }

    private static void updateStroke(GradientDrawable background, Context context, @ColorInt int color2) {
        int strokeSize = context.getResources().getDimensionPixelSize(R.dimen.intercom_home_button_stroke_size);
        background.setStroke(strokeSize, color2);
    }

    public static void setButtonColor(TextView button, @ColorInt int primaryColor) {
        int buttonTextColor = ColorUtils.buttonTextColorVariant(primaryColor);
        int buttonBackgroundColor = ColorUtils.buttonBackgroundColorVariant(primaryColor);
        button.setTextColor(buttonTextColor);
        button.getBackground().setColorFilter(buttonBackgroundColor, PorterDuff.Mode.SRC_ATOP);
    }
}

