/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.middleware;

import io.intercom.android.sdk.IntercomStatusCallbackKt;
import io.intercom.android.sdk.Provider;
import io.intercom.android.sdk.actions.Action;
import io.intercom.android.sdk.api.UserUpdateRequest;
import io.intercom.android.sdk.api.UserUpdater;
import io.intercom.android.sdk.identity.AppConfig;
import io.intercom.android.sdk.identity.UserIdentity;
import io.intercom.android.sdk.m5.data.IntercomDataLayer;
import io.intercom.android.sdk.models.HostAppState;
import io.intercom.android.sdk.state.State;
import io.intercom.android.sdk.store.Store;

public class UserUpdaterMiddleware
implements Store.Middleware<State> {
    private final Provider<AppConfig> appConfigProvider;
    private final Provider<UserUpdater> userUpdater;
    private final Provider<UserIdentity> userIdentityProvider;
    private final IntercomDataLayer dataLayer;

    public UserUpdaterMiddleware(Provider<UserUpdater> userUpdater, Provider<AppConfig> appConfigProvider, Provider<UserIdentity> userIdentityProvider, IntercomDataLayer dataLayer) {
        this.appConfigProvider = appConfigProvider;
        this.userUpdater = userUpdater;
        this.userIdentityProvider = userIdentityProvider;
        this.dataLayer = dataLayer;
    }

    @Override
    public void dispatch(Store<State> store, Action<?> action, Store.NextDispatcher next) {
        next.dispatch(action);
        switch (action.type()) {
            case APP_ENTERED_FOREGROUND: {
                long currentTime = (Long)action.value();
                long timeSinceBackgrounded = currentTime - ((HostAppState)this.dataLayer.getHostAppState().getValue()).getBackgroundedTimestamp();
                if (timeSinceBackgrounded <= this.appConfigProvider.get().getNewSessionThresholdMs() || !this.userIdentityProvider.get().identityExists() || ((HostAppState)this.dataLayer.getHostAppState().getValue()).getSessionStartedSinceLastBackgrounded()) break;
                Boolean isBackgrounded = ((HostAppState)this.dataLayer.getHostAppState().getValue()).isBackgrounded();
                UserUpdateRequest userUpdateRequest = UserUpdateRequest.create(true, isBackgrounded, true);
                this.userUpdater.get().updateUser(userUpdateRequest, IntercomStatusCallbackKt.getNoStatusCallback());
                break;
            }
        }
    }
}

