/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.api;

import com.intercom.twig.Twig;
import io.intercom.android.sdk.actions.Actions;
import io.intercom.android.sdk.api.BaseCallback;
import io.intercom.android.sdk.identity.UserIdentity;
import io.intercom.android.sdk.logger.LumberMill;
import io.intercom.android.sdk.m5.data.IntercomDataLayer;
import io.intercom.android.sdk.models.LogEventResponse;
import io.intercom.android.sdk.models.UsersResponse;
import io.intercom.android.sdk.state.State;
import io.intercom.android.sdk.store.Store;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

class CallbackHolder {
    final Store<State> store;
    final IntercomDataLayer dataLayer;
    private static final Twig TWIG = LumberMill.getLogger();
    private final UserIdentity userIdentity;

    CallbackHolder(Store<State> store, IntercomDataLayer dataLayer, UserIdentity userIdentity) {
        this.store = store;
        this.dataLayer = dataLayer;
        this.userIdentity = userIdentity;
    }

    BaseCallback<LogEventResponse.Builder> logEventCallback() {
        return new BaseCallback<LogEventResponse.Builder>(){

            @Override
            public void onSuccess(LogEventResponse.Builder builder) {
                LogEventResponse response = builder.build();
                CallbackHolder.this.store.dispatch(Actions.baseResponseReceived(response));
                CallbackHolder.this.store.dispatch(Actions.unreadConversationsSuccess(response));
                CallbackHolder.this.userIdentity.update(response.getUser());
                CallbackHolder.this.dataLayer.updateConfig(response.getConfig());
                CallbackHolder.this.dataLayer.updateCarousel(response.getCarousel());
                CallbackHolder.this.dataLayer.updateUnreadConversations(response.getUnreadConversations().getConversations());
            }
        };
    }

    BaseCallback<UsersResponse.Builder> unreadCallback() {
        return new BaseCallback<UsersResponse.Builder>(){

            @Override
            public void onSuccess(UsersResponse.Builder builder) {
                UsersResponse response = builder.build();
                CallbackHolder.this.store.dispatch(Actions.baseResponseReceived(response));
                CallbackHolder.this.store.dispatch(Actions.unreadConversationsSuccess(response));
                CallbackHolder.this.userIdentity.update(response.getUser());
                CallbackHolder.this.dataLayer.updateConfig(response.getConfig());
                CallbackHolder.this.dataLayer.updateUnreadConversations(response.getUnreadConversations().getConversations());
            }
        };
    }

    Callback<Void> loggingCallback(final String action) {
        return new Callback<Void>(){

            public void onResponse(Call<Void> call, Response<Void> response) {
                TWIG.internal(action + " success");
            }

            public void onFailure(Call<Void> call, Throwable throwable) {
                TWIG.internal(action + " failure");
            }
        };
    }
}

