/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.views;

import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import androidx.annotation.ColorInt;
import androidx.annotation.Nullable;

public class AvatarInitialsDrawable
extends Drawable {
    private final Rect textBounds = new Rect();
    private final Paint avatarBackground;
    private final Paint textPaint;
    private final String text;

    public AvatarInitialsDrawable(String text, @ColorInt int colour) {
        this.text = text;
        this.avatarBackground = new Paint();
        this.avatarBackground.setAntiAlias(true);
        this.avatarBackground.setColor(colour);
        this.avatarBackground.setStyle(Paint.Style.FILL);
        this.textPaint = new Paint();
        this.textPaint.setAntiAlias(true);
        this.textPaint.setColor(-1);
        this.textPaint.setFakeBoldText(true);
        this.textPaint.setTextAlign(Paint.Align.LEFT);
    }

    public void draw(Canvas canvas) {
        Rect bounds = this.getBounds();
        this.textPaint.setTextSize((float)(bounds.height() / 3));
        this.textPaint.getTextBounds(this.text, 0, this.text.length(), this.textBounds);
        canvas.drawCircle((float)bounds.centerX(), (float)bounds.centerY(), (float)(bounds.height() / 2), this.avatarBackground);
        canvas.drawText(this.text, (float)bounds.centerX() - this.textBounds.exactCenterX(), (float)bounds.centerY() - this.textBounds.exactCenterY(), this.textPaint);
    }

    public void setAlpha(int alpha) {
        this.textPaint.setAlpha(alpha);
        this.avatarBackground.setAlpha(alpha);
    }

    public void setColorFilter(@Nullable ColorFilter colorFilter) {
    }

    public int getOpacity() {
        return -3;
    }
}

