/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.m5.conversation.data;

import androidx.compose.runtime.internal.StabilityInferred;
import com.google.gson.Gson;
import io.intercom.android.nexus.NexusClient;
import io.intercom.android.sdk.Injector;
import io.intercom.android.sdk.api.Api;
import io.intercom.android.sdk.api.MessengerApi;
import io.intercom.android.sdk.api.MessengerApiHelper;
import io.intercom.android.sdk.blocks.lib.models.Block;
import io.intercom.android.sdk.helpcenter.utils.networking.NetworkResponse;
import io.intercom.android.sdk.identity.UserIdentity;
import io.intercom.android.sdk.m5.conversation.data.ConversationRepository;
import io.intercom.android.sdk.m5.conversation.data.GetConversationReason;
import io.intercom.android.sdk.m5.conversation.data.NexusEventAsFlowKt;
import io.intercom.android.sdk.m5.conversation.data.NexusEventsRepository;
import io.intercom.android.sdk.m5.conversation.data.ParsedNexusEvent;
import io.intercom.android.sdk.m5.conversation.ui.components.composer.MediaData;
import io.intercom.android.sdk.m5.upload.data.UploadRepository;
import io.intercom.android.sdk.models.ComposerSuggestions;
import io.intercom.android.sdk.models.Conversation;
import io.intercom.android.sdk.models.ConversationResponse;
import io.intercom.android.sdk.models.GifResponse;
import io.intercom.android.sdk.models.Part;
import io.intercom.android.sdk.models.Upload;
import io.intercom.android.sdk.utilities.TimeFormatterExtKt;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.flow.Flow;
import okhttp3.RequestBody;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00a8\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B?\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ4\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001f2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\"2\u0006\u0010$\u001a\u00020\"2\u0006\u0010%\u001a\u00020\"H\u0096@\u00a2\u0006\u0002\u0010&J&\u0010'\u001a\b\u0012\u0004\u0012\u00020(0\u001f2\u0006\u0010)\u001a\u00020\"2\b\u0010*\u001a\u0004\u0018\u00010\"H\u0096@\u00a2\u0006\u0002\u0010+Jl\u0010,\u001a\b\u0012\u0004\u0012\u00020-0\u001f2\f\u0010.\u001a\b\u0012\u0004\u0012\u0002000/2\b\u00101\u001a\u0004\u0018\u00010\"2\b\u00102\u001a\u0004\u0018\u00010\"2\b\u00103\u001a\u0004\u0018\u00010\"2\u000e\u00104\u001a\n\u0012\u0004\u0012\u000205\u0018\u00010/2\u0006\u00106\u001a\u0002072\b\u00108\u001a\u0004\u0018\u0001092\b\u0010*\u001a\u0004\u0018\u00010\"H\u0096@\u00a2\u0006\u0002\u0010:J$\u0010;\u001a\b\u0012\u0004\u0012\u00020(0\u001f2\u0006\u0010#\u001a\u00020\"2\u0006\u0010<\u001a\u00020=H\u0096@\u00a2\u0006\u0002\u0010>J\u001c\u0010?\u001a\b\u0012\u0004\u0012\u00020@0\u001f2\u0006\u0010A\u001a\u00020\"H\u0096@\u00a2\u0006\u0002\u0010BJ\u0016\u0010C\u001a\u00020D2\u0006\u0010#\u001a\u00020\"H\u0096@\u00a2\u0006\u0002\u0010BJ\b\u0010\u0016\u001a\u00020\u0017H\u0016J\u000e\u0010E\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0016JD\u0010F\u001a\b\u0012\u0004\u0012\u00020 0\u001f2\u0006\u0010#\u001a\u00020\"2\u0006\u0010%\u001a\u00020\"2\f\u0010.\u001a\b\u0012\u0004\u0012\u0002000/2\b\u0010G\u001a\u0004\u0018\u0001092\u0006\u00106\u001a\u000207H\u0096@\u00a2\u0006\u0002\u0010HJ<\u0010I\u001a\b\u0012\u0004\u0012\u00020(0\u001f2\u0006\u0010#\u001a\u00020\"2\u0006\u0010J\u001a\u00020\"2\u0006\u0010K\u001a\u00020\"2\u0006\u0010L\u001a\u00020\"2\u0006\u0010M\u001a\u00020\"H\u0096@\u00a2\u0006\u0002\u0010NJ\u001c\u0010O\u001a\b\u0012\u0004\u0012\u00020P0\u001f2\u0006\u0010Q\u001a\u00020RH\u0096@\u00a2\u0006\u0002\u0010SR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0016\u001a\u00020\u00178BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001a\u0010\u001b\u001a\u0004\b\u0018\u0010\u0019R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001d\u00a8\u0006T"}, d2={"Lio/intercom/android/sdk/m5/conversation/data/LegacyConversationRepository;", "Lio/intercom/android/sdk/m5/conversation/data/ConversationRepository;", "messengerApi", "Lio/intercom/android/sdk/api/MessengerApi;", "uploadRepository", "Lio/intercom/android/sdk/m5/upload/data/UploadRepository;", "api", "Lio/intercom/android/sdk/api/Api;", "userIdentity", "Lio/intercom/android/sdk/identity/UserIdentity;", "nexusClient", "Lio/intercom/android/nexus/NexusClient;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "(Lio/intercom/android/sdk/api/MessengerApi;Lio/intercom/android/sdk/m5/upload/data/UploadRepository;Lio/intercom/android/sdk/api/Api;Lio/intercom/android/sdk/identity/UserIdentity;Lio/intercom/android/nexus/NexusClient;Lkotlinx/coroutines/CoroutineScope;)V", "getApi", "()Lio/intercom/android/sdk/api/Api;", "getMessengerApi", "()Lio/intercom/android/sdk/api/MessengerApi;", "nexusEventFlow", "Lkotlinx/coroutines/flow/Flow;", "Lio/intercom/android/sdk/m5/conversation/data/ParsedNexusEvent;", "nexusEventsRepository", "Lio/intercom/android/sdk/m5/conversation/data/NexusEventsRepository;", "getNexusEventsRepository", "()Lio/intercom/android/sdk/m5/conversation/data/NexusEventsRepository;", "nexusEventsRepository$delegate", "Lkotlin/Lazy;", "getUserIdentity", "()Lio/intercom/android/sdk/identity/UserIdentity;", "addQuickReplyToConversation", "Lio/intercom/android/sdk/helpcenter/utils/networking/NetworkResponse;", "Lio/intercom/android/sdk/models/Part$Builder;", "quickReplyId", "", "conversationId", "quickReplyPartId", "clientUUID", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "createConversationFromSuggestion", "Lio/intercom/android/sdk/models/Conversation;", "suggestionId", "openRequestId", "(Ljava/lang/String;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "createNewConversation", "Lio/intercom/android/sdk/models/ConversationResponse$Builder;", "blocks", "", "Lio/intercom/android/sdk/blocks/lib/models/Block$Builder;", "botIntroId", "articleId", "botBehaviourId", "suggestions", "Lio/intercom/android/sdk/models/ComposerSuggestions$Suggestion;", "fromVoiceDictation", "", "snapshotId", "", "(Ljava/util/List;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/util/List;ZLjava/lang/Long;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getConversation", "reason", "Lio/intercom/android/sdk/m5/conversation/data/GetConversationReason;", "(Ljava/lang/String;Lio/intercom/android/sdk/m5/conversation/data/GetConversationReason;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "loadGifs", "Lio/intercom/android/sdk/models/GifResponse;", "searchQuery", "(Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "markAsRead", "", "realTimeEvents", "replyToConversation", "lastAdminPartCreatedAt", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/List;Ljava/lang/Long;ZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "submitForm", "partId", "identifier", "formValue", "formType", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "uploadMedia", "Lio/intercom/android/sdk/models/Upload$Builder;", "imageData", "Lio/intercom/android/sdk/m5/conversation/ui/components/composer/MediaData$Media;", "(Lio/intercom/android/sdk/m5/conversation/ui/components/composer/MediaData$Media;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intercom-sdk-base_release"})
@StabilityInferred(parameters=0)
public final class LegacyConversationRepository
implements ConversationRepository {
    @NotNull
    private final MessengerApi messengerApi;
    @NotNull
    private final UploadRepository uploadRepository;
    @NotNull
    private final Api api;
    @NotNull
    private final UserIdentity userIdentity;
    @NotNull
    private final Lazy nexusEventsRepository$delegate;
    @NotNull
    private final Flow<ParsedNexusEvent> nexusEventFlow;
    public static final int $stable = 8;

    public LegacyConversationRepository(@NotNull MessengerApi messengerApi, @NotNull UploadRepository uploadRepository, @NotNull Api api, @NotNull UserIdentity userIdentity, @NotNull NexusClient nexusClient, @NotNull CoroutineScope scope) {
        Intrinsics.checkNotNullParameter((Object)messengerApi, (String)"messengerApi");
        Intrinsics.checkNotNullParameter((Object)uploadRepository, (String)"uploadRepository");
        Intrinsics.checkNotNullParameter((Object)api, (String)"api");
        Intrinsics.checkNotNullParameter((Object)userIdentity, (String)"userIdentity");
        Intrinsics.checkNotNullParameter((Object)nexusClient, (String)"nexusClient");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        this.messengerApi = messengerApi;
        this.uploadRepository = uploadRepository;
        this.api = api;
        this.userIdentity = userIdentity;
        this.nexusEventsRepository$delegate = LazyKt.lazy((Function0)((Function0)new Function0<NexusEventsRepository>(nexusClient, this, scope){
            final /* synthetic */ NexusClient $nexusClient;
            final /* synthetic */ LegacyConversationRepository this$0;
            final /* synthetic */ CoroutineScope $scope;
            {
                this.$nexusClient = $nexusClient;
                this.this$0 = $receiver;
                this.$scope = $scope;
                super(0);
            }

            @NotNull
            public final NexusEventsRepository invoke() {
                return new NexusEventsRepository(this.$nexusClient, this.this$0.getUserIdentity(), this.$scope);
            }
        }));
        this.nexusEventFlow = NexusEventAsFlowKt.nexusEventAsFlow(nexusClient);
    }

    public /* synthetic */ LegacyConversationRepository(MessengerApi messengerApi, UploadRepository uploadRepository, Api api, UserIdentity userIdentity, NexusClient nexusClient, CoroutineScope coroutineScope, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            MessengerApi messengerApi2 = Injector.get().getMessengerApi();
            Intrinsics.checkNotNullExpressionValue((Object)messengerApi2, (String)"getMessengerApi(...)");
            messengerApi = messengerApi2;
        }
        if ((n & 2) != 0) {
            uploadRepository = new UploadRepository(null, null, null, null, 15, null);
        }
        if ((n & 4) != 0) {
            Api api2 = Injector.get().getApi();
            Intrinsics.checkNotNullExpressionValue((Object)api2, (String)"getApi(...)");
            api = api2;
        }
        if ((n & 8) != 0) {
            UserIdentity userIdentity2 = Injector.get().getUserIdentity();
            Intrinsics.checkNotNullExpressionValue((Object)userIdentity2, (String)"getUserIdentity(...)");
            userIdentity = userIdentity2;
        }
        if ((n & 0x10) != 0) {
            NexusClient nexusClient2 = Injector.get().getNexusClient();
            Intrinsics.checkNotNullExpressionValue((Object)nexusClient2, (String)"getNexusClient(...)");
            nexusClient = nexusClient2;
        }
        this(messengerApi, uploadRepository, api, userIdentity, nexusClient, coroutineScope);
    }

    @NotNull
    public final MessengerApi getMessengerApi() {
        return this.messengerApi;
    }

    @NotNull
    public final Api getApi() {
        return this.api;
    }

    @NotNull
    public final UserIdentity getUserIdentity() {
        return this.userIdentity;
    }

    private final NexusEventsRepository getNexusEventsRepository() {
        Lazy lazy = this.nexusEventsRepository$delegate;
        return (NexusEventsRepository)lazy.getValue();
    }

    @Override
    @NotNull
    public Flow<ParsedNexusEvent> realTimeEvents() {
        return this.nexusEventFlow;
    }

    @Override
    @Nullable
    public Object replyToConversation(@NotNull String conversationId2, @NotNull String clientUUID, @NotNull List<Block.Builder> blocks, @Nullable Long lastAdminPartCreatedAt, boolean fromVoiceDictation, @NotNull Continuation<? super NetworkResponse<Part.Builder>> $completion) {
        Map<String, Object> map2;
        Map<String, Object> $this$replyToConversation_u24lambda_u241 = map2 = this.api.createBaseReplyParams();
        boolean bl = false;
        $this$replyToConversation_u24lambda_u241.put("blocks", blocks);
        $this$replyToConversation_u24lambda_u241.put("client_assigned_uuid", clientUUID);
        $this$replyToConversation_u24lambda_u241.put("from_voice_dictation", Boxing.boxBoolean((boolean)fromVoiceDictation));
        Long l = lastAdminPartCreatedAt;
        if (l != null) {
            long it = ((Number)l).longValue();
            boolean bl2 = false;
            $this$replyToConversation_u24lambda_u241.put("last_admin_part_created_at", TimeFormatterExtKt.toISOFormat(lastAdminPartCreatedAt));
        }
        Map<String, Object> params = map2;
        Intrinsics.checkNotNull(params);
        RequestBody requestBody = MessengerApiHelper.INSTANCE.getDefaultRequestBody$intercom_sdk_base_release(params);
        return this.messengerApi.replyToConversationSuspend(conversationId2, requestBody, $completion);
    }

    @Override
    @Nullable
    public Object createNewConversation(@NotNull List<Block.Builder> blocks, @Nullable String botIntroId, @Nullable String articleId, @Nullable String botBehaviourId, @Nullable List<ComposerSuggestions.Suggestion> suggestions, boolean fromVoiceDictation, @Nullable Long snapshotId, @Nullable String openRequestId, @NotNull Continuation<? super NetworkResponse<ConversationResponse.Builder>> $completion) {
        Map<String, Object> map2;
        Map<String, Object> $this$createNewConversation_u24lambda_u242 = map2 = this.api.baseNewConversationParams();
        boolean bl = false;
        $this$createNewConversation_u24lambda_u242.put("blocks", blocks);
        $this$createNewConversation_u24lambda_u242.put("from_voice_dictation", Boxing.boxBoolean((boolean)fromVoiceDictation));
        if (botIntroId != null) {
            $this$createNewConversation_u24lambda_u242.put("bot_intro", botIntroId);
        }
        if (articleId != null) {
            $this$createNewConversation_u24lambda_u242.put("article_id", articleId);
        }
        if (botBehaviourId != null) {
            $this$createNewConversation_u24lambda_u242.put("resolution_bot_behavior_version_id", botBehaviourId);
        }
        if (suggestions != null) {
            $this$createNewConversation_u24lambda_u242.put("composer_suggestions", new Gson().toJson(suggestions));
        }
        if (snapshotId != null) {
            $this$createNewConversation_u24lambda_u242.put("snapshot_id", snapshotId);
        }
        if (openRequestId != null) {
            $this$createNewConversation_u24lambda_u242.put("messenger_open_request_id", openRequestId);
        }
        Map<String, Object> params = map2;
        Intrinsics.checkNotNull(params);
        RequestBody requestBody = MessengerApiHelper.INSTANCE.getDefaultRequestBody$intercom_sdk_base_release(params);
        return this.messengerApi.startNewConversationSuspend(requestBody, $completion);
    }

    @Override
    @Nullable
    public Object getConversation(@NotNull String conversationId2, @NotNull GetConversationReason reason, @NotNull Continuation<? super NetworkResponse<Conversation>> $completion) {
        String string2;
        switch (WhenMappings.$EnumSwitchMapping$0[reason.ordinal()]) {
            case 1: {
                string2 = "Nexus New Comment";
                break;
            }
            case 2: {
                string2 = "Nexus Reconnected";
                break;
            }
            case 3: {
                string2 = "Internet Reconnected";
                break;
            }
            case 4: {
                string2 = "Click Conversation";
                break;
            }
            case 5: {
                string2 = "State Sync";
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        String reasonString = string2;
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"request_origin", (Object)reasonString)};
        Map params = MapsKt.mutableMapOf((Pair[])pairArray);
        if (reason == GetConversationReason.POLLING) {
            params.put("sync", "true");
        }
        RequestBody requestBody = MessengerApiHelper.INSTANCE.getDefaultRequestBody$intercom_sdk_base_release(params);
        return this.messengerApi.getConversationSuspend(conversationId2, requestBody, $completion);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public Object createConversationFromSuggestion(@NotNull String suggestionId, @Nullable String openRequestId, @NotNull Continuation<? super NetworkResponse<Conversation>> $completion) {
        void $this$createConversationFromSuggestion_u24lambda_u243;
        Map map2;
        Map map3 = map2 = MapsKt.createMapBuilder();
        MessengerApiHelper messengerApiHelper = MessengerApiHelper.INSTANCE;
        boolean bl = false;
        $this$createConversationFromSuggestion_u24lambda_u243.put("id", suggestionId);
        if (openRequestId != null) {
            $this$createConversationFromSuggestion_u24lambda_u243.put("messenger_open_request_id", openRequestId);
        }
        RequestBody requestBody = messengerApiHelper.getDefaultRequestBody$intercom_sdk_base_release(MapsKt.build((Map)map2));
        return this.messengerApi.triggerInboundConversationSuspend(requestBody, $completion);
    }

    @Override
    @Nullable
    public Object addQuickReplyToConversation(@NotNull String quickReplyId, @NotNull String conversationId2, @NotNull String quickReplyPartId, @NotNull String clientUUID, @NotNull Continuation<? super NetworkResponse<Part.Builder>> $completion) {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"reply_option_uuid", (Object)quickReplyId), TuplesKt.to((Object)"client_assigned_uuid", (Object)clientUUID)};
        Map params = MapsKt.mutableMapOf((Pair[])pairArray);
        if (((CharSequence)quickReplyPartId).length() > 0) {
            params.put("quick_reply_part_id", quickReplyPartId);
        }
        RequestBody requestBody = MessengerApiHelper.INSTANCE.getDefaultRequestBody$intercom_sdk_base_release(params);
        return this.messengerApi.addConversationQuickReplySuspend(conversationId2, requestBody, $completion);
    }

    @Override
    @Nullable
    public Object markAsRead(@NotNull String conversationId2, @NotNull Continuation<? super Unit> $completion) {
        RequestBody requestBody = MessengerApiHelper.INSTANCE.getDefaultRequestBody$intercom_sdk_base_release(MapsKt.mapOf((Pair)TuplesKt.to((Object)"app_id", (Object)Injector.get().getAppIdentity().appId())));
        Object object = this.messengerApi.markAsReadSuspend(conversationId2, requestBody, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Override
    @Nullable
    public Object loadGifs(@NotNull String searchQuery, @NotNull Continuation<? super NetworkResponse<? extends GifResponse>> $completion) {
        Map map2 = !StringsKt.isBlank((CharSequence)searchQuery) ? MapsKt.mapOf((Pair)TuplesKt.to((Object)"query", (Object)searchQuery)) : MapsKt.emptyMap();
        RequestBody requestBody = MessengerApiHelper.INSTANCE.getDefaultRequestBody$intercom_sdk_base_release(map2);
        return this.messengerApi.getGifsSuspended(requestBody, $completion);
    }

    @Override
    @Nullable
    public Object uploadMedia(@NotNull MediaData.Media imageData, @NotNull Continuation<? super NetworkResponse<Upload.Builder>> $completion) {
        return this.uploadRepository.uploadFile(imageData, $completion);
    }

    @Override
    @Nullable
    public Object submitForm(@NotNull String conversationId2, @NotNull String partId, @NotNull String identifier, @NotNull String formValue, @NotNull String formType, @NotNull Continuation<? super NetworkResponse<Conversation>> $completion) {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"conversation_part_id", (Object)partId), TuplesKt.to((Object)"identifier", (Object)identifier), TuplesKt.to((Object)"value", (Object)formValue), TuplesKt.to((Object)"type", (Object)formType)};
        Map params = MapsKt.mapOf((Pair[])pairArray);
        RequestBody requestBody = MessengerApiHelper.INSTANCE.getDefaultRequestBody$intercom_sdk_base_release(MapsKt.mapOf((Pair)TuplesKt.to((Object)"form_params", (Object)params)));
        return this.messengerApi.submitFormSuspend(conversationId2, requestBody, $completion);
    }

    @Override
    @NotNull
    public NexusEventsRepository nexusEventsRepository() {
        return this.getNexusEventsRepository();
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[GetConversationReason.values().length];
            try {
                nArray[GetConversationReason.NEW_COMMENT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GetConversationReason.NEXUS_CONNECTED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GetConversationReason.NETWORK_CONNECTED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GetConversationReason.OPEN_CONVERSATION.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GetConversationReason.POLLING.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

