/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.activities;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.annotation.ColorRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.StringRes;
import androidx.annotation.VisibleForTesting;
import androidx.appcompat.app.AlertDialog;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.core.content.ContextCompat;
import androidx.viewpager.widget.PagerAdapter;
import androidx.viewpager.widget.ViewPager;
import com.facebook.shimmer.ShimmerFrameLayout;
import com.intercom.twig.Twig;
import io.intercom.android.sdk.Injector;
import io.intercom.android.sdk.Provider;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.activities.IntercomBaseActivity;
import io.intercom.android.sdk.carousel.CarouselListener;
import io.intercom.android.sdk.carousel.CarouselPresenter;
import io.intercom.android.sdk.carousel.CarouselScreenFragment;
import io.intercom.android.sdk.carousel.CarouselScreenPagerAdapter;
import io.intercom.android.sdk.carousel.CarouselView;
import io.intercom.android.sdk.carousel.PermissionManager;
import io.intercom.android.sdk.carousel.permission.PermissionRequest;
import io.intercom.android.sdk.carousel.permission.PermissionRequestFactory;
import io.intercom.android.sdk.carousel.permission.PermissionResultListener;
import io.intercom.android.sdk.identity.AppConfig;
import io.intercom.android.sdk.logger.LumberMill;
import io.intercom.android.sdk.m5.ConversationScreenOpenerKt;
import io.intercom.android.sdk.m5.IntercomRootActivity;
import io.intercom.android.sdk.metrics.MetricTracker;
import io.intercom.android.sdk.models.carousel.Carousel;
import io.intercom.android.sdk.models.carousel.CarouselScreen;
import io.intercom.android.sdk.models.carousel.ScreenAction;
import io.intercom.android.sdk.utilities.BackgroundUtils;
import io.intercom.android.sdk.utilities.BlockUtils;
import io.intercom.android.sdk.utilities.ColorUtils;
import io.intercom.android.sdk.utilities.FontUtils;
import io.intercom.android.sdk.utilities.LinkOpener;
import io.intercom.android.sdk.utilities.commons.ScreenUtils;
import io.intercom.android.sdk.views.IntercomShimmerLayout;
import java.util.ArrayList;
import java.util.List;

public class IntercomCarouselActivity
extends IntercomBaseActivity
implements ViewPager.OnPageChangeListener,
View.OnClickListener,
CarouselListener,
PermissionResultListener,
CarouselView {
    private static final int PERMISSION_REQUEST_CODE = 12306;
    private static final String PARCEL_CAROUSEL_ID = "parcel_carousel_id";
    @VisibleForTesting
    ViewPager viewPager;
    private View closeBackground;
    private ImageButton closeButton;
    private ConstraintLayout closeButtonContainer;
    @VisibleForTesting
    LinearLayout navigationDotsLayout;
    private FrameLayout stateContainer;
    private final Twig twig = LumberMill.getLogger();
    @VisibleForTesting
    CarouselScreenPagerAdapter adapter;
    @VisibleForTesting
    CarouselPresenter carouselPresenter;
    @VisibleForTesting
    PermissionManager permissionManager;
    @VisibleForTesting
    MetricTracker metricTracker;
    @VisibleForTesting
    Provider<AppConfig> appConfigProvider;
    @VisibleForTesting
    PermissionRequest permissionRequest;
    @VisibleForTesting
    boolean isLastScreenViewed = false;
    @VisibleForTesting
    int numberOfScreensSeen = 0;
    @VisibleForTesting
    ScreenAction currentPermissionAction = ScreenAction.NULL;
    @VisibleForTesting
    boolean sentToSettings = false;
    @VisibleForTesting
    String currentScreenId = "";

    public static Intent buildIntent(Context context, String carouselId) {
        Intent intent = new Intent(context, IntercomCarouselActivity.class);
        intent.putExtra(PARCEL_CAROUSEL_ID, carouselId);
        intent.setFlags(0x10000000);
        return intent;
    }

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.intercom_activity_carousel);
        this.viewPager = (ViewPager)this.findViewById(R.id.intercom_view_pager);
        this.closeBackground = this.findViewById(R.id.intercom_close_background);
        this.closeButton = (ImageButton)this.findViewById(R.id.intercom_close);
        this.closeButtonContainer = (ConstraintLayout)this.findViewById(R.id.intercom_carousel_close_container);
        this.navigationDotsLayout = (LinearLayout)this.findViewById(R.id.intercom_page_navigation_layout);
        this.stateContainer = (FrameLayout)this.findViewById(R.id.intercom_state_container);
        this.stateContainer.setVisibility(8);
        this.closeButton.setOnClickListener((View.OnClickListener)this);
        this.closeButtonContainer.setOnClickListener((View.OnClickListener)this);
        Injector injector2 = Injector.get();
        this.appConfigProvider = injector2.getAppConfigProvider();
        this.permissionManager = new PermissionManager((Activity)this);
        this.permissionRequest = PermissionRequestFactory.create(this.permissionManager);
        this.permissionRequest.attach(this);
        this.metricTracker = injector2.getMetricTracker();
        this.carouselPresenter = new CarouselPresenter(injector2.getStore(), injector2.getApi(), injector2.getUserIdentity(), this.metricTracker, this.permissionManager, injector2.getDataLayer());
        this.carouselPresenter.attachView(this);
        this.carouselPresenter.fetchCarousel(this.getIntent().getStringExtra(PARCEL_CAROUSEL_ID));
    }

    @Override
    protected void onDestroy() {
        this.permissionRequest.detach();
        super.onDestroy();
    }

    public void onBackPressed() {
        super.onBackPressed();
        if (this.carouselPresenter.getCarousel().isDismissible()) {
            this.dismissCarousel("from_android_back_button");
        }
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        if (requestCode == 12306) {
            this.carouselPresenter.recordPermissionRequestedMetric(this.currentPermissionAction.getType(), grantResults, this.currentScreenId);
            this.permissionRequest.handleResult(permissions, grantResults);
        }
    }

    protected void onResume() {
        super.onResume();
        if (this.sentToSettings) {
            this.sentToSettings = false;
            this.carouselPresenter.recordSentToPermissionSettingsMetric(this.currentPermissionAction, this.currentScreenId);
        }
    }

    public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
    }

    public void onPageSelected(int position) {
        List<CarouselScreen> screens = this.carouselPresenter.getCarousel().getScreens();
        int numberOfScreens = screens.size();
        if (numberOfScreens > position) {
            CarouselScreen selectedScreen = screens.get(position);
            this.currentPermissionAction = selectedScreen.getPermissionAction();
            this.currentScreenId = selectedScreen.getId();
            boolean isColorLight = ColorUtils.isColorLight(selectedScreen.getBackgroundColor());
            this.renderNavigationDots(this.adapter.getCount(), isColorLight, position);
            this.updateCloseButtonColor(isColorLight);
            if (position >= this.numberOfScreensSeen) {
                this.carouselPresenter.recordScreenSeenStats(selectedScreen.getId());
                this.numberOfScreensSeen = position + 1;
            }
            if (position + 1 == numberOfScreens) {
                this.isLastScreenViewed = true;
            }
        }
    }

    public void onPageScrollStateChanged(int state) {
    }

    public void onClick(View view) {
        this.dismissCarousel("from_close_button");
    }

    @Override
    public void dismissCarousel(String context) {
        if (!Carousel.NULL.equals(this.carouselPresenter.getCarousel())) {
            this.carouselPresenter.recordDismissedOrCompletedStats(this.isLastScreenViewed);
            this.carouselPresenter.recordDismissedOrCompletedMetric(context, this.isLastScreenViewed, this.numberOfScreensSeen);
        }
        this.closeCarouselAndResetPersistedData();
    }

    @Override
    public void selectNextScreen(String dismissContext) {
        int nextItemPosition = this.viewPager.getCurrentItem() + 1;
        if (nextItemPosition < this.adapter.getCount()) {
            this.viewPager.setCurrentItem(nextItemPosition);
        } else {
            this.dismissCarousel(dismissContext);
        }
    }

    @Override
    public void requestPermissions(ScreenAction screenAction) {
        this.permissionRequest.request(screenAction, 12306);
    }

    @Override
    public void openLink(String link) {
        this.dismissCarousel("from_cta");
        LinkOpener.handleUrl(link, (Context)this, Injector.get().getApi());
    }

    @Override
    public void startChat() {
        this.dismissCarousel("from_cta");
        if (this.appConfigProvider.get().isInboundMessages()) {
            this.startActivity(ConversationScreenOpenerKt.getComposerIntent((Context)this, "", false, null, null, IntercomRootActivity.class));
        }
    }

    @Override
    public void skipPermissionScreen() {
        this.metricTracker.skippedPermission(this.currentPermissionAction.getType(), this.carouselPresenter.getCarousel().getInstanceId(), this.carouselPresenter.getCarouselSource());
        this.selectNextScreen("from_permission_skipped");
    }

    @Override
    public void trackActionButtonTappedStats() {
        this.carouselPresenter.recordActionButtonTappedStats(this.currentScreenId);
    }

    @Override
    public void showGranted() {
        this.selectNextScreenWithDelay();
    }

    @Override
    public void showDeniedTemporarily() {
        this.selectNextScreen("from_permission");
    }

    @Override
    public void showDeniedPermanently() {
        this.showGoToSettingsDialog();
    }

    @Override
    @RequiresApi(api=30)
    public void requestBackgroundLocationPermission() {
        this.showRationaleDialog(R.string.intercom_access_background_location_title, R.string.intercom_access_background_location_message, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                IntercomCarouselActivity.this.permissionManager.requestPermissions(new String[]{"android.permission.ACCESS_BACKGROUND_LOCATION"}, 12306);
            }
        });
    }

    @Override
    public void showSuccess(Carousel carousel) {
        this.stateContainer.setVisibility(8);
        List<CarouselScreen> carouselScreens = carousel.getScreens();
        if (carouselScreens.isEmpty()) {
            this.closeCarouselAndResetPersistedData();
        } else {
            this.carouselPresenter.recordOpenMetric();
        }
        this.closeButtonContainer.setVisibility(carousel.isDismissible() ? 0 : 8);
        this.showOrHideNavigationDots(carouselScreens);
        this.setupViewPagerWithScreens(carouselScreens);
    }

    @Override
    public void showLoading() {
        this.showState(this.buildLoadingState());
    }

    @Override
    public void showNotFoundError() {
        this.showState(this.buildErrorMessage(R.string.intercom_page_not_found));
    }

    @Override
    public void showGenericError() {
        this.showState(this.buildErrorMessage(R.string.intercom_something_went_wrong_try_again));
        this.stateContainer.addView(this.buildRetryButton());
    }

    @Override
    public void logEmptyCarouselError() {
        this.twig.e("Could not open carousel without id", new Object[0]);
    }

    @Override
    public void logUserNotRegisteredError() {
        this.twig.e("The app config has not been retrieved, please call registerUnidentifiedUser() or registerIdentifiedUser(Registration) before calling displayCarousel(carouselId).", new Object[0]);
    }

    private void showState(View state) {
        this.setCloseButtonColor(R.color.intercom_carousel_grey);
        this.stateContainer.removeAllViews();
        this.stateContainer.addView(state);
        this.stateContainer.setVisibility(0);
    }

    private void setupViewPagerWithScreens(List<CarouselScreen> screens) {
        ArrayList<CarouselScreenFragment> fragments = new ArrayList<CarouselScreenFragment>(screens.size());
        for (CarouselScreen screen : screens) {
            fragments.add(CarouselScreenFragment.newInstance(screen));
        }
        this.adapter = new CarouselScreenPagerAdapter(this.getSupportFragmentManager(), fragments);
        this.viewPager.setAdapter((PagerAdapter)this.adapter);
        this.viewPager.addOnPageChangeListener((ViewPager.OnPageChangeListener)this);
        this.onPageSelected(0);
    }

    @VisibleForTesting
    void showOrHideNavigationDots(List<CarouselScreen> screens) {
        this.navigationDotsLayout.setVisibility(screens.size() > 1 ? 0 : 8);
    }

    @VisibleForTesting
    void renderNavigationDots(int screenCount, boolean isColorLight, int selectedPosition) {
        this.navigationDotsLayout.removeAllViews();
        int resource = isColorLight ? R.drawable.intercom_tab_dot_selector_dark : R.drawable.intercom_tab_dot_selector_light;
        for (int position = 0; position < screenCount; ++position) {
            View dotView = new View((Context)this);
            int dotSize = ScreenUtils.dpToPx(16.0f, (Context)this);
            dotView.setLayoutParams(new ViewGroup.LayoutParams(dotSize, dotSize));
            dotView.setBackgroundResource(resource);
            this.navigationDotsLayout.addView(dotView);
            if (position != selectedPosition) continue;
            dotView.setSelected(true);
        }
    }

    private View buildLoadingState() {
        ShimmerFrameLayout shimmerFrameLayout = this.buildLoadingContainer();
        shimmerFrameLayout.addView(this.buildLoadingContent());
        return shimmerFrameLayout;
    }

    private ShimmerFrameLayout buildLoadingContainer() {
        IntercomShimmerLayout shimmerFrameLayout = new IntercomShimmerLayout((Context)this);
        FrameLayout.LayoutParams containerParams = new FrameLayout.LayoutParams(-1, -1);
        shimmerFrameLayout.setLayoutParams((ViewGroup.LayoutParams)containerParams);
        shimmerFrameLayout.setClickable(true);
        shimmerFrameLayout.setFocusable(true);
        return shimmerFrameLayout;
    }

    private View buildLoadingContent() {
        ImageView loadingImage = new ImageView((Context)this);
        loadingImage.setLayoutParams((ViewGroup.LayoutParams)this.buildContentLayoutParams());
        loadingImage.setAdjustViewBounds(true);
        loadingImage.setScaleType(ImageView.ScaleType.FIT_XY);
        loadingImage.setBackgroundResource(R.drawable.intercom_content_loading);
        return loadingImage;
    }

    private View buildErrorMessage(@StringRes int titleRes) {
        TextView errorText = new TextView((Context)this);
        errorText.setLayoutParams((ViewGroup.LayoutParams)this.buildContentLayoutParams());
        BlockUtils.setMarginBottom((View)errorText, 16);
        this.styleErrorMessage(errorText);
        errorText.setText(titleRes);
        return errorText;
    }

    private View buildRetryButton() {
        TextView retryButton = (TextView)LayoutInflater.from((Context)this).inflate(R.layout.intercom_carousel_action_button, (ViewGroup)this.stateContainer, false);
        FontUtils.setRobotoMediumTypeface(retryButton);
        retryButton.setText(R.string.intercom_retry);
        BackgroundUtils.setButtonColor(retryButton, this.appConfigProvider.get().getPrimaryColor());
        retryButton.setLayoutParams((ViewGroup.LayoutParams)this.buildRetryButtonLayoutParams());
        retryButton.setOnClickListener(v -> this.carouselPresenter.retryFetch(this.getIntent().getStringExtra(PARCEL_CAROUSEL_ID)));
        return retryButton;
    }

    private FrameLayout.LayoutParams buildRetryButtonLayoutParams() {
        FrameLayout.LayoutParams params = this.buildContentLayoutParams();
        params.height = this.getResources().getDimensionPixelSize(R.dimen.intercom_office_hours_height);
        params.setMargins(params.leftMargin, params.topMargin, params.rightMargin, this.getResources().getDimensionPixelSize(R.dimen.intercom_carousel_action_button_bottom_padding));
        params.gravity = 80;
        return params;
    }

    private FrameLayout.LayoutParams buildContentLayoutParams() {
        FrameLayout.LayoutParams contentParams = new FrameLayout.LayoutParams(-1, -2);
        int margin = this.getResources().getDimensionPixelSize(R.dimen.intercom_carousel_padding);
        contentParams.setMarginStart(margin);
        contentParams.setMarginEnd(margin);
        return contentParams;
    }

    @SuppressLint(value={"WrongConstant"})
    private void styleErrorMessage(TextView textView) {
        if (Build.VERSION.SDK_INT >= 23) {
            textView.setBreakStrategy(0);
        }
        textView.setTextColor(ContextCompat.getColor((Context)this, (int)R.color.intercom_black));
        textView.setTextSize(34.0f);
        textView.setTypeface(null, 1);
        textView.setLineSpacing((float)ScreenUtils.dpToPx(6.0f, textView.getContext()), 1.0f);
        textView.setGravity(1);
    }

    private void updateCloseButtonColor(boolean isColorLight) {
        int colorResource = isColorLight ? R.color.intercom_carousel_grey : R.color.intercom_white;
        this.setCloseButtonColor(colorResource);
    }

    private void setCloseButtonColor(@ColorRes int colorRes) {
        int color2 = ContextCompat.getColor((Context)this, (int)colorRes);
        Drawable background = this.closeBackground.getBackground();
        background.setTint(color2);
        Drawable icon = this.closeButton.getDrawable();
        icon.setTint(color2);
    }

    @VisibleForTesting
    void goToSettings() {
        this.sentToSettings = true;
        Uri uri = Uri.fromParts((String)"package", (String)this.getPackageName(), null);
        this.startActivity(new Intent("android.settings.APPLICATION_DETAILS_SETTINGS", uri));
    }

    @VisibleForTesting
    void showGoToSettingsDialog() {
        this.showRationaleDialog(R.string.intercom_permission_denied, R.string.intercom_go_to_device_settings, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                IntercomCarouselActivity.this.goToSettings();
            }
        });
    }

    private void showRationaleDialog(@StringRes int titleRes, @StringRes int messageRes, @NonNull DialogInterface.OnClickListener positiveListener) {
        AlertDialog dialog = new AlertDialog.Builder((Context)this).setTitle(titleRes).setMessage(messageRes).setPositiveButton(R.string.intercom_app_settings, positiveListener).setNegativeButton(R.string.intercom_not_now, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                IntercomCarouselActivity.this.skipPermissionScreen();
            }
        }).setCancelable(false).show();
        int buttonColor = ColorUtils.primaryOrDarkColor((Context)this, this.appConfigProvider.get());
        dialog.getButton(-2).setTextColor(buttonColor);
        dialog.getButton(-1).setTextColor(buttonColor);
    }

    @VisibleForTesting
    void selectNextScreenWithDelay() {
        new Handler().postDelayed(new Runnable(){

            @Override
            public void run() {
                IntercomCarouselActivity.this.selectNextScreen("from_permission");
            }
        }, 1000L);
    }

    @VisibleForTesting
    void closeCarouselAndResetPersistedData() {
        this.carouselPresenter.resetPersistedCarousel();
        this.finish();
    }
}

