/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.api;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import okhttp3.Interceptor;
import okhttp3.Response;

class RetryInterceptor
implements Interceptor {
    private static final int MAX_RETRIES = 3;
    private final Sleeper sleeper;

    public RetryInterceptor(Sleeper sleeper) {
        this.sleeper = sleeper;
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        for (int i = 0; i <= 3; ++i) {
            try {
                return chain.proceed(chain.request());
            }
            catch (IOException e) {
                if (i == 3) {
                    throw e;
                }
                this.sleeper.sleep(RetryInterceptor.getRetryTimer(i + 1));
                continue;
            }
        }
        throw new IOException("request failed due to network errors");
    }

    static int getRetryTimer(int count) {
        return (int)Math.pow(2.0, count);
    }

    public static class Sleeper {
        public void sleep(int time) {
            try {
                TimeUnit.SECONDS.sleep(time);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }
}

