/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.m5.conversation.reducers;

import io.intercom.android.sdk.R;
import io.intercom.android.sdk.identity.AppConfig;
import io.intercom.android.sdk.m5.components.avatar.AvatarWrapper;
import io.intercom.android.sdk.m5.conversation.reducers.TeamPresenceReducer;
import io.intercom.android.sdk.m5.conversation.states.ConversationHeader;
import io.intercom.android.sdk.m5.conversation.utils.ConversationExtensionsKt;
import io.intercom.android.sdk.models.Avatar;
import io.intercom.android.sdk.models.Conversation;
import io.intercom.android.sdk.models.Participant;
import io.intercom.android.sdk.models.TeamPresence;
import io.intercom.android.sdk.models.Ticket;
import io.intercom.android.sdk.tickets.TicketTimelineCardState;
import io.intercom.android.sdk.views.holder.TeamPresenceState;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u001a*\u0010\u0000\u001a\u00020\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0000\u00a8\u0006\n"}, d2={"reduceHeader", "Lio/intercom/android/sdk/m5/conversation/states/ConversationHeader;", "conversation", "Lio/intercom/android/sdk/models/Conversation;", "appConfig", "Lio/intercom/android/sdk/identity/AppConfig;", "teamPresence", "Lio/intercom/android/sdk/models/TeamPresence;", "hasPendingMessages", "", "intercom-sdk-base_release"})
@SourceDebugExtension(value={"SMAP\nHeaderReducer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HeaderReducer.kt\nio/intercom/android/sdk/m5/conversation/reducers/HeaderReducerKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,96:1\n1549#2:97\n1620#2,3:98\n*S KotlinDebug\n*F\n+ 1 HeaderReducer.kt\nio/intercom/android/sdk/m5/conversation/reducers/HeaderReducerKt\n*L\n83#1:97\n83#1:98,3\n*E\n"})
public final class HeaderReducerKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final ConversationHeader reduceHeader(@Nullable Conversation conversation, @NotNull AppConfig appConfig, @NotNull TeamPresence teamPresence, boolean hasPendingMessages) {
        ConversationHeader conversationHeader;
        Intrinsics.checkNotNullParameter((Object)appConfig, (String)"appConfig");
        Intrinsics.checkNotNullParameter((Object)teamPresence, (String)"teamPresence");
        TeamPresenceState teamPresenceState = TeamPresenceReducer.INSTANCE.getTeamPresenceState(conversation, teamPresence, appConfig);
        CharSequence charSequence = appConfig.getTemporaryExpectationsMessage();
        String temporaryExpectationsMessage = charSequence == null || StringsKt.isBlank((CharSequence)charSequence) ? null : appConfig.getTemporaryExpectationsMessage();
        Conversation conversation2 = conversation;
        if ((conversation2 != null ? conversation2.getId() : null) == null) {
            String string2;
            TeamPresenceState teamPresenceState2 = teamPresenceState;
            if (teamPresenceState2 instanceof TeamPresenceState.BotPresenceState) {
                string2 = ((TeamPresenceState.BotPresenceState)teamPresenceState).getBotName();
            } else if (teamPresenceState2 instanceof TeamPresenceState.AdminPresenceState) {
                string2 = ((TeamPresenceState.AdminPresenceState)teamPresenceState).getName();
            } else if (teamPresenceState2 instanceof TeamPresenceState.UnassignedPresenceState) {
                string2 = appConfig.getName();
            } else {
                throw new NoWhenBranchMatchedException();
            }
            charSequence = string2;
            Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"when (teamPresenceState)\u2026Config.name\n            }");
            ConversationHeader conversationHeader2 = new ConversationHeader((String)charSequence, null, null, null, false, false, 0, null, teamPresenceState, temporaryExpectationsMessage, 254, null);
            conversationHeader = conversationHeader2;
        } else {
            ConversationHeader.TicketProgressRowState ticketProgressRowState = !Intrinsics.areEqual((Object)conversation.getTicket(), (Object)Ticket.Companion.getNULL()) && ConversationExtensionsKt.hasNonTicketParts(conversation) | hasPendingMessages ? new ConversationHeader.TicketProgressRowState(conversation.getTicket().getTitle(), conversation.getTicket().getCurrentStatus().getTitle()) : null;
            TeamPresenceState teamPresenceState3 = teamPresenceState;
            if (teamPresenceState3 instanceof TeamPresenceState.BotPresenceState) {
                String string3 = ((TeamPresenceState.BotPresenceState)teamPresenceState).getBotName();
                TicketTimelineCardState.ActualStringOrRes.StringRes stringRes = new TicketTimelineCardState.ActualStringOrRes.StringRes(R.string.intercom_bot);
                boolean bl = ((TeamPresenceState.BotPresenceState)teamPresenceState).isAiBot();
                List list = CollectionsKt.listOf((Object)new AvatarWrapper(((TeamPresenceState.BotPresenceState)teamPresenceState).getBotAvatar(), true, null, false, false, 28, null));
                conversationHeader = new ConversationHeader(string3, stringRes, null, list, false, bl, 0, ticketProgressRowState, teamPresenceState, temporaryExpectationsMessage, 84, null);
            } else if (teamPresenceState3 instanceof TeamPresenceState.AdminPresenceState) {
                String string4 = ((TeamPresenceState.AdminPresenceState)teamPresenceState).getName();
                boolean bl = conversation.getLastParticipatingAdmin().isActive();
                List<AvatarWrapper> list = teamPresenceState.getAvatars();
                List<Participant> list2 = conversation.getGroupConversationParticipants();
                Intrinsics.checkNotNullExpressionValue(list2, (String)"conversation.groupConversationParticipants");
                int n = ((Collection)list2).size();
                TeamPresenceState teamPresenceState4 = TeamPresenceReducer.INSTANCE.getTeamPresenceState(conversation, teamPresence, appConfig);
                conversationHeader = new ConversationHeader(string4, null, null, list, bl, false, n, ticketProgressRowState, teamPresenceState4, temporaryExpectationsMessage, 38, null);
            } else if (teamPresenceState3 instanceof TeamPresenceState.UnassignedPresenceState) {
                void $this$mapTo$iv$iv;
                String string5 = appConfig.getName();
                String string6 = teamPresence.getExpectedResponseDelayShortText();
                Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"teamPresence.expectedResponseDelayShortText");
                TicketTimelineCardState.ActualStringOrRes.ActualString actualString = new TicketTimelineCardState.ActualStringOrRes.ActualString(string6);
                List<Participant> list = teamPresence.getActiveAdmins();
                Intrinsics.checkNotNullExpressionValue(list, (String)"teamPresence.activeAdmins");
                Iterable $this$map$iv = list;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    Participant participant = (Participant)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    Avatar avatar = it.getAvatar();
                    Intrinsics.checkNotNullExpressionValue((Object)avatar, (String)"it.avatar");
                    Boolean bl2 = it.isBot();
                    Intrinsics.checkNotNullExpressionValue((Object)bl2, (String)"it.isBot");
                    collection.add(new AvatarWrapper(avatar, bl2, null, false, false, 28, null));
                }
                List list3 = (List)destination$iv$iv;
                int n = R.drawable.intercom_clock;
                TeamPresenceState teamPresenceState5 = TeamPresenceReducer.INSTANCE.getTeamPresenceState(conversation, teamPresence, appConfig);
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"name");
                conversationHeader = new ConversationHeader(string5, actualString, n, list3, false, false, 0, ticketProgressRowState, teamPresenceState5, temporaryExpectationsMessage, 112, null);
            } else {
                throw new NoWhenBranchMatchedException();
            }
        }
        return conversationHeader;
    }
}

