/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.helpcenter.collections;

import android.content.Context;
import android.content.res.Configuration;
import androidx.lifecycle.ViewModel;
import androidx.lifecycle.ViewModelKt;
import androidx.lifecycle.ViewModelProvider;
import androidx.lifecycle.ViewModelStoreOwner;
import com.squareup.otto.Bus;
import com.squareup.otto.Subscribe;
import io.intercom.android.sdk.Injector;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.helpcenter.api.HelpCenterApi;
import io.intercom.android.sdk.helpcenter.articles.ArticleViewState;
import io.intercom.android.sdk.helpcenter.collections.ArticleSectionRow;
import io.intercom.android.sdk.helpcenter.collections.CollectionListRow;
import io.intercom.android.sdk.helpcenter.collections.CollectionViewState;
import io.intercom.android.sdk.helpcenter.collections.HelpCenterCollection;
import io.intercom.android.sdk.helpcenter.collections.HelpCenterEffects;
import io.intercom.android.sdk.helpcenter.collections.HelpCenterViewModel;
import io.intercom.android.sdk.helpcenter.component.TeammateHelpKt;
import io.intercom.android.sdk.helpcenter.sections.HelpCenterArticle;
import io.intercom.android.sdk.helpcenter.sections.HelpCenterCollectionContent;
import io.intercom.android.sdk.helpcenter.utils.HelpCenterEligibilityChecker;
import io.intercom.android.sdk.helpcenter.utils.networking.NetworkResponse;
import io.intercom.android.sdk.identity.AppConfig;
import io.intercom.android.sdk.m5.components.ErrorState;
import io.intercom.android.sdk.metrics.MetricTracker;
import io.intercom.android.sdk.models.TeamPresence;
import io.intercom.android.sdk.models.events.ConfigUpdateEvent;
import io.intercom.android.sdk.utilities.ContextLocaliser;
import io.intercom.android.sdk.utilities.extensions.AppConfigExtensionsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineDispatcher;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableSharedFlow;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.SharedFlow;
import kotlinx.coroutines.flow.SharedFlowKt;
import kotlinx.coroutines.flow.SharingStarted;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00c0\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 N2\u00020\u0001:\u0001NBM\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u0012\b\b\u0002\u0010\f\u001a\u00020\r\u0012\b\b\u0002\u0010\u000e\u001a\u00020\u000f\u0012\b\b\u0002\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0002\u0010\u0012J\u0010\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u000200H\u0007J\u0016\u00101\u001a\u00020\u001e2\f\u00102\u001a\b\u0012\u0004\u0012\u00020.03H\u0002J\u0016\u00104\u001a\u00020.2\u000e\b\u0002\u00105\u001a\b\u0012\u0004\u0012\u00020\t06J\u000e\u00107\u001a\u00020.2\u0006\u00108\u001a\u00020\tJ\b\u00109\u001a\u00020 H\u0002J\u000e\u0010:\u001a\u00020;2\u0006\u0010<\u001a\u00020;J\u000e\u0010=\u001a\u00020.2\u0006\u0010>\u001a\u00020\tJ\b\u0010?\u001a\u00020.H\u0014J\u0019\u0010@\u001a\u00020.2\n\b\u0002\u0010A\u001a\u0004\u0018\u00010BH\u0002\u00a2\u0006\u0002\u0010CJ\u0019\u0010D\u001a\u00020.2\n\b\u0002\u0010A\u001a\u0004\u0018\u00010BH\u0002\u00a2\u0006\u0002\u0010CJ\b\u0010E\u001a\u00020 H\u0002J\u0016\u0010F\u001a\b\u0012\u0004\u0012\u00020H0G2\u0006\u0010I\u001a\u00020JH\u0002J\u001c\u0010F\u001a\b\u0012\u0004\u0012\u00020K0G2\f\u0010L\u001a\b\u0012\u0004\u0012\u00020M0GH\u0002R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00150\u001a\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020 X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020 X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010#\u001a\u00020$8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b'\u0010(\u001a\u0004\b%\u0010&R\u0017\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00180*\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010,R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006O"}, d2={"Lio/intercom/android/sdk/helpcenter/collections/HelpCenterViewModel;", "Landroidx/lifecycle/ViewModel;", "helpCenterApi", "Lio/intercom/android/sdk/helpcenter/api/HelpCenterApi;", "appConfig", "Lio/intercom/android/sdk/identity/AppConfig;", "metricTracker", "Lio/intercom/android/sdk/metrics/MetricTracker;", "place", "", "helpCenterEligibilityChecker", "Lio/intercom/android/sdk/helpcenter/utils/HelpCenterEligibilityChecker;", "dispatcher", "Lkotlinx/coroutines/CoroutineDispatcher;", "bus", "Lcom/squareup/otto/Bus;", "teamPresence", "Lio/intercom/android/sdk/models/TeamPresence;", "(Lio/intercom/android/sdk/helpcenter/api/HelpCenterApi;Lio/intercom/android/sdk/identity/AppConfig;Lio/intercom/android/sdk/metrics/MetricTracker;Ljava/lang/String;Lio/intercom/android/sdk/helpcenter/utils/HelpCenterEligibilityChecker;Lkotlinx/coroutines/CoroutineDispatcher;Lcom/squareup/otto/Bus;Lio/intercom/android/sdk/models/TeamPresence;)V", "_effect", "Lkotlinx/coroutines/flow/MutableSharedFlow;", "Lio/intercom/android/sdk/helpcenter/collections/HelpCenterEffects;", "_state", "Lkotlinx/coroutines/flow/MutableStateFlow;", "Lio/intercom/android/sdk/helpcenter/collections/CollectionViewState;", "effect", "Lkotlinx/coroutines/flow/SharedFlow;", "getEffect", "()Lkotlinx/coroutines/flow/SharedFlow;", "genericError", "Lio/intercom/android/sdk/helpcenter/collections/CollectionViewState$Error;", "hasClickedAtLeastOneArticle", "", "isPartialHelpCenterLoaded", "notFoundError", "searchBrowseTeamPresenceState", "Lio/intercom/android/sdk/helpcenter/articles/ArticleViewState$TeamPresenceState;", "getSearchBrowseTeamPresenceState", "()Lio/intercom/android/sdk/helpcenter/articles/ArticleViewState$TeamPresenceState;", "searchBrowseTeamPresenceState$delegate", "Lkotlin/Lazy;", "state", "Lkotlinx/coroutines/flow/StateFlow;", "getState", "()Lkotlinx/coroutines/flow/StateFlow;", "configUpdated", "", "event", "Lio/intercom/android/sdk/models/events/ConfigUpdateEvent;", "errorWithRetry", "onClick", "Lkotlin/Function0;", "fetchCollections", "collectionIds", "", "fetchSingleCollection", "collectionId", "isFromSearchBrowse", "localizedContext", "Landroid/content/Context;", "context", "onArticleClicked", "articleId", "onCleared", "sendFailedCollectionListMetric", "errorCode", "", "(Ljava/lang/Integer;)V", "sendFailedSingleCollectionMetric", "shouldAddSendMessageRow", "transformToUiModel", "", "Lio/intercom/android/sdk/helpcenter/collections/ArticleSectionRow;", "networkResponse", "Lio/intercom/android/sdk/helpcenter/sections/HelpCenterCollectionContent;", "Lio/intercom/android/sdk/helpcenter/collections/CollectionListRow$CollectionRow;", "body", "Lio/intercom/android/sdk/helpcenter/collections/HelpCenterCollection;", "Companion", "intercom-sdk-base_release"})
@SourceDebugExtension(value={"SMAP\nHelpCenterViewModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HelpCenterViewModel.kt\nio/intercom/android/sdk/helpcenter/collections/HelpCenterViewModel\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,369:1\n1549#2:370\n1620#2,3:371\n1549#2:374\n1620#2,3:375\n1549#2:378\n1620#2,3:379\n*S KotlinDebug\n*F\n+ 1 HelpCenterViewModel.kt\nio/intercom/android/sdk/helpcenter/collections/HelpCenterViewModel\n*L\n201#1:370\n201#1:371,3\n297#1:374\n297#1:375,3\n306#1:378\n306#1:379,3\n*E\n"})
public final class HelpCenterViewModel
extends ViewModel {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final HelpCenterApi helpCenterApi;
    @NotNull
    private final AppConfig appConfig;
    @NotNull
    private final MetricTracker metricTracker;
    @NotNull
    private final String place;
    @NotNull
    private final HelpCenterEligibilityChecker helpCenterEligibilityChecker;
    @NotNull
    private final CoroutineDispatcher dispatcher;
    @NotNull
    private final Bus bus;
    @NotNull
    private final TeamPresence teamPresence;
    @NotNull
    private final MutableStateFlow<CollectionViewState> _state;
    @NotNull
    private final StateFlow<CollectionViewState> state;
    @NotNull
    private final MutableSharedFlow<HelpCenterEffects> _effect;
    @NotNull
    private final SharedFlow<HelpCenterEffects> effect;
    private boolean isPartialHelpCenterLoaded;
    private boolean hasClickedAtLeastOneArticle;
    @NotNull
    private final CollectionViewState.Error genericError;
    @NotNull
    private final CollectionViewState.Error notFoundError;
    @NotNull
    private final Lazy searchBrowseTeamPresenceState$delegate;

    public HelpCenterViewModel(@NotNull HelpCenterApi helpCenterApi, @NotNull AppConfig appConfig, @NotNull MetricTracker metricTracker, @NotNull String place, @NotNull HelpCenterEligibilityChecker helpCenterEligibilityChecker, @NotNull CoroutineDispatcher dispatcher, @NotNull Bus bus, @NotNull TeamPresence teamPresence) {
        Intrinsics.checkNotNullParameter((Object)helpCenterApi, (String)"helpCenterApi");
        Intrinsics.checkNotNullParameter((Object)appConfig, (String)"appConfig");
        Intrinsics.checkNotNullParameter((Object)metricTracker, (String)"metricTracker");
        Intrinsics.checkNotNullParameter((Object)place, (String)"place");
        Intrinsics.checkNotNullParameter((Object)helpCenterEligibilityChecker, (String)"helpCenterEligibilityChecker");
        Intrinsics.checkNotNullParameter((Object)dispatcher, (String)"dispatcher");
        Intrinsics.checkNotNullParameter((Object)bus, (String)"bus");
        Intrinsics.checkNotNullParameter((Object)teamPresence, (String)"teamPresence");
        this.helpCenterApi = helpCenterApi;
        this.appConfig = appConfig;
        this.metricTracker = metricTracker;
        this.place = place;
        this.helpCenterEligibilityChecker = helpCenterEligibilityChecker;
        this.dispatcher = dispatcher;
        this.bus = bus;
        this.teamPresence = teamPresence;
        this._state = StateFlowKt.MutableStateFlow((Object)CollectionViewState.Initial.INSTANCE);
        this.state = FlowKt.asStateFlow(this._state);
        this._effect = SharedFlowKt.MutableSharedFlow$default((int)0, (int)0, null, (int)7, null);
        this.effect = FlowKt.shareIn$default((Flow)((Flow)this._effect), (CoroutineScope)ViewModelKt.getViewModelScope((ViewModel)this), (SharingStarted)SharingStarted.Companion.getEagerly(), (int)0, (int)4, null);
        this.genericError = new CollectionViewState.Error(new ErrorState.WithoutCTA(0, 0, null, 7, null));
        this.notFoundError = new CollectionViewState.Error(new ErrorState.WithoutCTA(0, R.string.intercom_page_not_found, null, 5, null));
        this.searchBrowseTeamPresenceState$delegate = LazyKt.lazy((Function0)((Function0)new Function0<ArticleViewState.TeamPresenceState>(this){
            final /* synthetic */ HelpCenterViewModel this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final ArticleViewState.TeamPresenceState invoke() {
                ArticleViewState.TeamPresenceState teamPresenceState = ArticleViewState.TeamPresenceState.Companion.getDefaultTeamPresenceState();
                AppConfig appConfig = HelpCenterViewModel.access$getAppConfig$p(this.this$0);
                String string2 = HelpCenterViewModel.access$getPlace$p(this.this$0);
                TeamPresence teamPresence = HelpCenterViewModel.access$getTeamPresence$p(this.this$0);
                return TeammateHelpKt.computeViewState("", teamPresenceState, teamPresence, appConfig, string2, true);
            }
        }));
        if (((CharSequence)this.place).length() > 0) {
            this.metricTracker.openedNativeHelpCenter(this.place, null);
        }
        this.bus.register((Object)this);
    }

    public /* synthetic */ HelpCenterViewModel(HelpCenterApi helpCenterApi, AppConfig appConfig, MetricTracker metricTracker, String string2, HelpCenterEligibilityChecker helpCenterEligibilityChecker, CoroutineDispatcher coroutineDispatcher, Bus bus, TeamPresence teamPresence, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            helpCenterEligibilityChecker = HelpCenterEligibilityChecker.INSTANCE;
        }
        if ((n & 0x20) != 0) {
            coroutineDispatcher = Dispatchers.getIO();
        }
        if ((n & 0x40) != 0) {
            Bus bus2 = Injector.get().getBus();
            Intrinsics.checkNotNullExpressionValue((Object)bus2, (String)"get().bus");
            bus = bus2;
        }
        if ((n & 0x80) != 0) {
            TeamPresence teamPresence2 = Injector.get().getStore().state().teamPresence();
            Intrinsics.checkNotNullExpressionValue((Object)teamPresence2, (String)"get().store.state().teamPresence()");
            teamPresence = teamPresence2;
        }
        this(helpCenterApi, appConfig, metricTracker, string2, helpCenterEligibilityChecker, coroutineDispatcher, bus, teamPresence);
    }

    @NotNull
    public final StateFlow<CollectionViewState> getState() {
        return this.state;
    }

    @NotNull
    public final SharedFlow<HelpCenterEffects> getEffect() {
        return this.effect;
    }

    private final CollectionViewState.Error errorWithRetry(Function0<Unit> onClick2) {
        return new CollectionViewState.Error(new ErrorState.WithCTA(0, 0, null, 0, onClick2, 15, null));
    }

    private final ArticleViewState.TeamPresenceState getSearchBrowseTeamPresenceState() {
        Lazy lazy = this.searchBrowseTeamPresenceState$delegate;
        return (ArticleViewState.TeamPresenceState)lazy.getValue();
    }

    @NotNull
    public final Context localizedContext(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Configuration localisedConfiguration = new Configuration(context.getResources().getConfiguration());
        Locale newLocale = ContextLocaliser.convertToLocale(this.appConfig.getHelpCenterLocale());
        localisedConfiguration.setLocale(newLocale);
        Context context2 = context.createConfigurationContext(localisedConfiguration);
        Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"context.createConfigurat\u2026t(localisedConfiguration)");
        return context2;
    }

    public final void fetchCollections(@NotNull Set<String> collectionIds) {
        Intrinsics.checkNotNullParameter(collectionIds, (String)"collectionIds");
        if (!this.helpCenterEligibilityChecker.isEligibleUser()) {
            this._state.setValue((Object)this.genericError);
            return;
        }
        BuildersKt.launch$default((CoroutineScope)ViewModelKt.getViewModelScope((ViewModel)this), (CoroutineContext)((CoroutineContext)this.dispatcher), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, collectionIds, null){
            Object L$0;
            int label;
            final /* synthetic */ HelpCenterViewModel this$0;
            final /* synthetic */ Set<String> $collectionIds;
            {
                this.this$0 = $receiver;
                this.$collectionIds = $collectionIds;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                block17: {
                    block18: {
                        block19: {
                            var17_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)var1_1);
                                    if (this.this$0.getState().getValue() instanceof CollectionViewState.Content.CollectionListContent) {
                                        return Unit.INSTANCE;
                                    }
                                    HelpCenterViewModel.access$get_state$p(this.this$0).setValue((Object)CollectionViewState.Loading.INSTANCE);
                                    this.label = 1;
                                    v0 = HelpCenterApi.DefaultImpls.fetchCollectionList$default(HelpCenterViewModel.access$getHelpCenterApi$p(this.this$0), null, (Continuation)this, 1, null);
                                    if (v0 == var17_2) {
                                        return var17_2;
                                    }
                                    ** GOTO lbl16
                                }
                                case 1: {
                                    ResultKt.throwOnFailure((Object)$result);
                                    v0 = $result;
lbl16:
                                    // 2 sources

                                    fetchCollectionListResponse = (NetworkResponse)v0;
                                    v1 = HelpCenterViewModel.access$get_state$p(this.this$0);
                                    var3_4 = fetchCollectionListResponse;
                                    if (!(var3_4 instanceof NetworkResponse.ServerError)) ** GOTO lbl23
                                    HelpCenterViewModel.access$sendFailedCollectionListMetric(this.this$0, Boxing.boxInt((int)((NetworkResponse.ServerError)fetchCollectionListResponse).getCode()));
                                    v2 = ((NetworkResponse.ServerError)fetchCollectionListResponse).getCode() == 404 ? HelpCenterViewModel.access$getNotFoundError$p(this.this$0) : HelpCenterViewModel.access$getGenericError$p(this.this$0);
                                    break block17;
lbl23:
                                    // 1 sources

                                    if (!(var3_4 instanceof NetworkResponse.ClientError)) ** GOTO lbl27
                                    HelpCenterViewModel.sendFailedCollectionListMetric$default(this.this$0, null, 1, null);
                                    v2 = HelpCenterViewModel.access$getGenericError$p(this.this$0);
                                    break block17;
lbl27:
                                    // 1 sources

                                    if (!(var3_4 instanceof NetworkResponse.NetworkError)) ** GOTO lbl31
                                    HelpCenterViewModel.sendFailedCollectionListMetric$default(this.this$0, null, 1, null);
                                    v2 = HelpCenterViewModel.access$errorWithRetry(this.this$0, (Function0)new Function0<Unit>(this.this$0, this.$collectionIds){
                                        final /* synthetic */ HelpCenterViewModel this$0;
                                        final /* synthetic */ Set<String> $collectionIds;
                                        {
                                            this.this$0 = $receiver;
                                            this.$collectionIds = $collectionIds;
                                            super(0);
                                        }

                                        public final void invoke() {
                                            this.this$0.fetchCollections(this.$collectionIds);
                                        }
                                    });
                                    break block17;
lbl31:
                                    // 1 sources

                                    if (!(var3_4 instanceof NetworkResponse.Success)) break block18;
                                    fullCollectionList = (List)((NetworkResponse.Success)fetchCollectionListResponse).getBody();
                                    var6_6 = fullCollectionList;
                                    var7_8 = this.$collectionIds;
                                    var16_9 = v1;
                                    $i$f$filter = false;
                                    var9_12 = $this$filter$iv;
                                    destination$iv$iv = new ArrayList<E>();
                                    $i$f$filterTo = false;
                                    for (T element$iv$iv : $this$filterTo$iv$iv) {
                                        it = (HelpCenterCollection)element$iv$iv;
                                        $i$a$-filter-HelpCenterViewModel$fetchCollections$1$filteredCollectionList$1 = false;
                                        if (!var7_8.contains(it.getId())) continue;
                                        destination$iv$iv.add(element$iv$iv);
                                    }
                                    v1 = var16_9;
                                    filteredCollectionList = (List)destination$iv$iv;
                                    HelpCenterViewModel.access$setPartialHelpCenterLoaded$p(this.this$0, filteredCollectionList.size() < fullCollectionList.size() && ((Collection)filteredCollectionList).isEmpty() == false != false);
                                    HelpCenterViewModel.access$getMetricTracker$p(this.this$0).viewedNativeHelpCenter("collection_list", Boxing.boxBoolean((boolean)HelpCenterViewModel.access$isPartialHelpCenterLoaded$p(this.this$0)), HelpCenterViewModel.access$isFromSearchBrowse(this.this$0));
                                    if (filteredCollectionList.size() != 1) break;
                                    var16_9 = v1;
                                    this.L$0 = var16_9;
                                    this.label = 2;
                                    v3 = HelpCenterViewModel.access$get_effect$p(this.this$0).emit((Object)new HelpCenterEffects.NavigateToCollectionContent(((HelpCenterCollection)CollectionsKt.first((List)filteredCollectionList)).getId()), (Continuation)this);
                                    if (v3 == var17_2) {
                                        return var17_2;
                                    }
                                    ** GOTO lbl64
                                }
                                case 2: {
                                    var16_9 = (MutableStateFlow)this.L$0;
                                    ResultKt.throwOnFailure((Object)$result);
                                    v3 = $result;
lbl64:
                                    // 2 sources

                                    v4 = var16_9;
                                    return Unit.INSTANCE;
                                }
                            }
                            if (fullCollectionList.size() != 1) break block19;
                            var16_9 = v1;
                            this.L$0 = var16_9;
                            this.label = 3;
                            v5 = HelpCenterViewModel.access$get_effect$p(this.this$0).emit((Object)new HelpCenterEffects.NavigateToCollectionContent(((HelpCenterCollection)CollectionsKt.first((List)fullCollectionList)).getId()), (Continuation)this);
                            if (v5 == var17_2) {
                                return var17_2;
                            }
                            ** GOTO lbl78
                            {
                                case 3: {
                                    var16_9 = (MutableStateFlow)this.L$0;
                                    ResultKt.throwOnFailure((Object)$result);
                                    v5 = $result;
lbl78:
                                    // 2 sources

                                    v6 = var16_9;
                                    return Unit.INSTANCE;
                                }
                            }
                        }
                        isFilteredList = ((Collection)filteredCollectionList).isEmpty() == false;
                        collectionListToLoad = filteredCollectionList.isEmpty() != false ? fullCollectionList : filteredCollectionList;
                        if (((Collection)collectionListToLoad).isEmpty() == false) {
                            uiModel = CollectionsKt.toMutableList((Collection)HelpCenterViewModel.access$transformToUiModel(this.this$0, collectionListToLoad));
                            if (isFilteredList) {
                                uiModel.add(CollectionListRow.BrowseAllHelpTopicsAsListItem.INSTANCE);
                            } else if (HelpCenterViewModel.access$isPartialHelpCenterLoaded$p(this.this$0)) {
                                uiModel.add(CollectionListRow.FullHelpCenterRow.INSTANCE);
                            }
                            if (HelpCenterViewModel.access$shouldAddSendMessageRow(this.this$0)) {
                                uiModel.add(new CollectionListRow.SendMessageRow(HelpCenterViewModel.access$getSearchBrowseTeamPresenceState(this.this$0)));
                            }
                            v2 = new CollectionViewState.Content.CollectionListContent(uiModel);
                        } else {
                            v2 = HelpCenterViewModel.access$getGenericError$p(this.this$0);
                        }
                        break block17;
                    }
                    throw new NoWhenBranchMatchedException();
                }
                v1.setValue((Object)v2);
                return Unit.INSTANCE;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    public static /* synthetic */ void fetchCollections$default(HelpCenterViewModel helpCenterViewModel, Set set, int n, Object object) {
        if ((n & 1) != 0) {
            set = SetsKt.emptySet();
        }
        helpCenterViewModel.fetchCollections(set);
    }

    private final void sendFailedCollectionListMetric(Integer errorCode) {
        Integer n = errorCode;
        this.metricTracker.failedHelpCenter("help_center", "collection_list", n != null ? n.toString() : null, this.isFromSearchBrowse());
    }

    static /* synthetic */ void sendFailedCollectionListMetric$default(HelpCenterViewModel helpCenterViewModel, Integer n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = null;
        }
        helpCenterViewModel.sendFailedCollectionListMetric(n);
    }

    /*
     * WARNING - void declaration
     */
    private final List<CollectionListRow.CollectionRow> transformToUiModel(List<HelpCenterCollection> body) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = body;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            HelpCenterCollection helpCenterCollection = (HelpCenterCollection)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new CollectionListRow.CollectionRow(new CollectionViewState.CollectionRowData(it.getId(), it.getTitle(), ((CharSequence)it.getSummary()).length() == 0 ? 8 : 0, it.getSummary(), it.getArticlesCount(), it.getCollectionsCount())));
        }
        return (List)destination$iv$iv;
    }

    public final void fetchSingleCollection(@NotNull String collectionId) {
        Intrinsics.checkNotNullParameter((Object)collectionId, (String)"collectionId");
        BuildersKt.launch$default((CoroutineScope)ViewModelKt.getViewModelScope((ViewModel)this), (CoroutineContext)((CoroutineContext)this.dispatcher), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, collectionId, null){
            int label;
            final /* synthetic */ HelpCenterViewModel this$0;
            final /* synthetic */ String $collectionId;
            {
                this.this$0 = $receiver;
                this.$collectionId = $collectionId;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var7_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        currentState = (CollectionViewState)this.this$0.getState().getValue();
                        if (currentState instanceof CollectionViewState.Content.CollectionContent && Intrinsics.areEqual((Object)((CollectionViewState.Content.CollectionContent)currentState).getId(), (Object)this.$collectionId)) {
                            return Unit.INSTANCE;
                        }
                        HelpCenterViewModel.access$get_state$p(this.this$0).setValue((Object)CollectionViewState.Loading.INSTANCE);
                        this.label = 1;
                        v0 = HelpCenterApi.DefaultImpls.fetchSectionsList$default(HelpCenterViewModel.access$getHelpCenterApi$p(this.this$0), this.$collectionId, null, (Continuation)this, 2, null);
                        if (v0 == var7_2) {
                            return var7_2;
                        }
                        ** GOTO lbl17
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl17:
                        // 2 sources

                        sectionListResponse = (NetworkResponse)v0;
                        v1 = HelpCenterViewModel.access$get_state$p(this.this$0);
                        var4_5 = sectionListResponse;
                        if (var4_5 instanceof NetworkResponse.ServerError) {
                            HelpCenterViewModel.access$sendFailedSingleCollectionMetric(this.this$0, Boxing.boxInt((int)((NetworkResponse.ServerError)sectionListResponse).getCode()));
                            v2 = ((NetworkResponse.ServerError)sectionListResponse).getCode() == 404 ? HelpCenterViewModel.access$getNotFoundError$p(this.this$0) : HelpCenterViewModel.access$getGenericError$p(this.this$0);
                        } else if (var4_5 instanceof NetworkResponse.ClientError) {
                            HelpCenterViewModel.sendFailedSingleCollectionMetric$default(this.this$0, null, 1, null);
                            v2 = HelpCenterViewModel.access$getGenericError$p(this.this$0);
                        } else if (var4_5 instanceof NetworkResponse.NetworkError) {
                            HelpCenterViewModel.sendFailedSingleCollectionMetric$default(this.this$0, null, 1, null);
                            v2 = HelpCenterViewModel.access$errorWithRetry(this.this$0, (Function0)new Function0<Unit>(this.this$0, this.$collectionId){
                                final /* synthetic */ HelpCenterViewModel this$0;
                                final /* synthetic */ String $collectionId;
                                {
                                    this.this$0 = $receiver;
                                    this.$collectionId = $collectionId;
                                    super(0);
                                }

                                public final void invoke() {
                                    this.this$0.fetchSingleCollection(this.$collectionId);
                                }
                            });
                        } else if (var4_5 instanceof NetworkResponse.Success) {
                            collectionContent = (HelpCenterCollectionContent)((NetworkResponse.Success)sectionListResponse).getBody();
                            newState = CollectionsKt.toMutableList((Collection)HelpCenterViewModel.access$transformToUiModel(this.this$0, collectionContent));
                            if (HelpCenterViewModel.access$isPartialHelpCenterLoaded$p(this.this$0)) {
                                newState.add(ArticleSectionRow.FullHelpCenterRow.INSTANCE);
                            }
                            HelpCenterViewModel.access$getMetricTracker$p(this.this$0).viewedNativeHelpCenter("article_list", Boxing.boxBoolean((boolean)HelpCenterViewModel.access$isPartialHelpCenterLoaded$p(this.this$0)), HelpCenterViewModel.access$isFromSearchBrowse(this.this$0));
                            if (HelpCenterViewModel.access$shouldAddSendMessageRow(this.this$0)) {
                                newState.add(new ArticleSectionRow.SendMessageRow(HelpCenterViewModel.access$getSearchBrowseTeamPresenceState(this.this$0)));
                            }
                            v2 = new CollectionViewState.Content.CollectionContent(collectionContent.getCollectionId(), collectionContent.getTitle(), collectionContent.getSummary(), collectionContent.getArticlesCount(), collectionContent.getAuthors(), newState);
                        } else {
                            throw new NoWhenBranchMatchedException();
                        }
                        v1.setValue((Object)v2);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    public final void onArticleClicked(@NotNull String articleId) {
        Intrinsics.checkNotNullParameter((Object)articleId, (String)"articleId");
        BuildersKt.launch$default((CoroutineScope)ViewModelKt.getViewModelScope((ViewModel)this), (CoroutineContext)((CoroutineContext)this.dispatcher), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, articleId, null){
            Object L$0;
            int label;
            final /* synthetic */ HelpCenterViewModel this$0;
            final /* synthetic */ String $articleId;
            {
                this.this$0 = $receiver;
                this.$articleId = $articleId;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        HelpCenterViewModel.access$setHasClickedAtLeastOneArticle$p(this.this$0, true);
                        this.label = 1;
                        v0 = HelpCenterViewModel.access$get_effect$p(this.this$0).emit((Object)new HelpCenterEffects.NavigateToArticle(this.$articleId), (Continuation)this);
                        if (v0 == var3_2) {
                            return var3_2;
                        }
                        ** GOTO lbl14
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl14:
                        // 2 sources

                        if (!HelpCenterViewModel.access$shouldAddSendMessageRow(this.this$0) || !((currentState = (CollectionViewState)HelpCenterViewModel.access$get_state$p(this.this$0).getValue()) instanceof CollectionViewState.Content.CollectionContent) || ((CollectionViewState.Content.CollectionContent)currentState).hasSendMessageRow()) ** GOTO lbl26
                        this.L$0 = currentState;
                        this.label = 2;
                        v1 = DelayKt.delay((long)2000L, (Continuation)((Continuation)this));
                        if (v1 == var3_2) {
                            return var3_2;
                        }
                        ** GOTO lbl25
                    }
                    case 2: {
                        currentState = (CollectionViewState)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl25:
                        // 2 sources

                        HelpCenterViewModel.access$get_state$p(this.this$0).setValue((Object)((CollectionViewState.Content.CollectionContent)currentState).copyWithSingleSendMessageRow(HelpCenterViewModel.access$getSearchBrowseTeamPresenceState(this.this$0)));
lbl26:
                        // 2 sources

                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    private final boolean shouldAddSendMessageRow() {
        return AppConfigExtensionsKt.canStartNewConversation(this.appConfig) && this.hasClickedAtLeastOneArticle;
    }

    private final void sendFailedSingleCollectionMetric(Integer errorCode) {
        Integer n = errorCode;
        this.metricTracker.failedHelpCenter("help_center", "article_list", n != null ? n.toString() : null, this.isFromSearchBrowse());
    }

    static /* synthetic */ void sendFailedSingleCollectionMetric$default(HelpCenterViewModel helpCenterViewModel, Integer n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = null;
        }
        helpCenterViewModel.sendFailedSingleCollectionMetric(n);
    }

    private final List<ArticleSectionRow> transformToUiModel(HelpCenterCollectionContent networkResponse) {
        HelpCenterCollection it;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        List list;
        List $this$transformToUiModel_u24lambda_u243 = list = (List)new ArrayList();
        boolean bl = false;
        Iterable iterable = networkResponse.getHelpCenterArticles();
        List list2 = $this$transformToUiModel_u24lambda_u243;
        boolean $i$f$map = false;
        void var8_8 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            HelpCenterArticle helpCenterArticle = (HelpCenterArticle)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl2 = false;
            String string2 = ((HelpCenterArticle)((Object)it)).getTitle();
            String string3 = ((HelpCenterArticle)((Object)it)).getArticleId();
            collection.add(new ArticleSectionRow.ArticleRow(string3, string2));
        }
        list2.addAll((List)destination$iv$iv);
        $this$map$iv = networkResponse.getSubCollections();
        list2 = $this$transformToUiModel_u24lambda_u243;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (HelpCenterCollection)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl3 = false;
            collection.add(new ArticleSectionRow.CollectionRow(new CollectionViewState.CollectionRowData(it.getId(), it.getTitle(), ((CharSequence)it.getSummary()).length() == 0 ? 8 : 0, it.getSummary(), it.getArticlesCount(), it.getCollectionsCount())));
        }
        list2.addAll((List)destination$iv$iv);
        return list;
    }

    @Subscribe
    public final void configUpdated(@NotNull ConfigUpdateEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        CollectionViewState currentState = (CollectionViewState)this._state.getValue();
        if (currentState instanceof CollectionViewState.Content) {
            this._state.setValue((Object)(this.shouldAddSendMessageRow() ? (CollectionViewState)((CollectionViewState.Content)currentState).copyWithSingleSendMessageRow(this.getSearchBrowseTeamPresenceState()) : (CollectionViewState)((CollectionViewState.Content)currentState).copyWithoutSendMessageRow()));
        }
    }

    private final boolean isFromSearchBrowse() {
        return Intrinsics.areEqual((Object)this.place, (Object)"search_browse");
    }

    protected void onCleared() {
        super.onCleared();
        this.bus.unregister((Object)this);
    }

    public static final /* synthetic */ MutableStateFlow access$get_state$p(HelpCenterViewModel $this) {
        return $this._state;
    }

    public static final /* synthetic */ HelpCenterApi access$getHelpCenterApi$p(HelpCenterViewModel $this) {
        return $this.helpCenterApi;
    }

    public static final /* synthetic */ void access$sendFailedCollectionListMetric(HelpCenterViewModel $this, Integer errorCode) {
        $this.sendFailedCollectionListMetric(errorCode);
    }

    public static final /* synthetic */ CollectionViewState.Error access$getNotFoundError$p(HelpCenterViewModel $this) {
        return $this.notFoundError;
    }

    public static final /* synthetic */ CollectionViewState.Error access$getGenericError$p(HelpCenterViewModel $this) {
        return $this.genericError;
    }

    public static final /* synthetic */ CollectionViewState.Error access$errorWithRetry(HelpCenterViewModel $this, Function0 onClick2) {
        return $this.errorWithRetry((Function0<Unit>)onClick2);
    }

    public static final /* synthetic */ void access$setPartialHelpCenterLoaded$p(HelpCenterViewModel $this, boolean bl) {
        $this.isPartialHelpCenterLoaded = bl;
    }

    public static final /* synthetic */ MetricTracker access$getMetricTracker$p(HelpCenterViewModel $this) {
        return $this.metricTracker;
    }

    public static final /* synthetic */ boolean access$isPartialHelpCenterLoaded$p(HelpCenterViewModel $this) {
        return $this.isPartialHelpCenterLoaded;
    }

    public static final /* synthetic */ boolean access$isFromSearchBrowse(HelpCenterViewModel $this) {
        return $this.isFromSearchBrowse();
    }

    public static final /* synthetic */ MutableSharedFlow access$get_effect$p(HelpCenterViewModel $this) {
        return $this._effect;
    }

    public static final /* synthetic */ List access$transformToUiModel(HelpCenterViewModel $this, List body) {
        return $this.transformToUiModel(body);
    }

    public static final /* synthetic */ boolean access$shouldAddSendMessageRow(HelpCenterViewModel $this) {
        return $this.shouldAddSendMessageRow();
    }

    public static final /* synthetic */ ArticleViewState.TeamPresenceState access$getSearchBrowseTeamPresenceState(HelpCenterViewModel $this) {
        return $this.getSearchBrowseTeamPresenceState();
    }

    public static final /* synthetic */ void access$sendFailedSingleCollectionMetric(HelpCenterViewModel $this, Integer errorCode) {
        $this.sendFailedSingleCollectionMetric(errorCode);
    }

    public static final /* synthetic */ List access$transformToUiModel(HelpCenterViewModel $this, HelpCenterCollectionContent networkResponse) {
        return $this.transformToUiModel(networkResponse);
    }

    public static final /* synthetic */ void access$setHasClickedAtLeastOneArticle$p(HelpCenterViewModel $this, boolean bl) {
        $this.hasClickedAtLeastOneArticle = bl;
    }

    public static final /* synthetic */ AppConfig access$getAppConfig$p(HelpCenterViewModel $this) {
        return $this.appConfig;
    }

    public static final /* synthetic */ String access$getPlace$p(HelpCenterViewModel $this) {
        return $this.place;
    }

    public static final /* synthetic */ TeamPresence access$getTeamPresence$p(HelpCenterViewModel $this) {
        return $this.teamPresence;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000+\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\b\u0004*\u0001\f\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u001d\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\nH\u0002\u00a2\u0006\u0002\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lio/intercom/android/sdk/helpcenter/collections/HelpCenterViewModel$Companion;", "", "()V", "create", "Lio/intercom/android/sdk/helpcenter/collections/HelpCenterViewModel;", "owner", "Landroidx/lifecycle/ViewModelStoreOwner;", "helpCenterApi", "Lio/intercom/android/sdk/helpcenter/api/HelpCenterApi;", "place", "", "factory", "io/intercom/android/sdk/helpcenter/collections/HelpCenterViewModel$Companion$factory$1", "metricContext", "(Lio/intercom/android/sdk/helpcenter/api/HelpCenterApi;Ljava/lang/String;)Lio/intercom/android/sdk/helpcenter/collections/HelpCenterViewModel$Companion$factory$1;", "intercom-sdk-base_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final HelpCenterViewModel create(@NotNull ViewModelStoreOwner owner, @NotNull HelpCenterApi helpCenterApi, @NotNull String place) {
            Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
            Intrinsics.checkNotNullParameter((Object)helpCenterApi, (String)"helpCenterApi");
            Intrinsics.checkNotNullParameter((Object)place, (String)"place");
            return (HelpCenterViewModel)new ViewModelProvider(owner, (ViewModelProvider.Factory)this.factory(helpCenterApi, place)).get(HelpCenterViewModel.class);
        }

        private final factory.1 factory(HelpCenterApi helpCenterApi, String metricContext) {
            return new ViewModelProvider.Factory(helpCenterApi, metricContext){
                final /* synthetic */ HelpCenterApi $helpCenterApi;
                final /* synthetic */ String $metricContext;
                {
                    this.$helpCenterApi = $helpCenterApi;
                    this.$metricContext = $metricContext;
                }

                @NotNull
                public <T extends ViewModel> T create(@NotNull Class<T> modelClass) {
                    Intrinsics.checkNotNullParameter(modelClass, (String)"modelClass");
                    AppConfig appConfig = Injector.get().getAppConfigProvider().get();
                    Intrinsics.checkNotNullExpressionValue((Object)appConfig, (String)"get().appConfigProvider.get()");
                    MetricTracker metricTracker = Injector.get().getMetricTracker();
                    Intrinsics.checkNotNullExpressionValue((Object)metricTracker, (String)"get().metricTracker");
                    return (T)((Object)new HelpCenterViewModel(this.$helpCenterApi, appConfig, metricTracker, this.$metricContext, null, null, null, null, 240, null));
                }
            };
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

