/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.blocks.messengercard;

import android.animation.LayoutTransition;
import android.annotation.SuppressLint;
import android.content.Context;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ProgressBar;
import com.google.gson.Gson;
import com.intercom.commons.utilities.HtmlCompat;
import com.squareup.otto.Bus;
import io.intercom.android.sdk.Provider;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.blocks.StyleType;
import io.intercom.android.sdk.blocks.lib.BlockAlignment;
import io.intercom.android.sdk.blocks.lib.interfaces.MessengerCardBlock;
import io.intercom.android.sdk.blocks.lib.models.BlockMetadata;
import io.intercom.android.sdk.blocks.messengercard.CardWebView;
import io.intercom.android.sdk.blocks.messengercard.MessengerCardWebViewPresenter;
import io.intercom.android.sdk.blocks.views.ParagraphView;
import io.intercom.android.sdk.identity.AppConfig;
import io.intercom.android.sdk.metrics.MetricTracker;
import io.intercom.android.sdk.utilities.ColorUtils;

public class MessengerCard
implements MessengerCardBlock {
    private final Provider<AppConfig> appConfigProvider;
    private final Gson gson;
    private final Bus bus;
    private final MetricTracker metricTracker;
    private final String conversationId;
    private final StyleType styleType;
    private final Context context;

    public MessengerCard(Provider<AppConfig> appConfigProvider2, Gson gson, Bus bus, MetricTracker metricTracker, String conversationId, StyleType styleType, Context context) {
        this.appConfigProvider = appConfigProvider2;
        this.gson = gson;
        this.bus = bus;
        this.metricTracker = metricTracker;
        this.conversationId = conversationId;
        this.styleType = styleType;
        this.context = context;
    }

    @Override
    @SuppressLint(value={"SetJavaScriptEnabled"})
    public View addCard(String text, String fallbackUrl, BlockMetadata blockMetadata, ViewGroup parent) {
        if (TextUtils.isEmpty((CharSequence)fallbackUrl)) {
            return this.textFallback(text, parent);
        }
        Context context = parent.getContext();
        LayoutInflater layoutInflater = LayoutInflater.from((Context)context);
        FrameLayout rootLayout = (FrameLayout)layoutInflater.inflate(R.layout.intercom_messenger_card_block, parent, false);
        LayoutTransition layoutTransition = rootLayout.getLayoutTransition();
        layoutTransition.enableTransitionType(4);
        ProgressBar loadingView = (ProgressBar)rootLayout.findViewById(R.id.loading_view);
        CardWebView webView = MessengerCardWebViewPresenter.createCardWebView(context);
        rootLayout.addView((View)webView);
        int primaryColor = ColorUtils.primaryOrDarkColor(webView.getContext(), this.appConfigProvider.get());
        MessengerCardWebViewPresenter presenter = new MessengerCardWebViewPresenter(webView, (View)loadingView, fallbackUrl, this.bus, primaryColor, this.gson, this.metricTracker, context.getCacheDir(), this.conversationId, false, context);
        presenter.setUpWebView();
        webView.loadUrl(fallbackUrl);
        return rootLayout;
    }

    private View textFallback(String text, ViewGroup parent) {
        ParagraphView textView = new ParagraphView(parent.getContext(), StyleType.ADMIN, BlockAlignment.LEFT, this.appConfigProvider.get());
        textView.setText((CharSequence)HtmlCompat.fromHtml((String)text));
        return textView;
    }
}

