/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.store;

import androidx.annotation.VisibleForTesting;
import io.intercom.android.sdk.UnreadConversationCountListener;
import io.intercom.android.sdk.state.State;
import io.intercom.android.sdk.store.Selectors;
import io.intercom.android.sdk.store.Store;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class UnreadCountTracker {
    @VisibleForTesting
    final Map<UnreadConversationCountListener, Store.Subscription> listeners = new ConcurrentHashMap<UnreadConversationCountListener, Store.Subscription>();
    private final Store<State> store;

    public UnreadCountTracker(Store<State> store2) {
        this.store = store2;
    }

    public void addListener(final UnreadConversationCountListener listener2) {
        Store.Subscriber<Integer> subscriber = new Store.Subscriber<Integer>(){

            @Override
            public void onStateChange(Integer unreadCount) {
                listener2.onCountUpdate(unreadCount);
            }
        };
        Store.Subscription subscription = this.store.subscribeToChanges(Selectors.UNREAD_COUNT, subscriber);
        this.listeners.put(listener2, subscription);
    }

    public void removeListener(UnreadConversationCountListener listener2) {
        if (this.listeners.containsKey(listener2)) {
            this.listeners.remove(listener2).unsubscribe();
        }
    }
}

