/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.models;

import androidx.annotation.Nullable;
import io.intercom.android.sdk.models.ArticleSuggestionModel;
import io.intercom.android.sdk.models.BaseResponse;
import io.intercom.android.sdk.models.Conversation;
import io.intercom.android.sdk.models.HomeCard;
import java.util.ArrayList;
import java.util.List;

public class HomeCardsResponse
extends BaseResponse {
    private final List<Conversation> conversations = new ArrayList<Conversation>();
    private final List<HomeCard> cards;
    private final List<String> openInboundConversationIds;
    private final List<ArticleSuggestionModel> articleSuggestions;
    private final boolean hasMoreConversations;

    HomeCardsResponse(Builder builder) {
        super(builder);
        if (builder.conversations != null) {
            for (Conversation.Builder conversationBuilder : builder.conversations) {
                this.conversations.add(conversationBuilder.build());
            }
        }
        this.cards = new ArrayList<HomeCard>();
        if (builder.cards != null) {
            this.cards.addAll(builder.cards);
        }
        this.openInboundConversationIds = new ArrayList<String>();
        this.articleSuggestions = new ArrayList<ArticleSuggestionModel>();
        if (builder.open_inbound_conversation_ids != null) {
            this.openInboundConversationIds.addAll(builder.open_inbound_conversation_ids);
        }
        if (builder.article_suggestions != null) {
            this.articleSuggestions.addAll(builder.article_suggestions);
        }
        this.hasMoreConversations = builder.has_more_conversations;
    }

    public List<Conversation> getConversations() {
        return this.conversations;
    }

    public List<HomeCard> getCards() {
        return this.cards;
    }

    public List<ArticleSuggestionModel> getArticleSuggestions() {
        return this.articleSuggestions;
    }

    public List<String> getOpenInboundConversationIds() {
        return this.openInboundConversationIds;
    }

    public boolean hasMoreConversations() {
        return this.hasMoreConversations;
    }

    public static class Builder
    extends BaseResponse.Builder {
        @Nullable
        List<Conversation.Builder> conversations;
        @Nullable
        List<HomeCard> cards;
        @Nullable
        List<String> open_inbound_conversation_ids;
        @Nullable
        List<ArticleSuggestionModel> article_suggestions;
        boolean has_more_conversations;

        @Override
        public HomeCardsResponse build() {
            return new HomeCardsResponse(this);
        }
    }
}

