/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.middleware;

import android.os.Handler;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import io.intercom.android.sdk.Provider;
import io.intercom.android.sdk.actions.Action;
import io.intercom.android.sdk.api.Api;
import io.intercom.android.sdk.models.Conversation;
import io.intercom.android.sdk.models.OperatorClientCondition;
import io.intercom.android.sdk.operator.OperatorClientConditionTimer;
import io.intercom.android.sdk.state.ActiveConversationState;
import io.intercom.android.sdk.state.State;
import io.intercom.android.sdk.store.Store;
import io.intercom.android.sdk.views.ClientConditionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class OperatorClientConditionsMiddleware
implements ClientConditionListener,
Store.Middleware<State> {
    private static final String USER_INTERACTION_CONDITION = "user_interaction_condition";
    @VisibleForTesting
    final Map<String, List<OperatorClientConditionTimer>> conversationConditions = new HashMap<String, List<OperatorClientConditionTimer>>();
    private final Provider<Api> apiProvider;
    private final Handler handler;

    public OperatorClientConditionsMiddleware(Provider<Api> apiProvider, Handler handler) {
        this.apiProvider = apiProvider;
        this.handler = handler;
    }

    @Override
    public void dispatch(Store<State> store2, Action<?> action, Store.NextDispatcher next) {
        next.dispatch(action);
        switch (action.type()) {
            case COMPOSER_TYPED_IN: 
            case COMPOSER_CLEARED: 
            case COMPOSER_INPUT_CHANGED: {
                this.interruptCondition(store2.state().activeConversationState().getConversationId());
                break;
            }
            case FETCH_CONVERSATION_SUCCESS: 
            case NEW_CONVERSATION_SUCCESS: {
                Conversation conversation = (Conversation)action.value();
                this.addClientConditionsForConversation(conversation.getId(), conversation.getOperatorClientConditions(), store2.state().activeConversationState());
                break;
            }
        }
    }

    private void addClientConditionsForConversation(String conversationId, List<OperatorClientCondition> newConditions, ActiveConversationState activeConversationState) {
        if (newConditions.isEmpty()) {
            return;
        }
        List<OperatorClientConditionTimer> existingConditions = this.conversationConditions.get(conversationId);
        if (existingConditions == null) {
            existingConditions = new ArrayList<OperatorClientConditionTimer>();
            this.conversationConditions.put(conversationId, existingConditions);
        }
        for (OperatorClientCondition condition : newConditions) {
            if (!USER_INTERACTION_CONDITION.equals(condition.conditionId())) continue;
            this.createOperatorClientConditionTimer(conversationId, activeConversationState, existingConditions, condition);
        }
    }

    private void createOperatorClientConditionTimer(String conversationId, ActiveConversationState activeConversationState, List<OperatorClientConditionTimer> existingConditions, OperatorClientCondition condition) {
        OperatorClientConditionTimer operatorClientConditionTimer = new OperatorClientConditionTimer(conversationId, condition.id(), this.handler, this);
        existingConditions.add(operatorClientConditionTimer);
        operatorClientConditionTimer.beginCountdown();
        if (this.userHasInteractedWithConversation(conversationId, activeConversationState)) {
            operatorClientConditionTimer.interrupt();
        }
    }

    private boolean userHasInteractedWithConversation(String conversationId, ActiveConversationState activeConversationState) {
        return activeConversationState.getConversationId().equals(conversationId) && (activeConversationState.hasSwitchedInputType() || activeConversationState.hasTextInComposer());
    }

    private void interruptCondition(@Nullable String conversationId) {
        List<OperatorClientConditionTimer> conditions = this.conversationConditions.get(conversationId);
        if (conditions != null) {
            for (OperatorClientConditionTimer condition : conditions) {
                condition.interrupt();
            }
        }
    }

    @Override
    public void conditionSatisfied(String conversationId, String condition) {
        List<OperatorClientConditionTimer> conditions = this.conversationConditions.get(conversationId);
        Iterator<OperatorClientConditionTimer> iterator = conditions.iterator();
        while (iterator.hasNext()) {
            OperatorClientConditionTimer operatorClientConditionTimer = iterator.next();
            if (!operatorClientConditionTimer.getCondition().equals(condition)) continue;
            iterator.remove();
        }
        this.apiProvider.get().satisfyOperatorCondition(conversationId, condition);
    }
}

