/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.m5.conversation.usecase;

import com.intercom.commons.utilities.TimeProvider;
import io.intercom.android.sdk.Injector;
import io.intercom.android.sdk.blocks.BlockFactory;
import io.intercom.android.sdk.blocks.lib.models.Block;
import io.intercom.android.sdk.blocks.logic.TextSplittingStrategy;
import io.intercom.android.sdk.helpcenter.utils.networking.NetworkResponse;
import io.intercom.android.sdk.identity.UserIdentity;
import io.intercom.android.sdk.m5.conversation.data.ConversationRepository;
import io.intercom.android.sdk.m5.conversation.states.ConversationClientState;
import io.intercom.android.sdk.m5.conversation.states.PendingMessage;
import io.intercom.android.sdk.m5.conversation.usecase.Action;
import io.intercom.android.sdk.m5.conversation.usecase.RefreshConversationUseCase;
import io.intercom.android.sdk.m5.conversation.usecase.SendMessageUseCase;
import io.intercom.android.sdk.m5.conversation.usecase.SoundEffectsUseCase;
import io.intercom.android.sdk.m5.data.IntercomDataLayer;
import io.intercom.android.sdk.m5.data.IntercomEffect;
import io.intercom.android.sdk.models.BotIntro;
import io.intercom.android.sdk.models.ConversationResponse;
import io.intercom.android.sdk.models.Part;
import io.intercom.android.sdk.models.Participant;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.flow.MutableStateFlow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dBE\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u0012\b\b\u0002\u0010\f\u001a\u00020\r\u0012\b\b\u0002\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J'\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u0016\u001a\u00020\rH\u0086B\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0017J7\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\b\b\u0002\u0010\u001b\u001a\u00020\rH\u0086B\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001cR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u001e"}, d2={"Lio/intercom/android/sdk/m5/conversation/usecase/SendMessageUseCase;", "", "conversationRepository", "Lio/intercom/android/sdk/m5/conversation/data/ConversationRepository;", "refreshConversationUseCase", "Lio/intercom/android/sdk/m5/conversation/usecase/RefreshConversationUseCase;", "soundEffectsUseCase", "Lio/intercom/android/sdk/m5/conversation/usecase/SoundEffectsUseCase;", "botIntro", "Lio/intercom/android/sdk/models/BotIntro;", "userIdentity", "Lio/intercom/android/sdk/identity/UserIdentity;", "botBehaviourId", "", "intercomDataLayer", "Lio/intercom/android/sdk/m5/data/IntercomDataLayer;", "(Lio/intercom/android/sdk/m5/conversation/data/ConversationRepository;Lio/intercom/android/sdk/m5/conversation/usecase/RefreshConversationUseCase;Lio/intercom/android/sdk/m5/conversation/usecase/SoundEffectsUseCase;Lio/intercom/android/sdk/models/BotIntro;Lio/intercom/android/sdk/identity/UserIdentity;Ljava/lang/String;Lio/intercom/android/sdk/m5/data/IntercomDataLayer;)V", "invoke", "", "clientState", "Lkotlinx/coroutines/flow/MutableStateFlow;", "Lio/intercom/android/sdk/m5/conversation/states/ConversationClientState;", "messageText", "(Lkotlinx/coroutines/flow/MutableStateFlow;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "blocks", "", "Lio/intercom/android/sdk/blocks/lib/models/Block$Builder;", "clientUUID", "(Lkotlinx/coroutines/flow/MutableStateFlow;Ljava/util/List;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Companion", "intercom-sdk-base_release"})
@SourceDebugExtension(value={"SMAP\nSendMessageUseCase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SendMessageUseCase.kt\nio/intercom/android/sdk/m5/conversation/usecase/SendMessageUseCase\n+ 2 StateFlow.kt\nkotlinx/coroutines/flow/StateFlowKt\n*L\n1#1,161:1\n230#2,5:162\n*S KotlinDebug\n*F\n+ 1 SendMessageUseCase.kt\nio/intercom/android/sdk/m5/conversation/usecase/SendMessageUseCase\n*L\n78#1:162,5\n*E\n"})
public final class SendMessageUseCase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ConversationRepository conversationRepository;
    @NotNull
    private final RefreshConversationUseCase refreshConversationUseCase;
    @NotNull
    private final SoundEffectsUseCase soundEffectsUseCase;
    @NotNull
    private final BotIntro botIntro;
    @NotNull
    private final UserIdentity userIdentity;
    @NotNull
    private final String botBehaviourId;
    @NotNull
    private final IntercomDataLayer intercomDataLayer;

    public SendMessageUseCase(@NotNull ConversationRepository conversationRepository, @NotNull RefreshConversationUseCase refreshConversationUseCase, @NotNull SoundEffectsUseCase soundEffectsUseCase, @NotNull BotIntro botIntro, @NotNull UserIdentity userIdentity, @NotNull String botBehaviourId, @NotNull IntercomDataLayer intercomDataLayer) {
        Intrinsics.checkNotNullParameter((Object)conversationRepository, (String)"conversationRepository");
        Intrinsics.checkNotNullParameter((Object)refreshConversationUseCase, (String)"refreshConversationUseCase");
        Intrinsics.checkNotNullParameter((Object)soundEffectsUseCase, (String)"soundEffectsUseCase");
        Intrinsics.checkNotNullParameter((Object)botIntro, (String)"botIntro");
        Intrinsics.checkNotNullParameter((Object)userIdentity, (String)"userIdentity");
        Intrinsics.checkNotNullParameter((Object)botBehaviourId, (String)"botBehaviourId");
        Intrinsics.checkNotNullParameter((Object)intercomDataLayer, (String)"intercomDataLayer");
        this.conversationRepository = conversationRepository;
        this.refreshConversationUseCase = refreshConversationUseCase;
        this.soundEffectsUseCase = soundEffectsUseCase;
        this.botIntro = botIntro;
        this.userIdentity = userIdentity;
        this.botBehaviourId = botBehaviourId;
        this.intercomDataLayer = intercomDataLayer;
    }

    public /* synthetic */ SendMessageUseCase(ConversationRepository conversationRepository, RefreshConversationUseCase refreshConversationUseCase, SoundEffectsUseCase soundEffectsUseCase, BotIntro botIntro, UserIdentity userIdentity, String string2, IntercomDataLayer intercomDataLayer, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            botIntro = Injector.get().getStore().state().botIntroState().getBotIntro();
        }
        if ((n & 0x10) != 0) {
            UserIdentity userIdentity2 = Injector.get().getUserIdentity();
            Intrinsics.checkNotNullExpressionValue((Object)userIdentity2, (String)"get().userIdentity");
            userIdentity = userIdentity2;
        }
        if ((n & 0x20) != 0) {
            String string3 = Injector.get().getStore().state().botBehaviourId();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"get().store.state().botBehaviourId()");
            string2 = string3;
        }
        if ((n & 0x40) != 0) {
            intercomDataLayer = IntercomDataLayer.INSTANCE;
        }
        this(conversationRepository, refreshConversationUseCase, soundEffectsUseCase, botIntro, userIdentity, string2, intercomDataLayer);
    }

    @Nullable
    public final Object invoke(@NotNull MutableStateFlow<ConversationClientState> clientState, @NotNull String messageText, @NotNull Continuation<? super Unit> $completion) {
        BlockFactory blockFactory = new BlockFactory(new TextSplittingStrategy());
        List<Block.Builder> blocks = blockFactory.getBlocksForText(((Object)StringsKt.trim((CharSequence)messageText)).toString());
        Intrinsics.checkNotNullExpressionValue(blocks, (String)"blocks");
        Object object = SendMessageUseCase.invoke$default(this, clientState, blocks, null, $completion, 4, null);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object invoke(@NotNull MutableStateFlow<ConversationClientState> var1_1, @NotNull List<Block.Builder> var2_2, @NotNull String var3_3, @NotNull Continuation<? super Unit> var4_4) {
        block16: {
            if (!(var4_4 instanceof invoke.2)) ** GOTO lbl-1000
            var19_5 = var4_4;
            if ((var19_5.label & -2147483648) != 0) {
                var19_5.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, var4_4){
                    Object L$0;
                    Object L$1;
                    Object L$2;
                    /* synthetic */ Object result;
                    final /* synthetic */ SendMessageUseCase this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return this.this$0.invoke(null, null, null, (Continuation<? super Unit>)((Continuation)this));
                    }
                };
            }
            $result = $continuation.result;
            var20_7 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    SendMessageUseCase.Companion.addBlocksToPendingMessages((MutableStateFlow<ConversationClientState>)clientState, (List<Block.Builder>)blocks, clientUUID, this.userIdentity);
                    if (((ConversationClientState)clientState.getValue()).getConversationId() != null) break;
                    botIntroId = Intrinsics.areEqual((Object)BotIntro.BOT_INTRO_NULL, (Object)this.botIntro) == false ? this.botIntro.getId() : null;
                    $continuation.L$0 = this;
                    $continuation.L$1 = clientState;
                    $continuation.L$2 = clientUUID;
                    $continuation.label = 1;
                    v0 = this.conversationRepository.createNewConversation((List<Block.Builder>)blocks, botIntroId, ((ConversationClientState)clientState.getValue()).getArticleId(), this.botBehaviourId, (Continuation<? super NetworkResponse<ConversationResponse.Builder>>)$continuation);
                    if (v0 == var20_7) {
                        return var20_7;
                    }
                    ** GOTO lbl29
                }
                case 1: {
                    clientUUID = (String)$continuation.L$2;
                    clientState = (MutableStateFlow)$continuation.L$1;
                    this = (SendMessageUseCase)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl29:
                    // 2 sources

                    response = (NetworkResponse)v0;
                    if ((response instanceof NetworkResponse.ClientError != false ? true : response instanceof NetworkResponse.NetworkError) != false ? true : response instanceof NetworkResponse.ServerError) {
                        this.soundEffectsUseCase.invoke$intercom_sdk_base_release(Action.MESSAGE_FAILED);
                        SendMessageUseCase.Companion.updateFailedPendingMessages((MutableStateFlow<ConversationClientState>)clientState, clientUUID);
                        break;
                    }
                    if (!(response instanceof NetworkResponse.Success)) break;
                    this.soundEffectsUseCase.invoke$intercom_sdk_base_release(Action.MESSAGE_SENT);
                    conversationResponse = ((ConversationResponse.Builder)((NetworkResponse.Success)response).getBody()).build();
                    $continuation.L$0 = clientState;
                    $continuation.L$1 = clientUUID;
                    $continuation.L$2 = conversationResponse;
                    $continuation.label = 2;
                    v1 = this.intercomDataLayer.emitEffect(new IntercomEffect.NewConversation(conversationResponse.getConversation()), (Continuation<? super Unit>)$continuation);
                    if (v1 == var20_7) {
                        return var20_7;
                    }
                    ** GOTO lbl52
                }
                case 2: {
                    conversationResponse = (ConversationResponse)$continuation.L$2;
                    clientUUID = (String)$continuation.L$1;
                    clientState = (MutableStateFlow)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v1 = $result;
lbl52:
                    // 2 sources

                    $this$update$iv = clientState;
                    $i$f$update = false;
                    do {
                        prevValue$iv = $this$update$iv.getValue();
                        it = (ConversationClientState)prevValue$iv;
                        $i$a$-update-SendMessageUseCase$invoke$3 = false;
                        var14_23 = var13_22 = MapsKt.toMutableMap(((ConversationClientState)clientState.getValue()).getPendingMessages());
                        var15_24 = it;
                        $i$a$-apply-SendMessageUseCase$invoke$3$1 = false;
                        $this$invoke_u24lambda_u241_u24lambda_u240.remove(clientUUID);
                    } while (!$this$update$iv.compareAndSet(prevValue$iv, (Object)(nextValue$iv = ConversationClientState.copy$default(var15_24, var13_22, conversationResponse.getConversation(), conversationResponse.getConversation().getId(), null, null, false, null, null, null, null, 1016, null))));
                    break;
                }
            }
            v2 = ((ConversationClientState)clientState.getValue()).getConversationId();
            if (v2 == null) break block16;
            conversationId = v2;
            $i$a$-let-SendMessageUseCase$invoke$4 = false;
            $continuation.L$0 = this;
            $continuation.L$1 = clientState;
            $continuation.L$2 = clientUUID;
            $continuation.label = 3;
            v3 = this.conversationRepository.replyToConversation(conversationId, clientUUID, (List<Block.Builder>)blocks, (Continuation<? super NetworkResponse<Part.Builder>>)$continuation);
            if (v3 == var20_7) {
                return var20_7;
            }
            ** GOTO lbl87
            {
                case 3: {
                    $i$a$-let-SendMessageUseCase$invoke$4 = false;
                    clientUUID = (String)$continuation.L$2;
                    clientState = (MutableStateFlow)$continuation.L$1;
                    this = (SendMessageUseCase)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v3 = $result;
lbl87:
                    // 2 sources

                    if (((var10_19 = (response = (NetworkResponse)v3)) instanceof NetworkResponse.ClientError != false ? true : var10_19 instanceof NetworkResponse.NetworkError) != false ? true : var10_19 instanceof NetworkResponse.ServerError) {
                        this.soundEffectsUseCase.invoke$intercom_sdk_base_release(Action.MESSAGE_FAILED);
                        SendMessageUseCase.Companion.updateFailedPendingMessages((MutableStateFlow<ConversationClientState>)clientState, clientUUID);
                        break;
                    }
                    if (!(var10_19 instanceof NetworkResponse.Success)) break;
                    this.soundEffectsUseCase.invoke$intercom_sdk_base_release(Action.MESSAGE_SENT);
                    $continuation.L$0 = null;
                    $continuation.L$1 = null;
                    $continuation.L$2 = null;
                    $continuation.label = 4;
                    v4 = this.refreshConversationUseCase.invoke((MutableStateFlow<ConversationClientState>)clientState, (Continuation<? super Unit>)$continuation);
                    if (v4 == var20_7) {
                        return var20_7;
                    }
                    break;
                }
                case 4: {
                    $i$a$-let-SendMessageUseCase$invoke$4 = false;
                    ResultKt.throwOnFailure((Object)$result);
                    v4 = $result;
                }
            }
        }
        return Unit.INSTANCE;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public static /* synthetic */ Object invoke$default(SendMessageUseCase sendMessageUseCase, MutableStateFlow mutableStateFlow, List list, String string2, Continuation continuation, int n, Object object) {
        if ((n & 4) != 0) {
            String string3 = UUID.randomUUID().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"randomUUID().toString()");
            string2 = string3;
        }
        return sendMessageUseCase.invoke((MutableStateFlow<ConversationClientState>)mutableStateFlow, list, string2, (Continuation<? super Unit>)continuation);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J2\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u001c\u0010\u000f\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\u0010\u001a\u00020\f\u00a8\u0006\u0011"}, d2={"Lio/intercom/android/sdk/m5/conversation/usecase/SendMessageUseCase$Companion;", "", "()V", "addBlocksToPendingMessages", "", "clientState", "Lkotlinx/coroutines/flow/MutableStateFlow;", "Lio/intercom/android/sdk/m5/conversation/states/ConversationClientState;", "blocks", "", "Lio/intercom/android/sdk/blocks/lib/models/Block$Builder;", "uuid", "", "userIdentity", "Lio/intercom/android/sdk/identity/UserIdentity;", "updateFailedPendingMessages", "clientUUID", "intercom-sdk-base_release"})
    @SourceDebugExtension(value={"SMAP\nSendMessageUseCase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SendMessageUseCase.kt\nio/intercom/android/sdk/m5/conversation/usecase/SendMessageUseCase$Companion\n+ 2 StateFlow.kt\nkotlinx/coroutines/flow/StateFlowKt\n*L\n1#1,161:1\n230#2,5:162\n230#2,5:167\n*S KotlinDebug\n*F\n+ 1 SendMessageUseCase.kt\nio/intercom/android/sdk/m5/conversation/usecase/SendMessageUseCase$Companion\n*L\n132#1:162,5\n146#1:167,5\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        public final void addBlocksToPendingMessages(@NotNull MutableStateFlow<ConversationClientState> clientState, @NotNull List<Block.Builder> blocks, @NotNull String uuid, @NotNull UserIdentity userIdentity) {
            LinkedHashMap linkedHashMap;
            ConversationClientState conversationClientState;
            ConversationClientState nextValue$iv;
            Object prevValue$iv;
            Part part;
            Intrinsics.checkNotNullParameter(clientState, (String)"clientState");
            Intrinsics.checkNotNullParameter(blocks, (String)"blocks");
            Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
            Intrinsics.checkNotNullParameter((Object)userIdentity, (String)"userIdentity");
            Part $this$addBlocksToPendingMessages_u24lambda_u240 = part = new Part.Builder().withBlocks(blocks).withCreatedAt(TimeUnit.MILLISECONDS.toSeconds(TimeProvider.SYSTEM.currentTimeMillis())).withParticipantIsAdmin(false).withClientAssignedUuid(uuid).build();
            boolean bl = false;
            $this$addBlocksToPendingMessages_u24lambda_u240.setParticipant(new Participant.Builder().withId(userIdentity.getIntercomId()).build());
            $this$addBlocksToPendingMessages_u24lambda_u240.setMessageState(Part.MessageState.SENDING);
            Part part2 = part;
            MutableStateFlow<ConversationClientState> $this$update$iv = clientState;
            boolean $i$f$update = false;
            do {
                void $this$addBlocksToPendingMessages_u24lambda_u242_u24lambda_u241;
                prevValue$iv = $this$update$iv.getValue();
                ConversationClientState it = (ConversationClientState)prevValue$iv;
                boolean bl2 = false;
                LinkedHashMap linkedHashMap2 = linkedHashMap = new LinkedHashMap();
                conversationClientState = it;
                boolean bl3 = false;
                $this$addBlocksToPendingMessages_u24lambda_u242_u24lambda_u241.putAll(it.getPendingMessages());
                Intrinsics.checkNotNullExpressionValue((Object)part2, (String)"part");
                $this$addBlocksToPendingMessages_u24lambda_u242_u24lambda_u241.put(uuid, new PendingMessage(part2, false, null, 4, null));
            } while (!$this$update$iv.compareAndSet(prevValue$iv, (Object)(nextValue$iv = ConversationClientState.copy$default(conversationClientState, linkedHashMap, null, null, null, null, false, null, null, null, null, 1022, null))));
        }

        /*
         * WARNING - void declaration
         */
        public final void updateFailedPendingMessages(@NotNull MutableStateFlow<ConversationClientState> clientState, @NotNull String clientUUID) {
            Map map2;
            ConversationClientState conversationClientState;
            ConversationClientState nextValue$iv;
            Object prevValue$iv;
            Intrinsics.checkNotNullParameter(clientState, (String)"clientState");
            Intrinsics.checkNotNullParameter((Object)clientUUID, (String)"clientUUID");
            MutableStateFlow<ConversationClientState> $this$update$iv = clientState;
            boolean $i$f$update = false;
            do {
                void $this$updateFailedPendingMessages_u24lambda_u244_u24lambda_u243;
                prevValue$iv = $this$update$iv.getValue();
                ConversationClientState it = (ConversationClientState)prevValue$iv;
                boolean bl = false;
                Map map3 = map2 = MapsKt.toMutableMap(((ConversationClientState)clientState.getValue()).getPendingMessages());
                conversationClientState = it;
                boolean bl2 = false;
                Object v = $this$updateFailedPendingMessages_u24lambda_u244_u24lambda_u243.get(clientUUID);
                Intrinsics.checkNotNull(v);
                PendingMessage pendingMessage = (PendingMessage)v;
                PendingMessage failedPendingMessage = PendingMessage.copy$default(pendingMessage, null, true, null, 5, null);
                $this$updateFailedPendingMessages_u24lambda_u244_u24lambda_u243.put(clientUUID, failedPendingMessage);
            } while (!$this$update$iv.compareAndSet(prevValue$iv, (Object)(nextValue$iv = ConversationClientState.copy$default(conversationClientState, map2, null, null, null, null, false, null, null, null, null, 1022, null))));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

