/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.inbox;

import androidx.lifecycle.ViewModel;
import androidx.lifecycle.ViewModelKt;
import androidx.lifecycle.ViewModelProvider;
import androidx.lifecycle.ViewModelStoreOwner;
import com.squareup.otto.Bus;
import com.squareup.otto.Subscribe;
import io.intercom.android.sdk.Injector;
import io.intercom.android.sdk.helpcenter.utils.networking.NetworkResponse;
import io.intercom.android.sdk.identity.AppConfig;
import io.intercom.android.sdk.inbox.InboxRepository;
import io.intercom.android.sdk.inbox.InboxScreenEffects;
import io.intercom.android.sdk.inbox.InboxScreenState;
import io.intercom.android.sdk.inbox.IntercomInboxViewModel;
import io.intercom.android.sdk.inbox.IntercomInboxViewModelKt;
import io.intercom.android.sdk.m5.components.ErrorState;
import io.intercom.android.sdk.m5.data.IntercomDataLayer;
import io.intercom.android.sdk.models.ActionType;
import io.intercom.android.sdk.models.Conversation;
import io.intercom.android.sdk.models.ConversationsResponse;
import io.intercom.android.sdk.models.EmptyState;
import io.intercom.android.sdk.models.events.ConversationEvent;
import io.intercom.android.sdk.utilities.extensions.AppConfigExtensionsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineDispatcher;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableSharedFlow;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.SharedFlow;
import kotlinx.coroutines.flow.SharedFlowKt;
import kotlinx.coroutines.flow.SharingStarted;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0000\u0018\u0000 .2\u00020\u0001:\u0001.B7\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u001c\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cH\u0002J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0007J\u0017\u0010#\u001a\u00020 2\n\b\u0002\u0010$\u001a\u0004\u0018\u00010%\u00a2\u0006\u0002\u0010&J\u000e\u0010'\u001a\u00020 2\u0006\u0010$\u001a\u00020%J\b\u0010(\u001a\u00020 H\u0014J\u000e\u0010)\u001a\u00020 2\u0006\u0010*\u001a\u00020\u001dJ\u0006\u0010+\u001a\u00020 J\b\u0010,\u001a\u00020-H\u0002R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00120\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006/"}, d2={"Lio/intercom/android/sdk/inbox/IntercomInboxViewModel;", "Landroidx/lifecycle/ViewModel;", "inboxRepository", "Lio/intercom/android/sdk/inbox/InboxRepository;", "dispatcher", "Lkotlinx/coroutines/CoroutineDispatcher;", "bus", "Lcom/squareup/otto/Bus;", "intercomDataLayer", "Lio/intercom/android/sdk/m5/data/IntercomDataLayer;", "appConfig", "Lio/intercom/android/sdk/identity/AppConfig;", "(Lio/intercom/android/sdk/inbox/InboxRepository;Lkotlinx/coroutines/CoroutineDispatcher;Lcom/squareup/otto/Bus;Lio/intercom/android/sdk/m5/data/IntercomDataLayer;Lio/intercom/android/sdk/identity/AppConfig;)V", "_effect", "Lkotlinx/coroutines/flow/MutableSharedFlow;", "Lio/intercom/android/sdk/inbox/InboxScreenEffects;", "_state", "Lkotlinx/coroutines/flow/MutableStateFlow;", "Lio/intercom/android/sdk/inbox/InboxScreenState;", "effect", "Lkotlinx/coroutines/flow/SharedFlow;", "getEffect", "()Lkotlinx/coroutines/flow/SharedFlow;", "uiState", "Lkotlinx/coroutines/flow/StateFlow;", "getUiState", "()Lkotlinx/coroutines/flow/StateFlow;", "combineConversations", "", "Lio/intercom/android/sdk/models/Conversation;", "newConversations", "conversationSuccess", "", "event", "Lio/intercom/android/sdk/models/events/ConversationEvent;", "fetchInboxData", "before", "", "(Ljava/lang/Long;)V", "fetchMoreInboxDataIfAvailable", "onCleared", "onConversationClick", "it", "onRetryClicked", "shouldShowSendMessageButton", "", "Companion", "intercom-sdk-base_release"})
@SourceDebugExtension(value={"SMAP\nIntercomInboxViewModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IntercomInboxViewModel.kt\nio/intercom/android/sdk/inbox/IntercomInboxViewModel\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,198:1\n1054#2:199\n1655#2,8:200\n*S KotlinDebug\n*F\n+ 1 IntercomInboxViewModel.kt\nio/intercom/android/sdk/inbox/IntercomInboxViewModel\n*L\n137#1:199\n138#1:200,8\n*E\n"})
public final class IntercomInboxViewModel
extends ViewModel {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final InboxRepository inboxRepository;
    @NotNull
    private final CoroutineDispatcher dispatcher;
    @NotNull
    private final Bus bus;
    @NotNull
    private final IntercomDataLayer intercomDataLayer;
    @NotNull
    private final AppConfig appConfig;
    @NotNull
    private final MutableStateFlow<InboxScreenState> _state;
    @NotNull
    private final StateFlow<InboxScreenState> uiState;
    @NotNull
    private final MutableSharedFlow<InboxScreenEffects> _effect;
    @NotNull
    private final SharedFlow<InboxScreenEffects> effect;

    public IntercomInboxViewModel(@NotNull InboxRepository inboxRepository, @NotNull CoroutineDispatcher dispatcher, @NotNull Bus bus, @NotNull IntercomDataLayer intercomDataLayer, @NotNull AppConfig appConfig) {
        Intrinsics.checkNotNullParameter((Object)inboxRepository, (String)"inboxRepository");
        Intrinsics.checkNotNullParameter((Object)dispatcher, (String)"dispatcher");
        Intrinsics.checkNotNullParameter((Object)bus, (String)"bus");
        Intrinsics.checkNotNullParameter((Object)intercomDataLayer, (String)"intercomDataLayer");
        Intrinsics.checkNotNullParameter((Object)appConfig, (String)"appConfig");
        this.inboxRepository = inboxRepository;
        this.dispatcher = dispatcher;
        this.bus = bus;
        this.intercomDataLayer = intercomDataLayer;
        this.appConfig = appConfig;
        this._state = StateFlowKt.MutableStateFlow((Object)InboxScreenState.Initial.INSTANCE);
        this.uiState = FlowKt.asStateFlow(this._state);
        this._effect = SharedFlowKt.MutableSharedFlow$default((int)0, (int)0, null, (int)7, null);
        this.effect = FlowKt.shareIn$default((Flow)((Flow)this._effect), (CoroutineScope)ViewModelKt.getViewModelScope((ViewModel)this), (SharingStarted)SharingStarted.Companion.getEagerly(), (int)0, (int)4, null);
        this._state.setValue((Object)InboxScreenState.Loading.INSTANCE);
        this.bus.register((Object)this);
    }

    public /* synthetic */ IntercomInboxViewModel(InboxRepository inboxRepository, CoroutineDispatcher coroutineDispatcher, Bus bus, IntercomDataLayer intercomDataLayer, AppConfig appConfig, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            inboxRepository = new InboxRepository(null, 1, null);
        }
        if ((n & 2) != 0) {
            coroutineDispatcher = Dispatchers.getIO();
        }
        if ((n & 4) != 0) {
            Bus bus2 = Injector.get().getBus();
            Intrinsics.checkNotNullExpressionValue((Object)bus2, (String)"get().bus");
            bus = bus2;
        }
        if ((n & 8) != 0) {
            intercomDataLayer = IntercomDataLayer.INSTANCE;
        }
        if ((n & 0x10) != 0) {
            AppConfig appConfig2 = Injector.get().getAppConfigProvider().get();
            Intrinsics.checkNotNullExpressionValue((Object)appConfig2, (String)"get().appConfigProvider.get()");
            appConfig = appConfig2;
        }
        this(inboxRepository, coroutineDispatcher, bus, intercomDataLayer, appConfig);
    }

    @NotNull
    public final StateFlow<InboxScreenState> getUiState() {
        return this.uiState;
    }

    @NotNull
    public final SharedFlow<InboxScreenEffects> getEffect() {
        return this.effect;
    }

    public final void fetchInboxData(@Nullable Long before) {
        BuildersKt.launch$default((CoroutineScope)ViewModelKt.getViewModelScope((ViewModel)this), (CoroutineContext)((CoroutineContext)this.dispatcher), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, before, null){
            int label;
            final /* synthetic */ IntercomInboxViewModel this$0;
            final /* synthetic */ Long $before;
            {
                this.this$0 = $receiver;
                this.$before = $before;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var7_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        this.label = 1;
                        v0 = IntercomInboxViewModel.access$getInboxRepository$p(this.this$0).getConversations(this.$before, (Continuation<? super NetworkResponse<ConversationsResponse.Builder>>)((Continuation)this));
                        if (v0 == var7_2) {
                            return var7_2;
                        }
                        ** GOTO lbl13
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl13:
                        // 2 sources

                        if ((networkResponse = (NetworkResponse)v0) instanceof NetworkResponse.ClientError != false ? true : networkResponse instanceof NetworkResponse.ServerError) {
                            v1 = new InboxScreenState.Error(new ErrorState.WithoutCTA(0, 0, null, 7, null));
                        } else if (networkResponse instanceof NetworkResponse.NetworkError) {
                            v1 = new InboxScreenState.Error(new ErrorState.WithCTA(0, 0, null, 0, (Function0)new Function0<Unit>(this.this$0){
                                final /* synthetic */ IntercomInboxViewModel this$0;
                                {
                                    this.this$0 = $receiver;
                                    super(0);
                                }

                                public final void invoke() {
                                    this.this$0.onRetryClicked();
                                }
                            }, 15, null));
                        } else if (networkResponse instanceof NetworkResponse.Success) {
                            response = ((ConversationsResponse.Builder)((NetworkResponse.Success)networkResponse).getBody()).build();
                            IntercomInboxViewModel.access$getAppConfig$p(this.this$0).update(response.getConfig(), IntercomInboxViewModel.access$getBus$p(this.this$0));
                            conversationPage = response.getConversationPage();
                            if (this.$before == null) {
                                v2 = conversationPage.getConversations();
                            } else {
                                v3 = conversationPage.getConversations();
                                Intrinsics.checkNotNullExpressionValue(v3, (String)"conversationPage.conversations");
                                v2 = IntercomInboxViewModel.access$combineConversations(this.this$0, v3);
                            }
                            allConversations = v2;
                            v4 = IntercomInboxViewModel.access$getIntercomDataLayer$p(this.this$0);
                            Intrinsics.checkNotNullExpressionValue((Object)allConversations, (String)"allConversations");
                            v4.addConversations(allConversations);
                            if (!Intrinsics.areEqual((Object)conversationPage.getEmptyState(), (Object)EmptyState.Companion.getNULL())) {
                                v5 = conversationPage.getEmptyState();
                                Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"conversationPage.emptyState");
                                v1 = new InboxScreenState.Empty(v5, conversationPage.getEmptyState().getAction().getType() == ActionType.MESSAGE ? IntercomInboxViewModel.access$shouldShowSendMessageButton(this.this$0) : true);
                            } else {
                                v1 = new InboxScreenState.Content(allConversations, IntercomInboxViewModel.access$shouldShowSendMessageButton(this.this$0), conversationPage.hasMorePages());
                            }
                        } else {
                            throw new NoWhenBranchMatchedException();
                        }
                        newState = v1;
                        IntercomInboxViewModel.access$get_state$p(this.this$0).setValue((Object)newState);
                        if (newState instanceof InboxScreenState.Content && this.$before == null) {
                            this.label = 2;
                            v6 = IntercomInboxViewModel.access$get_effect$p(this.this$0).emit((Object)InboxScreenEffects.ScrollToTop.INSTANCE, (Continuation)this);
                            if (v6 == var7_2) {
                                return var7_2;
                            }
                        }
                        ** GOTO lbl52
                    }
                    case 2: {
                        ResultKt.throwOnFailure((Object)$result);
                        v6 = $result;
lbl52:
                        // 2 sources

                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    public static /* synthetic */ void fetchInboxData$default(IntercomInboxViewModel intercomInboxViewModel, Long l, int n, Object object) {
        if ((n & 1) != 0) {
            l = null;
        }
        intercomInboxViewModel.fetchInboxData(l);
    }

    public final void fetchMoreInboxDataIfAvailable(long before) {
        InboxScreenState currentState = (InboxScreenState)this._state.getValue();
        if (currentState instanceof InboxScreenState.Content && ((InboxScreenState.Content)currentState).getMoreConversationsAvailable()) {
            this.fetchInboxData(before);
        }
    }

    public final void onRetryClicked() {
        this._state.setValue((Object)InboxScreenState.Loading.INSTANCE);
        IntercomInboxViewModel.fetchInboxData$default(this, null, 1, null);
    }

    @Subscribe
    public final void conversationSuccess(@NotNull ConversationEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        InboxScreenState currentState = (InboxScreenState)this._state.getValue();
        if (currentState instanceof InboxScreenState.Content) {
            this._state.setValue((Object)new InboxScreenState.Content(this.combineConversations(CollectionsKt.listOf((Object)event.getResponse())), ((InboxScreenState.Content)currentState).getShowSendMessageFab(), ((InboxScreenState.Content)currentState).getMoreConversationsAvailable()));
            BuildersKt.launch$default((CoroutineScope)ViewModelKt.getViewModelScope((ViewModel)this), (CoroutineContext)((CoroutineContext)this.dispatcher), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                int label;
                final /* synthetic */ IntercomInboxViewModel this$0;
                {
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            this.label = 1;
                            Object object3 = IntercomInboxViewModel.access$get_effect$p(this.this$0).emit((Object)InboxScreenEffects.ScrollToTop.INSTANCE, (Continuation)this);
                            if (object3 != object2) return Unit.INSTANCE;
                            return object2;
                        }
                        case 1: {
                            void $result;
                            ResultKt.throwOnFailure((Object)$result);
                            Object object3 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)2, null);
        }
    }

    public final void onConversationClick(@NotNull Conversation it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        BuildersKt.launch$default((CoroutineScope)ViewModelKt.getViewModelScope((ViewModel)this), (CoroutineContext)((CoroutineContext)this.dispatcher), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, it, null){
            int label;
            final /* synthetic */ IntercomInboxViewModel this$0;
            final /* synthetic */ Conversation $it;
            {
                this.this$0 = $receiver;
                this.$it = $it;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = IntercomInboxViewModel.access$get_effect$p(this.this$0).emit((Object)new InboxScreenEffects.NavigateToConversation(this.$it), (Continuation)this);
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    private final List<Conversation> combineConversations(List<? extends Conversation> newConversations) {
        Object object = this._state.getValue();
        Object object2 = object instanceof InboxScreenState.Content ? (InboxScreenState.Content)object : null;
        if (object2 == null || (object2 = ((InboxScreenState.Content)object2).getInboxConversations()) == null) {
            object2 = CollectionsKt.emptyList();
        }
        Object currentConversations = object2;
        Iterable $this$sortedByDescending$iv = CollectionsKt.plus((Collection)((Collection)currentConversations), (Iterable)newConversations);
        boolean $i$f$sortedByDescending = false;
        Iterable $this$distinctBy$iv = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Conversation it = (Conversation)b;
                boolean bl = false;
                Comparable comparable = Long.valueOf(IntercomInboxViewModelKt.lastActionCreatedAt(it));
                it = (Conversation)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Long.valueOf(IntercomInboxViewModelKt.lastActionCreatedAt(it)));
            }
        });
        boolean $i$f$distinctBy = false;
        HashSet<String> set$iv = new HashSet<String>();
        ArrayList list$iv = new ArrayList();
        for (Object e$iv : $this$distinctBy$iv) {
            Conversation it = (Conversation)e$iv;
            boolean bl = false;
            String key$iv = it.getId();
            if (!set$iv.add(key$iv)) continue;
            list$iv.add(e$iv);
        }
        return list$iv;
    }

    private final boolean shouldShowSendMessageButton() {
        return AppConfigExtensionsKt.canStartNewConversation(this.appConfig) && !this.appConfig.isHelpCenterRequireSearchEnabled();
    }

    protected void onCleared() {
        super.onCleared();
        this.bus.unregister((Object)this);
    }

    public IntercomInboxViewModel() {
        this(null, null, null, null, null, 31, null);
    }

    public static final /* synthetic */ InboxRepository access$getInboxRepository$p(IntercomInboxViewModel $this) {
        return $this.inboxRepository;
    }

    public static final /* synthetic */ AppConfig access$getAppConfig$p(IntercomInboxViewModel $this) {
        return $this.appConfig;
    }

    public static final /* synthetic */ Bus access$getBus$p(IntercomInboxViewModel $this) {
        return $this.bus;
    }

    public static final /* synthetic */ List access$combineConversations(IntercomInboxViewModel $this, List newConversations) {
        return $this.combineConversations(newConversations);
    }

    public static final /* synthetic */ IntercomDataLayer access$getIntercomDataLayer$p(IntercomInboxViewModel $this) {
        return $this.intercomDataLayer;
    }

    public static final /* synthetic */ boolean access$shouldShowSendMessageButton(IntercomInboxViewModel $this) {
        return $this.shouldShowSendMessageButton();
    }

    public static final /* synthetic */ MutableStateFlow access$get_state$p(IntercomInboxViewModel $this) {
        return $this._state;
    }

    public static final /* synthetic */ MutableSharedFlow access$get_effect$p(IntercomInboxViewModel $this) {
        return $this._effect;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0003*\u0001\b\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\r\u0010\u0007\u001a\u00020\bH\u0002\u00a2\u0006\u0002\u0010\t\u00a8\u0006\n"}, d2={"Lio/intercom/android/sdk/inbox/IntercomInboxViewModel$Companion;", "", "()V", "create", "Lio/intercom/android/sdk/inbox/IntercomInboxViewModel;", "owner", "Landroidx/lifecycle/ViewModelStoreOwner;", "factory", "io/intercom/android/sdk/inbox/IntercomInboxViewModel$Companion$factory$1", "()Lio/intercom/android/sdk/inbox/IntercomInboxViewModel$Companion$factory$1;", "intercom-sdk-base_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final IntercomInboxViewModel create(@NotNull ViewModelStoreOwner owner) {
            Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
            return (IntercomInboxViewModel)new ViewModelProvider(owner, (ViewModelProvider.Factory)this.factory()).get(IntercomInboxViewModel.class);
        }

        private final factory.1 factory() {
            return new ViewModelProvider.Factory(){

                @NotNull
                public <T extends ViewModel> T create(@NotNull Class<T> modelClass) {
                    Intrinsics.checkNotNullParameter(modelClass, (String)"modelClass");
                    return (T)((Object)new IntercomInboxViewModel(null, null, null, null, null, 31, null));
                }
            };
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

