/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.api;

import android.content.ContentResolver;
import android.net.Uri;
import com.intercom.input.gallery.GalleryImage;
import io.intercom.android.sdk.conversation.UploadProgressListener;
import io.intercom.android.sdk.utilities.CloseableExtensionsKt;
import java.io.Closeable;
import java.io.InputStream;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import okio.BufferedSink;
import okio.Okio;
import okio.Source;

class ProgressRequestBody
extends RequestBody {
    private static final int SEGMENT_SIZE = 2048;
    private static final int SMOOTH_END_MIN_VALUE = 90;
    private final MediaType contentType;
    private final GalleryImage image;
    private final ContentResolver contentResolver;
    private final UploadProgressListener listener;

    public ProgressRequestBody(MediaType contentType, GalleryImage image, ContentResolver contentResolver, UploadProgressListener listener2) {
        this.contentType = contentType;
        this.image = image;
        this.contentResolver = contentResolver;
        this.listener = listener2;
    }

    public long contentLength() {
        return this.image.getFileSize();
    }

    public MediaType contentType() {
        return this.contentType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTo(BufferedSink sink) {
        Uri uri = this.image.getUri();
        if (uri != Uri.EMPTY) {
            boolean uploadSmoothEnded = false;
            int fileSize = this.image.getFileSize();
            Source source = null;
            try {
                InputStream in = this.contentResolver.openInputStream(uri);
                source = Okio.source((InputStream)in);
                if (this.image.isVideo()) {
                    sink.writeAll((Source)Okio.buffer((Source)source));
                } else {
                    long read;
                    long total = 0L;
                    while ((read = source.read(sink.buffer(), 2048L)) != -1L) {
                        sink.flush();
                        byte progress = this.calculateProgress(total += read, fileSize);
                        if (progress >= 90) {
                            if (uploadSmoothEnded) continue;
                            uploadSmoothEnded = true;
                            this.listener.uploadSmoothEnd();
                            continue;
                        }
                        this.listener.uploadNotice(progress);
                    }
                }
                CloseableExtensionsKt.closeQuietly((Closeable)source);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                CloseableExtensionsKt.closeQuietly(source);
            }
        }
    }

    private byte calculateProgress(long total, int fileSize) {
        if (fileSize <= 0) {
            return 100;
        }
        return (byte)(total * 100L / (long)fileSize);
    }
}

