/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.views;

import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import io.intercom.android.sdk.views.EndlessScrollListener;

public class EndlessRecyclerScrollListener
extends RecyclerView.OnScrollListener {
    private final LinearLayoutManager layoutManager;
    final EndlessScrollListener endlessScrollListener;
    private boolean morePagesAvailable = true;

    public EndlessRecyclerScrollListener(LinearLayoutManager layoutManager, EndlessScrollListener endlessScrollListener) {
        this.layoutManager = layoutManager;
        this.endlessScrollListener = endlessScrollListener;
    }

    public void onScrolled(RecyclerView recyclerView, int dx, int dy) {
        super.onScrolled(recyclerView, dx, dy);
        int visibleItemCount = recyclerView.getChildCount();
        int totalItemCount = this.layoutManager.getItemCount();
        int firstVisibleItem = this.layoutManager.findFirstVisibleItemPosition();
        if (totalItemCount - visibleItemCount <= firstVisibleItem && this.morePagesAvailable) {
            recyclerView.post(new Runnable(){

                @Override
                public void run() {
                    EndlessRecyclerScrollListener.this.endlessScrollListener.onLoadMore();
                }
            });
        }
    }

    public void onScrollStateChanged(RecyclerView recyclerView, int newState2) {
        super.onScrollStateChanged(recyclerView, newState2);
        this.endlessScrollListener.setOverScrollColour();
    }

    public void setMorePagesAvailable(boolean morePagesAvailable) {
        this.morePagesAvailable = morePagesAvailable;
    }
}

