/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.overlay;

import android.content.Context;
import android.text.TextUtils;
import io.intercom.android.sdk.Injector;
import io.intercom.android.sdk.Provider;
import io.intercom.android.sdk.activities.IntercomConversationActivity;
import io.intercom.android.sdk.identity.AppConfig;
import io.intercom.android.sdk.m5.IntercomRootActivityLauncher;
import io.intercom.android.sdk.metrics.MetricTracker;
import io.intercom.android.sdk.models.LastParticipatingAdmin;
import io.intercom.android.sdk.state.State;
import io.intercom.android.sdk.state.UiState;
import io.intercom.android.sdk.store.Store;

@Deprecated
public class LauncherOpenBehaviour {
    private final Store<State> store;
    private final LauncherType launcherType;
    private final MetricTracker metricTracker;
    private final AppConfig appConfig;

    public LauncherOpenBehaviour(Store<State> store2, LauncherType launcherType, MetricTracker metricTracker, Provider<AppConfig> appConfigProvider2) {
        this.store = store2;
        this.launcherType = launcherType;
        this.metricTracker = metricTracker;
        this.appConfig = appConfigProvider2.get();
    }

    public void openMessenger(Context context) {
        Injector.get().getMetricTracker().clickedLauncher();
        IntercomRootActivityLauncher.INSTANCE.startHome(context);
    }

    private void openLastOrDefaultState(Context context) {
        UiState uiState = this.store.state().uiState();
        switch (uiState.screen()) {
            case CONVERSATION: {
                String lastViewedConversationId = uiState.conversationId();
                if (TextUtils.isEmpty((CharSequence)lastViewedConversationId)) {
                    this.presentHome(context);
                    break;
                }
                this.presentConversation(context, lastViewedConversationId);
                break;
            }
            case COMPOSER: {
                this.presentComposer(context);
                break;
            }
            default: {
                this.presentHome(context);
            }
        }
    }

    private void presentConversation(Context context, String conversationId) {
        this.metricTracker.openedMessengerConversation(conversationId, this.launcherType);
        LastParticipatingAdmin unknownAdmin = LastParticipatingAdmin.NULL;
        context.startActivity(IntercomConversationActivity.Companion.openConversation(context, conversationId, unknownAdmin));
    }

    private void presentComposer(Context context) {
        this.metricTracker.openedMessengerNewConversation(this.launcherType);
        context.startActivity(IntercomConversationActivity.Companion.openComposer(context, ""));
    }

    private void presentHome(Context context) {
        IntercomRootActivityLauncher.INSTANCE.startHome(context);
    }

    public static enum LauncherType {
        DEFAULT,
        CUSTOM;

    }
}

