/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.identity;

import android.content.Context;
import android.content.SharedPreferences;
import androidx.annotation.VisibleForTesting;
import io.intercom.android.sdk.identity.Registration;
import io.intercom.android.sdk.identity.SoftUserIdentity;
import io.intercom.android.sdk.models.User;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public class UserIdentity {
    private static final String KEY_PREFIX = "intercomsdk-session-";
    private static final String KEY_ANONYMOUS_ID = "INTERCOM_SDK_ANONYMOUS_ID";
    private static final String KEY_INTERCOM_ID = "INTERCOM_SDK_INTERCOM_ID";
    private static final String KEY_USER_ID = "INTERCOM_SDK_USER_ID";
    private static final String KEY_EMAIL_ID = "INTERCOM_SDK_EMAIL_ID";
    private static final String KEY_SECURE_HMAC = "SecureMode_HMAC";
    private static final String USER = "user";
    private static final String TYPE = "type";
    private static final String USER_ID = "user_id";
    public static final String EMAIL = "email";
    public static final String ANONYMOUS_ID = "anonymous_id";
    public static final String INTERCOM_ID = "intercom_id";
    private final SharedPreferences prefs;
    private String hmac;
    private String anonymousId;
    private String intercomId;
    private String encryptedUserId;
    private String userId;
    private String email;
    private String fingerprint = "";
    private SoftUserIdentity softUserIdentity = SoftUserIdentity.NONE;

    public UserIdentity(Context context) {
        this.prefs = context.getSharedPreferences("INTERCOM_SDK_USER_PREFS", 0);
        this.anonymousId = this.prefs.getString("intercomsdk-session-INTERCOM_SDK_ANONYMOUS_ID", "");
        this.intercomId = this.prefs.getString("intercomsdk-session-INTERCOM_SDK_INTERCOM_ID", "");
        this.userId = this.prefs.getString("intercomsdk-session-INTERCOM_SDK_USER_ID", "");
        this.email = this.prefs.getString("intercomsdk-session-INTERCOM_SDK_EMAIL_ID", "");
        this.hmac = this.prefs.getString("intercomsdk-session-SecureMode_HMAC", "");
        this.encryptedUserId = "";
        if (this.identityExists()) {
            this.fingerprint = this.generateFingerprint();
        }
    }

    public boolean canRegisterIdentifiedUser(Registration registration) {
        return registration.isValidRegistration() && !this.isIdentified();
    }

    public boolean canRegisterUnidentifiedUser() {
        return !this.identityExists();
    }

    public void registerIdentifiedUser(Registration registration) {
        this.intercomId = "";
        SharedPreferences.Editor editor = this.prefs.edit().putString("intercomsdk-session-INTERCOM_SDK_INTERCOM_ID", this.intercomId);
        if (!registration.getUserId().isEmpty()) {
            this.userId = registration.getUserId();
            editor.putString("intercomsdk-session-INTERCOM_SDK_USER_ID", this.userId);
        }
        if (!registration.getEmail().isEmpty()) {
            this.email = registration.getEmail();
            editor.putString("intercomsdk-session-INTERCOM_SDK_EMAIL_ID", this.email);
        }
        editor.apply();
        if (this.fingerprint.isEmpty()) {
            this.fingerprint = this.generateFingerprint();
        }
    }

    public void registerUnidentifiedUser() {
        this.anonymousId = UUID.randomUUID().toString();
        this.prefs.edit().putString("intercomsdk-session-INTERCOM_SDK_ANONYMOUS_ID", this.anonymousId).apply();
        if (this.fingerprint.isEmpty()) {
            this.fingerprint = this.generateFingerprint();
        }
    }

    public void update(User user) {
        if (user == User.NULL) {
            return;
        }
        this.userId = user.getUserId();
        this.email = user.getEmail();
        this.anonymousId = user.getAnonymousId();
        this.encryptedUserId = user.getEncryptedUserId();
        SharedPreferences.Editor editor = this.prefs.edit().putString("intercomsdk-session-INTERCOM_SDK_USER_ID", this.userId).putString("intercomsdk-session-INTERCOM_SDK_EMAIL_ID", this.email).putString("intercomsdk-session-INTERCOM_SDK_ANONYMOUS_ID", this.anonymousId);
        if (!user.getIntercomId().isEmpty()) {
            this.intercomId = user.getIntercomId();
            editor.putString("intercomsdk-session-INTERCOM_SDK_INTERCOM_ID", this.intercomId);
        }
        editor.apply();
    }

    public void setUserHash(String hmac) {
        this.hmac = hmac;
        this.prefs.edit().putString("intercomsdk-session-SecureMode_HMAC", hmac).apply();
    }

    public String getUserId() {
        return this.userId;
    }

    public String getEmail() {
        return this.email;
    }

    public String getAnonymousId() {
        return this.anonymousId;
    }

    public String getHmac() {
        return this.hmac;
    }

    public String getIntercomId() {
        return this.intercomId;
    }

    public String getEncryptedUserId() {
        return this.encryptedUserId;
    }

    public String getFingerprint() {
        return this.fingerprint;
    }

    public boolean hasIntercomId() {
        return !this.getIntercomId().isEmpty();
    }

    public boolean identityExists() {
        return !this.email.isEmpty() || !this.userId.isEmpty() || !this.intercomId.isEmpty() || !this.anonymousId.isEmpty();
    }

    public boolean isIdentified() {
        return this.identityExists() && !this.isUnidentified();
    }

    public boolean isUnidentified() {
        return !this.anonymousId.isEmpty() && this.email.isEmpty() && this.userId.isEmpty();
    }

    public void hardReset() {
        this.softUserIdentity = SoftUserIdentity.NONE;
    }

    public Map<String, Object> toMap() {
        HashMap<String, Object> map2 = new HashMap<String, Object>();
        if (!this.anonymousId.isEmpty()) {
            map2.put(ANONYMOUS_ID, this.anonymousId);
        } else if (!this.intercomId.isEmpty()) {
            map2.put(INTERCOM_ID, this.intercomId);
        }
        if (!this.userId.isEmpty()) {
            map2.put(USER_ID, this.userId);
        }
        if (!this.email.isEmpty()) {
            map2.put(EMAIL, this.email);
        }
        map2.put(TYPE, USER);
        return map2;
    }

    private String generateFingerprint() {
        return UUID.randomUUID().toString();
    }

    public boolean registrationHasAttributes(Registration userRegistration) {
        return userRegistration != null && userRegistration.getAttributes() != null && !userRegistration.getAttributes().isEmpty();
    }

    public boolean isSameUser(Registration userRegistration) {
        if (this.isUnidentified()) {
            return false;
        }
        return this.softUserIdentity.isSameUser(userRegistration);
    }

    public boolean softUserIdentityHmacDiffers(String hmac) {
        return this.softUserIdentity.isPresent() && !this.getSoftUserIdentityHmac().equals(hmac);
    }

    @VisibleForTesting
    public String getSoftUserIdentityHmac() {
        return this.softUserIdentity.hmac();
    }

    public void softReset() {
        if (!this.isSoftReset()) {
            this.softUserIdentity = SoftUserIdentity.create(this.anonymousId, this.email, this.fingerprint, this.hmac, this.intercomId, this.userId, this.encryptedUserId);
            this.prefs.edit().clear().apply();
            this.anonymousId = "";
            this.intercomId = "";
            this.encryptedUserId = "";
            this.userId = "";
            this.email = "";
            this.hmac = "";
            this.fingerprint = "";
        }
    }

    public boolean isSoftReset() {
        return this.softUserIdentity.isPresent();
    }

    public void softRestart() {
        this.userId = this.softUserIdentity.userId();
        this.email = this.softUserIdentity.email();
        this.anonymousId = this.softUserIdentity.anonymousId();
        this.intercomId = this.softUserIdentity.intercomId();
        this.encryptedUserId = this.softUserIdentity.encryptedUserId();
        this.hmac = this.softUserIdentity.hmac();
        this.fingerprint = this.softUserIdentity.fingerprint();
        this.prefs.edit().putString("intercomsdk-session-INTERCOM_SDK_USER_ID", this.userId).putString("intercomsdk-session-INTERCOM_SDK_EMAIL_ID", this.email).putString("intercomsdk-session-INTERCOM_SDK_ANONYMOUS_ID", this.anonymousId).putString("intercomsdk-session-INTERCOM_SDK_INTERCOM_ID", this.intercomId).apply();
        this.softUserIdentity = SoftUserIdentity.NONE;
    }
}

