/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.helpcenter.webview;

import android.webkit.JavascriptInterface;
import android.webkit.WebView;
import com.google.gson.Gson;
import io.intercom.android.sdk.api.Api;
import io.intercom.android.sdk.helpcenter.webview.HelpCenterWebViewAction;
import io.intercom.android.sdk.metrics.MetricTracker;
import java.util.HashMap;
import java.util.Map;

public class HelpCenterWebViewInterface {
    private final WebView webView;
    private final Gson gson;
    private final MetricTracker metricTracker;
    private final Api api;
    private final boolean isFromSearchBrowse;
    public static final String METRIC_EVENT = "METRIC_EVENT";
    public static final String TRACK_REACTION = "TRACK_REACTION";

    public HelpCenterWebViewInterface(WebView webView, Gson gson, MetricTracker metricTracker, Api api, boolean isFromSearchBrowse) {
        this.webView = webView;
        this.gson = gson;
        this.metricTracker = metricTracker;
        this.api = api;
        this.isFromSearchBrowse = isFromSearchBrowse;
    }

    @JavascriptInterface
    public void handleAction(String actionJson) {
        HelpCenterWebViewAction action = (HelpCenterWebViewAction)this.gson.fromJson(actionJson, HelpCenterWebViewAction.class);
        String type = action.getType();
        Map<String, Object> actionValue = action.getValue();
        if (type == null || actionValue == null) {
            return;
        }
        switch (type) {
            case "METRIC_EVENT": {
                this.webView.post(() -> {
                    String eventAction = (String)actionValue.get("action");
                    String eventObject = (String)actionValue.get("object");
                    String eventPlace = (String)actionValue.get("place");
                    HashMap<String, Object> eventMetaData = new HashMap<String, Object>();
                    if (actionValue.get("metadata") instanceof Map) {
                        eventMetaData.putAll((Map)actionValue.get("metadata"));
                    }
                    if (this.isFromSearchBrowse) {
                        eventMetaData.put("article_source", "search_browse");
                    }
                    this.metricTracker.educateWebviewMetric(eventAction, eventObject, eventPlace, eventMetaData, "from_help_center_webview");
                });
                break;
            }
            case "TRACK_REACTION": {
                this.webView.post(() -> {
                    Double articleId = (Double)actionValue.get("article_id");
                    Double articleContentId = (Double)actionValue.get("article_content_id");
                    Double reactionIndex = (Double)actionValue.get("reaction_index");
                    if (articleId == null || articleContentId == null || reactionIndex == null) {
                        return;
                    }
                    this.api.reactToLink(String.valueOf(articleId.intValue()), String.valueOf(articleContentId.intValue()), reactionIndex.intValue(), true);
                });
                break;
            }
        }
    }
}

