/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.survey;

import androidx.compose.foundation.relocation.BringIntoViewRequester;
import androidx.compose.foundation.relocation.BringIntoViewRequesterKt;
import androidx.compose.runtime.MutableState;
import androidx.compose.runtime.SnapshotStateKt;
import androidx.compose.runtime.State;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.survey.SurveyUiColors;
import io.intercom.android.sdk.survey.ValidationError;
import io.intercom.android.sdk.survey.model.SurveyData;
import io.intercom.android.sdk.survey.ui.models.Answer;
import io.intercom.android.sdk.utilities.AttributeValidatorUtils;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Job;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0080\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"J\t\u0010#\u001a\u00020\u0003H\u00c6\u0003J\t\u0010$\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010%\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010&\u001a\u00020'2\b\u0010(\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010)\u001a\u00020*H\u00d6\u0001J\t\u0010+\u001a\u00020,H\u00d6\u0001J\u0006\u0010-\u001a\u00020.R+\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b8F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R+\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u0007\u001a\u00020\u00188F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u001e\u0010\u000f\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001d\u00a8\u0006/"}, d2={"Lio/intercom/android/sdk/survey/QuestionState;", "", "questionModel", "Lio/intercom/android/sdk/survey/model/SurveyData$Step$Question$QuestionModel;", "surveyUiColors", "Lio/intercom/android/sdk/survey/SurveyUiColors;", "(Lio/intercom/android/sdk/survey/model/SurveyData$Step$Question$QuestionModel;Lio/intercom/android/sdk/survey/SurveyUiColors;)V", "<set-?>", "Lio/intercom/android/sdk/survey/ui/models/Answer;", "answer", "getAnswer", "()Lio/intercom/android/sdk/survey/ui/models/Answer;", "setAnswer", "(Lio/intercom/android/sdk/survey/ui/models/Answer;)V", "answer$delegate", "Landroidx/compose/runtime/MutableState;", "bringIntoViewRequester", "Landroidx/compose/foundation/relocation/BringIntoViewRequester;", "getBringIntoViewRequester", "()Landroidx/compose/foundation/relocation/BringIntoViewRequester;", "getQuestionModel", "()Lio/intercom/android/sdk/survey/model/SurveyData$Step$Question$QuestionModel;", "getSurveyUiColors", "()Lio/intercom/android/sdk/survey/SurveyUiColors;", "Lio/intercom/android/sdk/survey/ValidationError;", "validationError", "getValidationError", "()Lio/intercom/android/sdk/survey/ValidationError;", "setValidationError", "(Lio/intercom/android/sdk/survey/ValidationError;)V", "validationError$delegate", "bringIntoView", "Lkotlinx/coroutines/Job;", "compositionAwareScope", "Lkotlinx/coroutines/CoroutineScope;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "validate", "", "intercom-sdk-base_release"})
public final class QuestionState {
    @NotNull
    private final SurveyData.Step.Question.QuestionModel questionModel;
    @NotNull
    private final SurveyUiColors surveyUiColors;
    @NotNull
    private final MutableState validationError$delegate;
    @NotNull
    private final MutableState answer$delegate;
    @NotNull
    private final BringIntoViewRequester bringIntoViewRequester;

    public QuestionState(@NotNull SurveyData.Step.Question.QuestionModel questionModel, @NotNull SurveyUiColors surveyUiColors) {
        Intrinsics.checkNotNullParameter((Object)questionModel, (String)"questionModel");
        Intrinsics.checkNotNullParameter((Object)surveyUiColors, (String)"surveyUiColors");
        this.questionModel = questionModel;
        this.surveyUiColors = surveyUiColors;
        this.validationError$delegate = SnapshotStateKt.mutableStateOf$default((Object)ValidationError.Unchecked.INSTANCE, null, (int)2, null);
        this.answer$delegate = SnapshotStateKt.mutableStateOf$default((Object)Answer.NoAnswer.InitialNoAnswer.INSTANCE, null, (int)2, null);
        this.bringIntoViewRequester = BringIntoViewRequesterKt.BringIntoViewRequester();
    }

    @NotNull
    public final SurveyData.Step.Question.QuestionModel getQuestionModel() {
        return this.questionModel;
    }

    @NotNull
    public final SurveyUiColors getSurveyUiColors() {
        return this.surveyUiColors;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ValidationError getValidationError() {
        void $this$getValue$iv;
        State state = (State)this.validationError$delegate;
        Object property$iv = null;
        boolean $i$f$getValue = false;
        return (ValidationError)$this$getValue$iv.getValue();
    }

    /*
     * WARNING - void declaration
     */
    public final void setValidationError(@NotNull ValidationError validationError) {
        void $this$setValue$iv;
        Intrinsics.checkNotNullParameter((Object)validationError, (String)"<set-?>");
        MutableState mutableState = this.validationError$delegate;
        Object property$iv = null;
        boolean $i$f$setValue = false;
        $this$setValue$iv.setValue((Object)validationError);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Answer getAnswer() {
        void $this$getValue$iv;
        State state = (State)this.answer$delegate;
        Object property$iv = null;
        boolean $i$f$getValue = false;
        return (Answer)$this$getValue$iv.getValue();
    }

    /*
     * WARNING - void declaration
     */
    public final void setAnswer(@NotNull Answer answer) {
        void $this$setValue$iv;
        Intrinsics.checkNotNullParameter((Object)answer, (String)"<set-?>");
        MutableState mutableState = this.answer$delegate;
        Object property$iv = null;
        boolean $i$f$setValue = false;
        $this$setValue$iv.setValue((Object)answer);
    }

    @NotNull
    public final BringIntoViewRequester getBringIntoViewRequester() {
        return this.bringIntoViewRequester;
    }

    /*
     * WARNING - void declaration
     */
    public final void validate() {
        if (this.getAnswer() instanceof Answer.NoAnswer && this.questionModel.isRequired()) {
            this.setValidationError(new ValidationError.ValidationStringError(R.string.intercom_surveys_required_response, null, 2, null));
            return;
        }
        if (this.getAnswer() instanceof Answer.NoAnswer) {
            this.setValidationError(ValidationError.NoValidationError.INSTANCE);
            return;
        }
        SurveyData.Step.Question.QuestionModel questionModel = this.questionModel;
        if (questionModel instanceof SurveyData.Step.Question.MultipleChoiceQuestionModel) {
            if (this.getAnswer() instanceof Answer.MultipleAnswer) {
                Answer answer = this.getAnswer();
                Intrinsics.checkNotNull((Object)answer, (String)"null cannot be cast to non-null type io.intercom.android.sdk.survey.ui.models.Answer.MultipleAnswer");
                Answer.MultipleAnswer multipleAnswer = (Answer.MultipleAnswer)answer;
                int selectedAnswersCount = ((Collection)multipleAnswer.getAnswers()).size();
                if (selectedAnswersCount < ((SurveyData.Step.Question.MultipleChoiceQuestionModel)this.questionModel).getMinSelection()) {
                    this.setValidationError(new ValidationError.ValidationStringError(R.string.intercom_surveys_multi_select_too_few_responses, CollectionsKt.listOf((Object)TuplesKt.to((Object)"response_count", (Object)String.valueOf(((SurveyData.Step.Question.MultipleChoiceQuestionModel)this.questionModel).getMinSelection())))));
                } else if (selectedAnswersCount > ((SurveyData.Step.Question.MultipleChoiceQuestionModel)this.questionModel).getMaxSelection()) {
                    this.setValidationError(new ValidationError.ValidationStringError(R.string.intercom_surveys_multi_select_too_many_responses, CollectionsKt.listOf((Object)TuplesKt.to((Object)"response_count", (Object)String.valueOf(((SurveyData.Step.Question.MultipleChoiceQuestionModel)this.questionModel).getMaxSelection())))));
                } else {
                    this.setValidationError(ValidationError.NoValidationError.INSTANCE);
                }
            }
        } else if (questionModel instanceof SurveyData.Step.Question.ShortTextQuestionModel) {
            ValidationError validationError;
            QuestionState questionState = this;
            if (((SurveyData.Step.Question.ShortTextQuestionModel)this.questionModel).getCharacterLimit() != null && this.getAnswer().getLength() > ((SurveyData.Step.Question.ShortTextQuestionModel)this.questionModel).getCharacterLimit()) {
                validationError = new ValidationError.ValidationStringError(R.string.intercom_surveys_response_too_long, CollectionsKt.listOf((Object)TuplesKt.to((Object)"character_count", (Object)String.valueOf(((SurveyData.Step.Question.ShortTextQuestionModel)this.questionModel).getCharacterLimit()))));
            } else {
                void it;
                String string2;
                switch (WhenMappings.$EnumSwitchMapping$0[((SurveyData.Step.Question.ShortTextQuestionModel)this.questionModel).getValidationType().ordinal()]) {
                    case 1: 
                    case 2: {
                        string2 = "text";
                        break;
                    }
                    case 3: {
                        string2 = "number";
                        break;
                    }
                    case 4: {
                        string2 = "email";
                        break;
                    }
                    case 5: {
                        string2 = "phone";
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                String attributeType = string2;
                Answer answer = this.getAnswer();
                QuestionState questionState2 = questionState;
                boolean bl = false;
                questionState = questionState2;
                int attributeResponseCode = AttributeValidatorUtils.validateAttribute(it instanceof Answer.SingleAnswer ? ((Answer.SingleAnswer)it).getAnswer() : "", attributeType);
                switch (attributeResponseCode) {
                    case 1: {
                        validationError = new ValidationError.ValidationStringError(R.string.intercom_string_is_incorrect, null, 2, null);
                        break;
                    }
                    case 2: {
                        validationError = new ValidationError.ValidationStringError(R.string.intercom_surveys_email_error, null, 2, null);
                        break;
                    }
                    case 3: {
                        validationError = new ValidationError.ValidationStringError(R.string.intercom_number_is_incorrect, null, 2, null);
                        break;
                    }
                    case 4: {
                        validationError = new ValidationError.ValidationStringError(R.string.intercom_that_number_needs_a_prefix, null, 2, null);
                        break;
                    }
                    case 5: {
                        validationError = new ValidationError.ValidationStringError(R.string.intercom_that_number_has_too_many_digits, null, 2, null);
                        break;
                    }
                    case 6: {
                        validationError = new ValidationError.ValidationStringError(R.string.intercom_that_country_code_doesnt_look_quite_right, null, 2, null);
                        break;
                    }
                    case 7: {
                        validationError = new ValidationError.ValidationStringError(R.string.intercom_that_number_is_missing_a_few_digits, null, 2, null);
                        break;
                    }
                    default: {
                        validationError = ValidationError.NoValidationError.INSTANCE;
                    }
                }
            }
            questionState.setValidationError(validationError);
        } else if (questionModel instanceof SurveyData.Step.Question.LongTextQuestionModel) {
            this.setValidationError(((SurveyData.Step.Question.LongTextQuestionModel)this.questionModel).getCharacterLimit() != null && this.getAnswer().getLength() > ((SurveyData.Step.Question.LongTextQuestionModel)this.questionModel).getCharacterLimit() ? (ValidationError)new ValidationError.ValidationStringError(R.string.intercom_surveys_response_too_long, CollectionsKt.listOf((Object)TuplesKt.to((Object)"character_count", (Object)String.valueOf(((SurveyData.Step.Question.LongTextQuestionModel)this.questionModel).getCharacterLimit())))) : (ValidationError)ValidationError.NoValidationError.INSTANCE);
        } else {
            this.setValidationError(ValidationError.NoValidationError.INSTANCE);
        }
    }

    @NotNull
    public final Job bringIntoView(@NotNull CoroutineScope compositionAwareScope) {
        Intrinsics.checkNotNullParameter((Object)compositionAwareScope, (String)"compositionAwareScope");
        return BuildersKt.launch$default((CoroutineScope)compositionAwareScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ QuestionState this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = BringIntoViewRequester.bringIntoView$default((BringIntoViewRequester)this.this$0.getBringIntoViewRequester(), null, (Continuation)((Continuation)this), (int)1, null);
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    @NotNull
    public final SurveyData.Step.Question.QuestionModel component1() {
        return this.questionModel;
    }

    @NotNull
    public final SurveyUiColors component2() {
        return this.surveyUiColors;
    }

    @NotNull
    public final QuestionState copy(@NotNull SurveyData.Step.Question.QuestionModel questionModel, @NotNull SurveyUiColors surveyUiColors) {
        Intrinsics.checkNotNullParameter((Object)questionModel, (String)"questionModel");
        Intrinsics.checkNotNullParameter((Object)surveyUiColors, (String)"surveyUiColors");
        return new QuestionState(questionModel, surveyUiColors);
    }

    public static /* synthetic */ QuestionState copy$default(QuestionState questionState, SurveyData.Step.Question.QuestionModel questionModel, SurveyUiColors surveyUiColors, int n, Object object) {
        if ((n & 1) != 0) {
            questionModel = questionState.questionModel;
        }
        if ((n & 2) != 0) {
            surveyUiColors = questionState.surveyUiColors;
        }
        return questionState.copy(questionModel, surveyUiColors);
    }

    @NotNull
    public String toString() {
        return "QuestionState(questionModel=" + this.questionModel + ", surveyUiColors=" + this.surveyUiColors + ')';
    }

    public int hashCode() {
        int result = this.questionModel.hashCode();
        result = result * 31 + this.surveyUiColors.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof QuestionState)) {
            return false;
        }
        QuestionState questionState = (QuestionState)other;
        if (!Intrinsics.areEqual((Object)this.questionModel, (Object)questionState.questionModel)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.surveyUiColors, (Object)questionState.surveyUiColors);
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[SurveyData.Step.Question.QuestionValidation.ValidationType.values().length];
            nArray[SurveyData.Step.Question.QuestionValidation.ValidationType.TEXT.ordinal()] = 1;
            nArray[SurveyData.Step.Question.QuestionValidation.ValidationType.NO_VALIDATION.ordinal()] = 2;
            nArray[SurveyData.Step.Question.QuestionValidation.ValidationType.NUMBER.ordinal()] = 3;
            nArray[SurveyData.Step.Question.QuestionValidation.ValidationType.EMAIL.ordinal()] = 4;
            nArray[SurveyData.Step.Question.QuestionValidation.ValidationType.PHONE.ordinal()] = 5;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

