/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.sheets;

import android.webkit.JavascriptInterface;
import android.webkit.WebView;
import com.google.gson.Gson;
import io.intercom.android.sdk.api.Api;
import io.intercom.android.sdk.helpcenter.webview.HelpCenterWebViewInterface;
import io.intercom.android.sdk.metrics.MetricTracker;
import io.intercom.android.sdk.sheets.SheetListener;
import io.intercom.android.sdk.sheets.SheetWebViewAction;
import java.util.Map;

public class SheetWebViewInterface {
    private static final String SHEET_TITLE = "set-title";
    private static final String CLOSE_SHEET = "close";
    private static final String SUBMIT_SHEET = "submit-sheet";
    private static final String PAYLOAD_SHEET_TITLE = "title";
    private final WebView webView;
    private final MetricTracker metricTracker;
    private final Api api;
    private final Gson gson;
    private final SheetListener listener;

    SheetWebViewInterface(WebView webView, Gson gson, MetricTracker metricTracker, Api api, SheetListener listener) {
        this.webView = webView;
        this.gson = gson;
        this.listener = listener;
        this.metricTracker = metricTracker;
        this.api = api;
    }

    @JavascriptInterface
    public void handleAction(String actionJson) {
        SheetWebViewAction action = (SheetWebViewAction)this.gson.fromJson(actionJson, SheetWebViewAction.class);
        String type = action.getType();
        final Map<String, Object> payload = action.getPayload();
        if (this.isHelpCenterMetric(type)) {
            HelpCenterWebViewInterface helpCenterWebViewInterface = new HelpCenterWebViewInterface(this.webView, this.gson, this.metricTracker, this.api, false);
            helpCenterWebViewInterface.handleAction(actionJson);
            return;
        }
        if (type == null || payload == null) {
            return;
        }
        switch (type) {
            case "set-title": {
                this.webView.post(new Runnable(){

                    @Override
                    public void run() {
                        SheetWebViewInterface.this.listener.onSheetTitleAction(payload.get(SheetWebViewInterface.PAYLOAD_SHEET_TITLE).toString());
                    }
                });
                break;
            }
            case "close": {
                this.webView.post(new Runnable(){

                    @Override
                    public void run() {
                        SheetWebViewInterface.this.listener.onCloseSheetAction();
                    }
                });
                break;
            }
            case "submit-sheet": {
                this.webView.post(new Runnable(){

                    @Override
                    public void run() {
                        SheetWebViewInterface.this.listener.onSubmitSheetAction(payload);
                    }
                });
                break;
            }
        }
    }

    private boolean isHelpCenterMetric(String type) {
        return "METRIC_EVENT".equals(type) || "TRACK_REACTION".equals(type);
    }
}

