/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.carousel.permission;

import androidx.annotation.RequiresApi;
import io.intercom.android.sdk.carousel.PermissionManager;
import io.intercom.android.sdk.carousel.permission.PermissionRequestBefore30;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RequiresApi(api=30)
class PermissionRequest30
extends PermissionRequestBefore30 {
    PermissionRequest30(PermissionManager permissionManager) {
        super(permissionManager);
    }

    @Override
    protected void handleRequest(List<String> permissions, int requestCode) {
        permissions.remove("android.permission.ACCESS_BACKGROUND_LOCATION");
        super.handleRequest(permissions, requestCode);
    }

    @Override
    protected void handleGranted(String[] permissions) {
        if (this.askForBackgroundPermission(Arrays.asList(permissions))) {
            if (this.isBackgroundPermissionDeniedPermanently()) {
                this.getListener().showDeniedPermanently();
            } else {
                this.getListener().requestBackgroundLocationPermission();
            }
        } else {
            this.getListener().showGranted();
        }
    }

    private boolean askForBackgroundPermission(List<String> grantedPermissions) {
        return this.isLocationPermission(grantedPermissions) && this.isBackgroundPermissionInManifest();
    }

    private boolean isLocationPermission(List<String> permissionsList) {
        return permissionsList.contains("android.permission.ACCESS_COARSE_LOCATION") || permissionsList.contains("android.permission.ACCESS_FINE_LOCATION");
    }

    private boolean isBackgroundPermissionInManifest() {
        return !this.permissionManager.permissionsExistInManifest(Collections.singletonList("android.permission.ACCESS_BACKGROUND_LOCATION")).isEmpty();
    }

    private boolean isBackgroundPermissionDeniedPermanently() {
        return this.permissionManager.getPermissionStatus("android.permission.ACCESS_BACKGROUND_LOCATION") == 2;
    }
}

