/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.blocks;

import android.content.Context;
import android.graphics.Color;
import android.text.SpannableString;
import android.text.Spanned;
import android.text.TextUtils;
import android.text.method.MovementMethod;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import androidx.core.content.ContextCompat;
import com.intercom.commons.utilities.HtmlCompat;
import io.intercom.android.sdk.Provider;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.blocks.StyleType;
import io.intercom.android.sdk.blocks.lib.interfaces.OrderedListBlock;
import io.intercom.android.sdk.blocks.lib.interfaces.UnorderedListBlock;
import io.intercom.android.sdk.blocks.lib.models.BlockMetadata;
import io.intercom.android.sdk.identity.AppConfig;
import io.intercom.android.sdk.spans.OrderedListSpan;
import io.intercom.android.sdk.spans.UnorderedListSpan;
import io.intercom.android.sdk.utilities.BlockUtils;
import io.intercom.android.sdk.utilities.TrackingLinkMovementMethod;
import java.util.List;

class ListBlock
implements OrderedListBlock,
UnorderedListBlock {
    private static final int LARGE_TEXT_SIZE_SP = 16;
    private static final int SMALL_TEXT_SIZE_SP = 14;
    private final StyleType style;
    private final Provider<AppConfig> appConfigProvider;

    ListBlock(StyleType style, Provider<AppConfig> appConfigProvider2) {
        this.style = style;
        this.appConfigProvider = appConfigProvider2;
    }

    @Override
    public View addOrderedList(List<String> items, BlockMetadata blockMetadata, ViewGroup parent) {
        Context context = parent.getContext();
        TextView textview = this.getListStyledTextView(context, blockMetadata);
        int lineIndent = (int)parent.getResources().getDimension(R.dimen.intercom_list_indentation);
        CharSequence chars = "";
        int size = items.size();
        for (int i = 0; i < size; ++i) {
            String item = items.get(i);
            if (item.isEmpty()) continue;
            String delimiter = i < size - 1 ? "<br />" : "";
            Spanned source = HtmlCompat.fromHtml((String)(item + delimiter));
            SpannableString spannableString = new SpannableString((CharSequence)source);
            spannableString.setSpan((Object)new OrderedListSpan(lineIndent, i + 1 + "."), 0, source.length(), 0);
            chars = TextUtils.concat((CharSequence[])new CharSequence[]{chars, spannableString});
        }
        textview.setText(chars);
        BlockUtils.setLayoutMarginsAndGravity((View)textview, 0x800003, blockMetadata.isLastObject());
        return textview;
    }

    @Override
    public View addUnorderedList(List<String> items, BlockMetadata blockMetadata, ViewGroup parent) {
        Context context = parent.getContext();
        TextView textview = this.getListStyledTextView(context, blockMetadata);
        int lineIndent = (int)parent.getResources().getDimension(R.dimen.intercom_list_indentation);
        CharSequence chars = "";
        int size = items.size();
        for (int i = 0; i < size; ++i) {
            String item = items.get(i);
            if (item.isEmpty()) continue;
            String delimiter = i < size - 1 ? "<br />" : "";
            Spanned source = HtmlCompat.fromHtml((String)(item + delimiter));
            SpannableString spannableString = new SpannableString((CharSequence)source);
            spannableString.setSpan((Object)new UnorderedListSpan(lineIndent, context), 0, source.length(), 0);
            chars = TextUtils.concat((CharSequence[])new CharSequence[]{chars, spannableString});
        }
        textview.setText(chars);
        BlockUtils.setLayoutMarginsAndGravity((View)textview, 0x800003, blockMetadata.isLastObject());
        return textview;
    }

    private TextView getListStyledTextView(Context context, BlockMetadata blockMetadata) {
        TextView textview = new TextView(context);
        textview.setLinkTextColor(this.appConfigProvider.get().getPrimaryColor());
        textview.setMovementMethod((MovementMethod)new TrackingLinkMovementMethod());
        BlockUtils.createLayoutParams((View)textview, -2, -2);
        BlockUtils.setMarginLeft((View)textview, 4);
        switch (this.style) {
            case ADMIN: {
                int color2 = ContextCompat.getColor((Context)context, (int)R.color.intercom_grey_800);
                this.styleAsChatList(textview, color2);
                break;
            }
            case ARTICLE: 
            case NOTE: 
            case CONTAINER_CARD: {
                int color3 = ContextCompat.getColor((Context)context, (int)R.color.intercom_grey_700);
                this.styleAsAnnouncementList(textview, color3);
                break;
            }
            case POST: {
                int color4 = ContextCompat.getColor((Context)context, (int)R.color.intercom_white);
                this.styleAsAnnouncementList(textview, color4);
                break;
            }
            case CHAT_FULL: {
                int color5 = ContextCompat.getColor((Context)context, (int)R.color.intercom_grey_800);
                this.styleAsChatList(textview, color5);
                textview.setMovementMethod(null);
                break;
            }
            case CAROUSEL: {
                textview.setTextSize(20.0f);
                String textColor = blockMetadata.getAppearance().getTextColor();
                if (textColor.isEmpty()) break;
                int color6 = Color.parseColor((String)textColor);
                textview.setTextColor(color6);
                textview.setLinkTextColor(color6);
                break;
            }
            default: {
                int color7 = ContextCompat.getColor((Context)context, (int)R.color.intercom_white);
                this.styleAsChatList(textview, color7);
            }
        }
        return textview;
    }

    private void styleAsChatList(TextView textview, int colour) {
        textview.setTextSize(14.0f);
        textview.setTextColor(colour);
        BlockUtils.setDefaultMarginBottom((View)textview);
        BlockUtils.setSmallLineSpacing(textview);
    }

    private void styleAsAnnouncementList(TextView textview, int colour) {
        textview.setTextSize(16.0f);
        textview.setTextColor(colour);
        BlockUtils.setMarginBottom((View)textview, 16);
        BlockUtils.setLargeLineSpacing(textview);
    }
}

