/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.api;

import com.google.gson.JsonObject;
import com.intercom.twig.Twig;
import io.intercom.android.sdk.Injector;
import io.intercom.android.sdk.api.ErrorObject;
import io.intercom.android.sdk.api.ErrorStringExtractorKt;
import io.intercom.android.sdk.logger.LumberMill;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000\u000e\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u00a8\u0006\u0004"}, d2={"extractErrorString", "", "errorObject", "Lio/intercom/android/sdk/api/ErrorObject;", "intercom-sdk-base_release"})
public final class ErrorStringExtractorKt {
    @NotNull
    public static final String extractErrorString(@NotNull ErrorObject errorObject) {
        String string;
        Intrinsics.checkNotNullParameter((Object)errorObject, (String)"errorObject");
        Twig twig = LumberMill.getLogger();
        if (errorObject.hasErrorBody() && errorObject.getErrorBody() != null) {
            String string2;
            JsonObject jsonObject;
            try {
                jsonObject = (JsonObject)Injector.get().getGson().fromJson(errorObject.getErrorBody(), JsonObject.class);
                if (jsonObject == null) {
                    return "Something went wrong";
                }
            }
            catch (Exception e) {
                twig.e((Throwable)e);
                String string3 = errorObject.getThrowable().getMessage();
                if (string3 == null) {
                    string3 = "Something went wrong";
                }
                return string3;
            }
            JsonObject jsonObject2 = jsonObject;
            if (jsonObject2.has("error")) {
                string2 = jsonObject2.get("error").getAsString();
            } else if (jsonObject2.has("errors")) {
                jsonObject = jsonObject2.getAsJsonArray("errors");
                Intrinsics.checkNotNullExpressionValue((Object)jsonObject, (String)"jsonObject.getAsJsonArray(\"errors\")");
                string2 = CollectionsKt.joinToString$default((Iterable)((Iterable)jsonObject), (CharSequence)" - ", null, null, (int)0, null, (Function1)extractErrorString.1.INSTANCE, (int)30, null);
            } else {
                string2 = "Something went wrong";
            }
            String string4 = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"{\n        val jsonObject\u2026        }\n        }\n    }");
            string = string4;
        } else {
            string = "Something went wrong";
        }
        return string;
    }
}

