/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.utilities;

import android.app.Application;
import androidx.annotation.Nullable;
import com.intercom.twig.Twig;
import io.intercom.android.sdk.api.ApiFactory;
import io.intercom.android.sdk.logger.LumberMill;

public class ValidatorUtil {
    private static final String API_PREFIX = "android_sdk-";
    private static final Twig twig = LumberMill.getLogger();

    public static boolean isValidConstructorParams(Application application, String apiKey, String appId) {
        boolean isValid = true;
        if (application == null) {
            twig.e("The Application passed in was null.We need an Application to enable Intercom in your app", new Object[0]);
            isValid = false;
        }
        if (ValidatorUtil.appIdIsInvalid(appId)) {
            twig.e("The app ID (" + appId + ") you provided is either null or empty. We need a valid app ID to enable Intercom in your app", new Object[0]);
            isValid = false;
        }
        if (ValidatorUtil.apiKeyIsTooShort(apiKey)) {
            twig.e("The API key provided (" + apiKey + ") is too short.\nPlease check that you are using an Intercom Android SDK key and have not passed the appId into the apiKey field\n", new Object[0]);
            isValid = false;
        }
        if (ValidatorUtil.apiKeyIsMissingPrefix(apiKey)) {
            twig.e("The API key provided (" + apiKey + ") does not begin with 'android_sdk-'.\nPlease check that you are using an Intercom Android SDK key and have not passed the appId into the apiKey field\n", new Object[0]);
            isValid = false;
        }
        return isValid;
    }

    private static boolean appIdIsInvalid(@Nullable String appId) {
        return appId == null || ApiFactory.removeInvalidCharacters(appId).isEmpty();
    }

    static boolean apiKeyIsTooShort(@Nullable String apiKey) {
        return apiKey == null || apiKey.length() < 52;
    }

    static boolean apiKeyIsMissingPrefix(@Nullable String apiKey) {
        return apiKey == null || !apiKey.startsWith(API_PREFIX);
    }
}

