/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.store;

import androidx.annotation.VisibleForTesting;
import io.intercom.android.sdk.UnreadConversationCountListener;
import io.intercom.android.sdk.state.State;
import io.intercom.android.sdk.store.Selectors;
import io.intercom.android.sdk.store.Store;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class UnreadCountTracker {
    @VisibleForTesting
    final Map<UnreadConversationCountListener, Store.Subscription> listeners = new ConcurrentHashMap<UnreadConversationCountListener, Store.Subscription>();
    private final Store<State> store;

    public UnreadCountTracker(Store<State> store) {
        this.store = store;
    }

    public void addListener(final UnreadConversationCountListener listener) {
        Store.Subscriber<Integer> subscriber = new Store.Subscriber<Integer>(){

            @Override
            public void onStateChange(Integer unreadCount) {
                listener.onCountUpdate(unreadCount);
            }
        };
        Store.Subscription subscription = this.store.subscribeToChanges(Selectors.UNREAD_COUNT, subscriber);
        this.listeners.put(listener, subscription);
    }

    public void removeListener(UnreadConversationCountListener listener) {
        if (this.listeners.containsKey(listener)) {
            this.listeners.remove(listener).unsubscribe();
        }
    }
}

