/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.views.holder;

import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.recyclerview.widget.RecyclerView;
import io.intercom.android.sdk.Provider;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.identity.AppConfig;
import io.intercom.android.sdk.models.Avatar;
import io.intercom.android.sdk.models.EventData;
import io.intercom.android.sdk.models.EventParticipant;
import io.intercom.android.sdk.models.Part;
import io.intercom.android.sdk.utilities.AvatarUtils;
import io.intercom.android.sdk.views.holder.ConversationPartViewHolder;

public class EventViewHolder
extends RecyclerView.ViewHolder
implements ConversationPartViewHolder {
    private final Provider<AppConfig> appConfigProvider;
    private final TextView eventTitle;
    private final ImageView avatar;

    public EventViewHolder(View itemView, Provider<AppConfig> appConfigProvider) {
        super(itemView);
        this.appConfigProvider = appConfigProvider;
        this.eventTitle = (TextView)itemView.findViewById(R.id.event_name);
        this.avatar = (ImageView)itemView.findViewById(R.id.avatar);
    }

    @Override
    public void bind(Part part, ViewGroup blocksLayout) {
        EventData eventData = part.getEventData();
        EventParticipant participant = eventData.getParticipant();
        this.eventTitle.setText((CharSequence)eventData.getEventAsPlainText());
        AvatarUtils.loadAvatarIntoView(Avatar.create(participant.getAvatar().getImageUrl(), participant.getInitial()), this.avatar, this.appConfigProvider.get());
    }
}

